/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum ResourceType {
    AWS_EC2_CUSTOMER_GATEWAY("AWS::EC2::CustomerGateway"),
    AWS_EC2_EIP("AWS::EC2::EIP"),
    AWS_EC2_HOST("AWS::EC2::Host"),
    AWS_EC2_INSTANCE("AWS::EC2::Instance"),
    AWS_EC2_INTERNET_GATEWAY("AWS::EC2::InternetGateway"),
    AWS_EC2_NETWORK_ACL("AWS::EC2::NetworkAcl"),
    AWS_EC2_NETWORK_INTERFACE("AWS::EC2::NetworkInterface"),
    AWS_EC2_ROUTE_TABLE("AWS::EC2::RouteTable"),
    AWS_EC2_SECURITY_GROUP("AWS::EC2::SecurityGroup"),
    AWS_EC2_SUBNET("AWS::EC2::Subnet"),
    AWS_CLOUD_TRAIL_TRAIL("AWS::CloudTrail::Trail"),
    AWS_EC2_VOLUME("AWS::EC2::Volume"),
    AWS_EC2_VPC("AWS::EC2::VPC"),
    AWS_EC2_VPN_CONNECTION("AWS::EC2::VPNConnection"),
    AWS_EC2_VPN_GATEWAY("AWS::EC2::VPNGateway"),
    AWS_IAM_GROUP("AWS::IAM::Group"),
    AWS_IAM_POLICY("AWS::IAM::Policy"),
    AWS_IAM_ROLE("AWS::IAM::Role"),
    AWS_IAM_USER("AWS::IAM::User"),
    AWS_ACM_CERTIFICATE("AWS::ACM::Certificate"),
    AWS_RDS_DB_INSTANCE("AWS::RDS::DBInstance"),
    AWS_RDS_DB_SUBNET_GROUP("AWS::RDS::DBSubnetGroup"),
    AWS_RDS_DB_SECURITY_GROUP("AWS::RDS::DBSecurityGroup"),
    AWS_RDS_DB_SNAPSHOT("AWS::RDS::DBSnapshot"),
    AWS_RDS_EVENT_SUBSCRIPTION("AWS::RDS::EventSubscription"),
    AWS_ELASTIC_LOAD_BALANCING_V2_LOAD_BALANCER("AWS::ElasticLoadBalancingV2::LoadBalancer"),
    AWS_S3_BUCKET("AWS::S3::Bucket"),
    AWS_SSM_MANAGED_INSTANCE_INVENTORY("AWS::SSM::ManagedInstanceInventory"),
    AWS_REDSHIFT_CLUSTER("AWS::Redshift::Cluster"),
    AWS_REDSHIFT_CLUSTER_SNAPSHOT("AWS::Redshift::ClusterSnapshot"),
    AWS_REDSHIFT_CLUSTER_PARAMETER_GROUP("AWS::Redshift::ClusterParameterGroup"),
    AWS_REDSHIFT_CLUSTER_SECURITY_GROUP("AWS::Redshift::ClusterSecurityGroup"),
    AWS_REDSHIFT_CLUSTER_SUBNET_GROUP("AWS::Redshift::ClusterSubnetGroup"),
    AWS_REDSHIFT_EVENT_SUBSCRIPTION("AWS::Redshift::EventSubscription"),
    AWS_CLOUD_WATCH_ALARM("AWS::CloudWatch::Alarm"),
    AWS_CLOUD_FORMATION_STACK("AWS::CloudFormation::Stack"),
    AWS_DYNAMO_DB_TABLE("AWS::DynamoDB::Table"),
    AWS_AUTO_SCALING_AUTO_SCALING_GROUP("AWS::AutoScaling::AutoScalingGroup"),
    AWS_AUTO_SCALING_LAUNCH_CONFIGURATION("AWS::AutoScaling::LaunchConfiguration"),
    AWS_AUTO_SCALING_SCALING_POLICY("AWS::AutoScaling::ScalingPolicy"),
    AWS_AUTO_SCALING_SCHEDULED_ACTION("AWS::AutoScaling::ScheduledAction"),
    AWS_CODE_BUILD_PROJECT("AWS::CodeBuild::Project"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private ResourceType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ResourceType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(ResourceType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ResourceType> knownValues() {
        return Stream.of(ResourceType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

