/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.transform;

import java.time.Instant;
import java.util.List;
import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.config.model.ConfigurationItem;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ConfigurationItemMarshaller {
    private static final MarshallingInfo<String> VERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("version").isBinary(false).build();
    private static final MarshallingInfo<String> ACCOUNTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("accountId").isBinary(false).build();
    private static final MarshallingInfo<Instant> CONFIGURATIONITEMCAPTURETIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("configurationItemCaptureTime").isBinary(false).build();
    private static final MarshallingInfo<String> CONFIGURATIONITEMSTATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("configurationItemStatus").isBinary(false).build();
    private static final MarshallingInfo<String> CONFIGURATIONSTATEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("configurationStateId").isBinary(false).build();
    private static final MarshallingInfo<String> CONFIGURATIONITEMMD5HASH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("configurationItemMD5Hash").isBinary(false).build();
    private static final MarshallingInfo<String> ARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("arn").isBinary(false).build();
    private static final MarshallingInfo<String> RESOURCETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("resourceType").isBinary(false).build();
    private static final MarshallingInfo<String> RESOURCEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("resourceId").isBinary(false).build();
    private static final MarshallingInfo<String> RESOURCENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("resourceName").isBinary(false).build();
    private static final MarshallingInfo<String> AWSREGION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("awsRegion").isBinary(false).build();
    private static final MarshallingInfo<String> AVAILABILITYZONE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("availabilityZone").isBinary(false).build();
    private static final MarshallingInfo<Instant> RESOURCECREATIONTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("resourceCreationTime").isBinary(false).build();
    private static final MarshallingInfo<Map> TAGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("tags").isBinary(false).build();
    private static final MarshallingInfo<List> RELATEDEVENTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("relatedEvents").isBinary(false).build();
    private static final MarshallingInfo<List> RELATIONSHIPS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("relationships").isBinary(false).build();
    private static final MarshallingInfo<String> CONFIGURATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("configuration").isBinary(false).build();
    private static final MarshallingInfo<Map> SUPPLEMENTARYCONFIGURATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("supplementaryConfiguration").isBinary(false).build();
    private static final ConfigurationItemMarshaller INSTANCE = new ConfigurationItemMarshaller();

    private ConfigurationItemMarshaller() {
    }

    public static ConfigurationItemMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ConfigurationItem configurationItem, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)configurationItem, (String)"configurationItem");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)configurationItem.version(), VERSION_BINDING);
            protocolMarshaller.marshall((Object)configurationItem.accountId(), ACCOUNTID_BINDING);
            protocolMarshaller.marshall((Object)configurationItem.configurationItemCaptureTime(), CONFIGURATIONITEMCAPTURETIME_BINDING);
            protocolMarshaller.marshall((Object)configurationItem.configurationItemStatusString(), CONFIGURATIONITEMSTATUS_BINDING);
            protocolMarshaller.marshall((Object)configurationItem.configurationStateId(), CONFIGURATIONSTATEID_BINDING);
            protocolMarshaller.marshall((Object)configurationItem.configurationItemMD5Hash(), CONFIGURATIONITEMMD5HASH_BINDING);
            protocolMarshaller.marshall((Object)configurationItem.arn(), ARN_BINDING);
            protocolMarshaller.marshall((Object)configurationItem.resourceTypeString(), RESOURCETYPE_BINDING);
            protocolMarshaller.marshall((Object)configurationItem.resourceId(), RESOURCEID_BINDING);
            protocolMarshaller.marshall((Object)configurationItem.resourceName(), RESOURCENAME_BINDING);
            protocolMarshaller.marshall((Object)configurationItem.awsRegion(), AWSREGION_BINDING);
            protocolMarshaller.marshall((Object)configurationItem.availabilityZone(), AVAILABILITYZONE_BINDING);
            protocolMarshaller.marshall((Object)configurationItem.resourceCreationTime(), RESOURCECREATIONTIME_BINDING);
            protocolMarshaller.marshall(configurationItem.tags(), TAGS_BINDING);
            protocolMarshaller.marshall(configurationItem.relatedEvents(), RELATEDEVENTS_BINDING);
            protocolMarshaller.marshall(configurationItem.relationships(), RELATIONSHIPS_BINDING);
            protocolMarshaller.marshall((Object)configurationItem.configuration(), CONFIGURATION_BINDING);
            protocolMarshaller.marshall(configurationItem.supplementaryConfiguration(), SUPPLEMENTARYCONFIGURATION_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

