/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.config.model.ListDiscoveredResourcesRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ListDiscoveredResourcesRequestModelMarshaller {
    private static final MarshallingInfo<String> RESOURCETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("resourceType").isBinary(false).build();
    private static final MarshallingInfo<List> RESOURCEIDS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("resourceIds").isBinary(false).build();
    private static final MarshallingInfo<String> RESOURCENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("resourceName").isBinary(false).build();
    private static final MarshallingInfo<Integer> LIMIT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("limit").isBinary(false).build();
    private static final MarshallingInfo<Boolean> INCLUDEDELETEDRESOURCES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("includeDeletedResources").isBinary(false).build();
    private static final MarshallingInfo<String> NEXTTOKEN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("nextToken").isBinary(false).build();
    private static final ListDiscoveredResourcesRequestModelMarshaller INSTANCE = new ListDiscoveredResourcesRequestModelMarshaller();

    private ListDiscoveredResourcesRequestModelMarshaller() {
    }

    public static ListDiscoveredResourcesRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ListDiscoveredResourcesRequest listDiscoveredResourcesRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)listDiscoveredResourcesRequest), (String)"listDiscoveredResourcesRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)listDiscoveredResourcesRequest.resourceTypeString(), RESOURCETYPE_BINDING);
            protocolMarshaller.marshall(listDiscoveredResourcesRequest.resourceIds(), RESOURCEIDS_BINDING);
            protocolMarshaller.marshall((Object)listDiscoveredResourcesRequest.resourceName(), RESOURCENAME_BINDING);
            protocolMarshaller.marshall((Object)listDiscoveredResourcesRequest.limit(), LIMIT_BINDING);
            protocolMarshaller.marshall((Object)listDiscoveredResourcesRequest.includeDeletedResources(), INCLUDEDELETEDRESOURCES_BINDING);
            protocolMarshaller.marshall((Object)listDiscoveredResourcesRequest.nextToken(), NEXTTOKEN_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

