/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutAggregationAuthorizationRequest extends ConfigRequest implements
        ToCopyableBuilder<PutAggregationAuthorizationRequest.Builder, PutAggregationAuthorizationRequest> {
    private static final SdkField<String> AUTHORIZED_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PutAggregationAuthorizationRequest::authorizedAccountId)).setter(setter(Builder::authorizedAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthorizedAccountId").build())
            .build();

    private static final SdkField<String> AUTHORIZED_AWS_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PutAggregationAuthorizationRequest::authorizedAwsRegion)).setter(setter(Builder::authorizedAwsRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthorizedAwsRegion").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTHORIZED_ACCOUNT_ID_FIELD,
            AUTHORIZED_AWS_REGION_FIELD));

    private final String authorizedAccountId;

    private final String authorizedAwsRegion;

    private PutAggregationAuthorizationRequest(BuilderImpl builder) {
        super(builder);
        this.authorizedAccountId = builder.authorizedAccountId;
        this.authorizedAwsRegion = builder.authorizedAwsRegion;
    }

    /**
     * <p>
     * The 12-digit account ID of the account authorized to aggregate data.
     * </p>
     * 
     * @return The 12-digit account ID of the account authorized to aggregate data.
     */
    public String authorizedAccountId() {
        return authorizedAccountId;
    }

    /**
     * <p>
     * The region authorized to collect aggregated data.
     * </p>
     * 
     * @return The region authorized to collect aggregated data.
     */
    public String authorizedAwsRegion() {
        return authorizedAwsRegion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(authorizedAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(authorizedAwsRegion());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutAggregationAuthorizationRequest)) {
            return false;
        }
        PutAggregationAuthorizationRequest other = (PutAggregationAuthorizationRequest) obj;
        return Objects.equals(authorizedAccountId(), other.authorizedAccountId())
                && Objects.equals(authorizedAwsRegion(), other.authorizedAwsRegion());
    }

    @Override
    public String toString() {
        return ToString.builder("PutAggregationAuthorizationRequest").add("AuthorizedAccountId", authorizedAccountId())
                .add("AuthorizedAwsRegion", authorizedAwsRegion()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AuthorizedAccountId":
            return Optional.ofNullable(clazz.cast(authorizedAccountId()));
        case "AuthorizedAwsRegion":
            return Optional.ofNullable(clazz.cast(authorizedAwsRegion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutAggregationAuthorizationRequest, T> g) {
        return obj -> g.apply((PutAggregationAuthorizationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConfigRequest.Builder, SdkPojo, CopyableBuilder<Builder, PutAggregationAuthorizationRequest> {
        /**
         * <p>
         * The 12-digit account ID of the account authorized to aggregate data.
         * </p>
         * 
         * @param authorizedAccountId
         *        The 12-digit account ID of the account authorized to aggregate data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authorizedAccountId(String authorizedAccountId);

        /**
         * <p>
         * The region authorized to collect aggregated data.
         * </p>
         * 
         * @param authorizedAwsRegion
         *        The region authorized to collect aggregated data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authorizedAwsRegion(String authorizedAwsRegion);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ConfigRequest.BuilderImpl implements Builder {
        private String authorizedAccountId;

        private String authorizedAwsRegion;

        private BuilderImpl() {
        }

        private BuilderImpl(PutAggregationAuthorizationRequest model) {
            super(model);
            authorizedAccountId(model.authorizedAccountId);
            authorizedAwsRegion(model.authorizedAwsRegion);
        }

        public final String getAuthorizedAccountId() {
            return authorizedAccountId;
        }

        @Override
        public final Builder authorizedAccountId(String authorizedAccountId) {
            this.authorizedAccountId = authorizedAccountId;
            return this;
        }

        public final void setAuthorizedAccountId(String authorizedAccountId) {
            this.authorizedAccountId = authorizedAccountId;
        }

        public final String getAuthorizedAwsRegion() {
            return authorizedAwsRegion;
        }

        @Override
        public final Builder authorizedAwsRegion(String authorizedAwsRegion) {
            this.authorizedAwsRegion = authorizedAwsRegion;
            return this;
        }

        public final void setAuthorizedAwsRegion(String authorizedAwsRegion) {
            this.authorizedAwsRegion = authorizedAwsRegion;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutAggregationAuthorizationRequest build() {
            return new PutAggregationAuthorizationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
