/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The relationship of the related resource to the main resource.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Relationship implements SdkPojo, Serializable, ToCopyableBuilder<Relationship.Builder, Relationship> {
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Relationship::resourceTypeAsString)).setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceType").build()).build();

    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Relationship::resourceId)).setter(setter(Builder::resourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceId").build()).build();

    private static final SdkField<String> RESOURCE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Relationship::resourceName)).setter(setter(Builder::resourceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceName").build()).build();

    private static final SdkField<String> RELATIONSHIP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Relationship::relationshipName)).setter(setter(Builder::relationshipName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("relationshipName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_TYPE_FIELD,
            RESOURCE_ID_FIELD, RESOURCE_NAME_FIELD, RELATIONSHIP_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String resourceType;

    private final String resourceId;

    private final String resourceName;

    private final String relationshipName;

    private Relationship(BuilderImpl builder) {
        this.resourceType = builder.resourceType;
        this.resourceId = builder.resourceId;
        this.resourceName = builder.resourceName;
        this.relationshipName = builder.relationshipName;
    }

    /**
     * <p>
     * The resource type of the related resource.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link ResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return The resource type of the related resource.
     * @see ResourceType
     */
    public ResourceType resourceType() {
        return ResourceType.fromValue(resourceType);
    }

    /**
     * <p>
     * The resource type of the related resource.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link ResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return The resource type of the related resource.
     * @see ResourceType
     */
    public String resourceTypeAsString() {
        return resourceType;
    }

    /**
     * <p>
     * The ID of the related resource (for example, <code>sg-xxxxxx</code>).
     * </p>
     * 
     * @return The ID of the related resource (for example, <code>sg-xxxxxx</code>).
     */
    public String resourceId() {
        return resourceId;
    }

    /**
     * <p>
     * The custom name of the related resource, if available.
     * </p>
     * 
     * @return The custom name of the related resource, if available.
     */
    public String resourceName() {
        return resourceName;
    }

    /**
     * <p>
     * The type of relationship with the related resource.
     * </p>
     * 
     * @return The type of relationship with the related resource.
     */
    public String relationshipName() {
        return relationshipName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(resourceName());
        hashCode = 31 * hashCode + Objects.hashCode(relationshipName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Relationship)) {
            return false;
        }
        Relationship other = (Relationship) obj;
        return Objects.equals(resourceTypeAsString(), other.resourceTypeAsString())
                && Objects.equals(resourceId(), other.resourceId()) && Objects.equals(resourceName(), other.resourceName())
                && Objects.equals(relationshipName(), other.relationshipName());
    }

    @Override
    public String toString() {
        return ToString.builder("Relationship").add("ResourceType", resourceTypeAsString()).add("ResourceId", resourceId())
                .add("ResourceName", resourceName()).add("RelationshipName", relationshipName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "resourceType":
            return Optional.ofNullable(clazz.cast(resourceTypeAsString()));
        case "resourceId":
            return Optional.ofNullable(clazz.cast(resourceId()));
        case "resourceName":
            return Optional.ofNullable(clazz.cast(resourceName()));
        case "relationshipName":
            return Optional.ofNullable(clazz.cast(relationshipName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Relationship, T> g) {
        return obj -> g.apply((Relationship) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Relationship> {
        /**
         * <p>
         * The resource type of the related resource.
         * </p>
         * 
         * @param resourceType
         *        The resource type of the related resource.
         * @see ResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceType
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * The resource type of the related resource.
         * </p>
         * 
         * @param resourceType
         *        The resource type of the related resource.
         * @see ResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceType
         */
        Builder resourceType(ResourceType resourceType);

        /**
         * <p>
         * The ID of the related resource (for example, <code>sg-xxxxxx</code>).
         * </p>
         * 
         * @param resourceId
         *        The ID of the related resource (for example, <code>sg-xxxxxx</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceId(String resourceId);

        /**
         * <p>
         * The custom name of the related resource, if available.
         * </p>
         * 
         * @param resourceName
         *        The custom name of the related resource, if available.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceName(String resourceName);

        /**
         * <p>
         * The type of relationship with the related resource.
         * </p>
         * 
         * @param relationshipName
         *        The type of relationship with the related resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder relationshipName(String relationshipName);
    }

    static final class BuilderImpl implements Builder {
        private String resourceType;

        private String resourceId;

        private String resourceName;

        private String relationshipName;

        private BuilderImpl() {
        }

        private BuilderImpl(Relationship model) {
            resourceType(model.resourceType);
            resourceId(model.resourceId);
            resourceName(model.resourceName);
            relationshipName(model.relationshipName);
        }

        public final String getResourceType() {
            return resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(ResourceType resourceType) {
            this.resourceType(resourceType.toString());
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public final String getResourceId() {
            return resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        public final String getResourceName() {
            return resourceName;
        }

        @Override
        public final Builder resourceName(String resourceName) {
            this.resourceName = resourceName;
            return this;
        }

        public final void setResourceName(String resourceName) {
            this.resourceName = resourceName;
        }

        public final String getRelationshipName() {
            return relationshipName;
        }

        @Override
        public final Builder relationshipName(String relationshipName) {
            this.relationshipName = relationshipName;
            return this;
        }

        public final void setRelationshipName(String relationshipName) {
            this.relationshipName = relationshipName;
        }

        @Override
        public Relationship build() {
            return new Relationship(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
