/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeConfigRulesResponse extends ConfigResponse implements
        ToCopyableBuilder<DescribeConfigRulesResponse.Builder, DescribeConfigRulesResponse> {
    private static final SdkField<List<ConfigRule>> CONFIG_RULES_FIELD = SdkField
            .<List<ConfigRule>> builder(MarshallingType.LIST)
            .getter(getter(DescribeConfigRulesResponse::configRules))
            .setter(setter(Builder::configRules))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigRules").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ConfigRule> builder(MarshallingType.SDK_POJO)
                                            .constructor(ConfigRule::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeConfigRulesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIG_RULES_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<ConfigRule> configRules;

    private final String nextToken;

    private DescribeConfigRulesResponse(BuilderImpl builder) {
        super(builder);
        this.configRules = builder.configRules;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The details about your AWS Config rules.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The details about your AWS Config rules.
     */
    public List<ConfigRule> configRules() {
        return configRules;
    }

    /**
     * <p>
     * The string that you use in a subsequent request to get the next page of results in a paginated response.
     * </p>
     * 
     * @return The string that you use in a subsequent request to get the next page of results in a paginated response.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(configRules());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeConfigRulesResponse)) {
            return false;
        }
        DescribeConfigRulesResponse other = (DescribeConfigRulesResponse) obj;
        return Objects.equals(configRules(), other.configRules()) && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeConfigRulesResponse").add("ConfigRules", configRules()).add("NextToken", nextToken())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConfigRules":
            return Optional.ofNullable(clazz.cast(configRules()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeConfigRulesResponse, T> g) {
        return obj -> g.apply((DescribeConfigRulesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConfigResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeConfigRulesResponse> {
        /**
         * <p>
         * The details about your AWS Config rules.
         * </p>
         * 
         * @param configRules
         *        The details about your AWS Config rules.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configRules(Collection<ConfigRule> configRules);

        /**
         * <p>
         * The details about your AWS Config rules.
         * </p>
         * 
         * @param configRules
         *        The details about your AWS Config rules.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configRules(ConfigRule... configRules);

        /**
         * <p>
         * The details about your AWS Config rules.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ConfigRule>.Builder} avoiding the need to
         * create one manually via {@link List<ConfigRule>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ConfigRule>.Builder#build()} is called immediately and its
         * result is passed to {@link #configRules(List<ConfigRule>)}.
         * 
         * @param configRules
         *        a consumer that will call methods on {@link List<ConfigRule>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configRules(List<ConfigRule>)
         */
        Builder configRules(Consumer<ConfigRule.Builder>... configRules);

        /**
         * <p>
         * The string that you use in a subsequent request to get the next page of results in a paginated response.
         * </p>
         * 
         * @param nextToken
         *        The string that you use in a subsequent request to get the next page of results in a paginated
         *        response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ConfigResponse.BuilderImpl implements Builder {
        private List<ConfigRule> configRules = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeConfigRulesResponse model) {
            super(model);
            configRules(model.configRules);
            nextToken(model.nextToken);
        }

        public final Collection<ConfigRule.Builder> getConfigRules() {
            return configRules != null ? configRules.stream().map(ConfigRule::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder configRules(Collection<ConfigRule> configRules) {
            this.configRules = ConfigRulesCopier.copy(configRules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configRules(ConfigRule... configRules) {
            configRules(Arrays.asList(configRules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configRules(Consumer<ConfigRule.Builder>... configRules) {
            configRules(Stream.of(configRules).map(c -> ConfigRule.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setConfigRules(Collection<ConfigRule.BuilderImpl> configRules) {
            this.configRules = ConfigRulesCopier.copyFromBuilder(configRules);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeConfigRulesResponse build() {
            return new DescribeConfigRulesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
