/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Identifies an AWS Config rule that evaluated an AWS resource, and provides the type and ID of the resource that the
 * rule evaluated.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EvaluationResultQualifier implements SdkPojo, Serializable,
        ToCopyableBuilder<EvaluationResultQualifier.Builder, EvaluationResultQualifier> {
    private static final SdkField<String> CONFIG_RULE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(EvaluationResultQualifier::configRuleName)).setter(setter(Builder::configRuleName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigRuleName").build()).build();

    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(EvaluationResultQualifier::resourceType)).setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()).build();

    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(EvaluationResultQualifier::resourceId)).setter(setter(Builder::resourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIG_RULE_NAME_FIELD,
            RESOURCE_TYPE_FIELD, RESOURCE_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String configRuleName;

    private final String resourceType;

    private final String resourceId;

    private EvaluationResultQualifier(BuilderImpl builder) {
        this.configRuleName = builder.configRuleName;
        this.resourceType = builder.resourceType;
        this.resourceId = builder.resourceId;
    }

    /**
     * <p>
     * The name of the AWS Config rule that was used in the evaluation.
     * </p>
     * 
     * @return The name of the AWS Config rule that was used in the evaluation.
     */
    public String configRuleName() {
        return configRuleName;
    }

    /**
     * <p>
     * The type of AWS resource that was evaluated.
     * </p>
     * 
     * @return The type of AWS resource that was evaluated.
     */
    public String resourceType() {
        return resourceType;
    }

    /**
     * <p>
     * The ID of the evaluated AWS resource.
     * </p>
     * 
     * @return The ID of the evaluated AWS resource.
     */
    public String resourceId() {
        return resourceId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(configRuleName());
        hashCode = 31 * hashCode + Objects.hashCode(resourceType());
        hashCode = 31 * hashCode + Objects.hashCode(resourceId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EvaluationResultQualifier)) {
            return false;
        }
        EvaluationResultQualifier other = (EvaluationResultQualifier) obj;
        return Objects.equals(configRuleName(), other.configRuleName()) && Objects.equals(resourceType(), other.resourceType())
                && Objects.equals(resourceId(), other.resourceId());
    }

    @Override
    public String toString() {
        return ToString.builder("EvaluationResultQualifier").add("ConfigRuleName", configRuleName())
                .add("ResourceType", resourceType()).add("ResourceId", resourceId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConfigRuleName":
            return Optional.ofNullable(clazz.cast(configRuleName()));
        case "ResourceType":
            return Optional.ofNullable(clazz.cast(resourceType()));
        case "ResourceId":
            return Optional.ofNullable(clazz.cast(resourceId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EvaluationResultQualifier, T> g) {
        return obj -> g.apply((EvaluationResultQualifier) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EvaluationResultQualifier> {
        /**
         * <p>
         * The name of the AWS Config rule that was used in the evaluation.
         * </p>
         * 
         * @param configRuleName
         *        The name of the AWS Config rule that was used in the evaluation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configRuleName(String configRuleName);

        /**
         * <p>
         * The type of AWS resource that was evaluated.
         * </p>
         * 
         * @param resourceType
         *        The type of AWS resource that was evaluated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * The ID of the evaluated AWS resource.
         * </p>
         * 
         * @param resourceId
         *        The ID of the evaluated AWS resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceId(String resourceId);
    }

    static final class BuilderImpl implements Builder {
        private String configRuleName;

        private String resourceType;

        private String resourceId;

        private BuilderImpl() {
        }

        private BuilderImpl(EvaluationResultQualifier model) {
            configRuleName(model.configRuleName);
            resourceType(model.resourceType);
            resourceId(model.resourceId);
        }

        public final String getConfigRuleName() {
            return configRuleName;
        }

        @Override
        public final Builder configRuleName(String configRuleName) {
            this.configRuleName = configRuleName;
            return this;
        }

        public final void setConfigRuleName(String configRuleName) {
            this.configRuleName = configRuleName;
        }

        public final String getResourceType() {
            return resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public final String getResourceId() {
            return resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        @Override
        public EvaluationResultQualifier build() {
            return new EvaluationResultQualifier(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
