/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The input for the <a>PutConfigurationRecorder</a> action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutConfigurationRecorderRequest extends ConfigRequest implements
        ToCopyableBuilder<PutConfigurationRecorderRequest.Builder, PutConfigurationRecorderRequest> {
    private static final SdkField<ConfigurationRecorder> CONFIGURATION_RECORDER_FIELD = SdkField
            .<ConfigurationRecorder> builder(MarshallingType.SDK_POJO)
            .getter(getter(PutConfigurationRecorderRequest::configurationRecorder))
            .setter(setter(Builder::configurationRecorder)).constructor(ConfigurationRecorder::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationRecorder").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURATION_RECORDER_FIELD));

    private final ConfigurationRecorder configurationRecorder;

    private PutConfigurationRecorderRequest(BuilderImpl builder) {
        super(builder);
        this.configurationRecorder = builder.configurationRecorder;
    }

    /**
     * <p>
     * The configuration recorder object that records each configuration change made to the resources.
     * </p>
     * 
     * @return The configuration recorder object that records each configuration change made to the resources.
     */
    public ConfigurationRecorder configurationRecorder() {
        return configurationRecorder;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(configurationRecorder());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutConfigurationRecorderRequest)) {
            return false;
        }
        PutConfigurationRecorderRequest other = (PutConfigurationRecorderRequest) obj;
        return Objects.equals(configurationRecorder(), other.configurationRecorder());
    }

    @Override
    public String toString() {
        return ToString.builder("PutConfigurationRecorderRequest").add("ConfigurationRecorder", configurationRecorder()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConfigurationRecorder":
            return Optional.ofNullable(clazz.cast(configurationRecorder()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutConfigurationRecorderRequest, T> g) {
        return obj -> g.apply((PutConfigurationRecorderRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConfigRequest.Builder, SdkPojo, CopyableBuilder<Builder, PutConfigurationRecorderRequest> {
        /**
         * <p>
         * The configuration recorder object that records each configuration change made to the resources.
         * </p>
         * 
         * @param configurationRecorder
         *        The configuration recorder object that records each configuration change made to the resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationRecorder(ConfigurationRecorder configurationRecorder);

        /**
         * <p>
         * The configuration recorder object that records each configuration change made to the resources.
         * </p>
         * This is a convenience that creates an instance of the {@link ConfigurationRecorder.Builder} avoiding the need
         * to create one manually via {@link ConfigurationRecorder#builder()}.
         *
         * When the {@link Consumer} completes, {@link ConfigurationRecorder.Builder#build()} is called immediately and
         * its result is passed to {@link #configurationRecorder(ConfigurationRecorder)}.
         * 
         * @param configurationRecorder
         *        a consumer that will call methods on {@link ConfigurationRecorder.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configurationRecorder(ConfigurationRecorder)
         */
        default Builder configurationRecorder(Consumer<ConfigurationRecorder.Builder> configurationRecorder) {
            return configurationRecorder(ConfigurationRecorder.builder().applyMutation(configurationRecorder).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ConfigRequest.BuilderImpl implements Builder {
        private ConfigurationRecorder configurationRecorder;

        private BuilderImpl() {
        }

        private BuilderImpl(PutConfigurationRecorderRequest model) {
            super(model);
            configurationRecorder(model.configurationRecorder);
        }

        public final ConfigurationRecorder.Builder getConfigurationRecorder() {
            return configurationRecorder != null ? configurationRecorder.toBuilder() : null;
        }

        @Override
        public final Builder configurationRecorder(ConfigurationRecorder configurationRecorder) {
            this.configurationRecorder = configurationRecorder;
            return this;
        }

        public final void setConfigurationRecorder(ConfigurationRecorder.BuilderImpl configurationRecorder) {
            this.configurationRecorder = configurationRecorder != null ? configurationRecorder.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutConfigurationRecorderRequest build() {
            return new PutConfigurationRecorderRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
