/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object with the name of the retention configuration and the retention period in days. The object stores the
 * configuration for data retention in AWS Config.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RetentionConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<RetentionConfiguration.Builder, RetentionConfiguration> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RetentionConfiguration::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<Integer> RETENTION_PERIOD_IN_DAYS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(RetentionConfiguration::retentionPeriodInDays)).setter(setter(Builder::retentionPeriodInDays))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetentionPeriodInDays").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            RETENTION_PERIOD_IN_DAYS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final Integer retentionPeriodInDays;

    private RetentionConfiguration(BuilderImpl builder) {
        this.name = builder.name;
        this.retentionPeriodInDays = builder.retentionPeriodInDays;
    }

    /**
     * <p>
     * The name of the retention configuration object.
     * </p>
     * 
     * @return The name of the retention configuration object.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * Number of days AWS Config stores your historical information.
     * </p>
     * <note>
     * <p>
     * Currently, only applicable to the configuration item history.
     * </p>
     * </note>
     * 
     * @return Number of days AWS Config stores your historical information.</p> <note>
     *         <p>
     *         Currently, only applicable to the configuration item history.
     *         </p>
     */
    public Integer retentionPeriodInDays() {
        return retentionPeriodInDays;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(retentionPeriodInDays());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RetentionConfiguration)) {
            return false;
        }
        RetentionConfiguration other = (RetentionConfiguration) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(retentionPeriodInDays(), other.retentionPeriodInDays());
    }

    @Override
    public String toString() {
        return ToString.builder("RetentionConfiguration").add("Name", name())
                .add("RetentionPeriodInDays", retentionPeriodInDays()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "RetentionPeriodInDays":
            return Optional.ofNullable(clazz.cast(retentionPeriodInDays()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RetentionConfiguration, T> g) {
        return obj -> g.apply((RetentionConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RetentionConfiguration> {
        /**
         * <p>
         * The name of the retention configuration object.
         * </p>
         * 
         * @param name
         *        The name of the retention configuration object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Number of days AWS Config stores your historical information.
         * </p>
         * <note>
         * <p>
         * Currently, only applicable to the configuration item history.
         * </p>
         * </note>
         * 
         * @param retentionPeriodInDays
         *        Number of days AWS Config stores your historical information.</p> <note>
         *        <p>
         *        Currently, only applicable to the configuration item history.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retentionPeriodInDays(Integer retentionPeriodInDays);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private Integer retentionPeriodInDays;

        private BuilderImpl() {
        }

        private BuilderImpl(RetentionConfiguration model) {
            name(model.name);
            retentionPeriodInDays(model.retentionPeriodInDays);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Integer getRetentionPeriodInDays() {
            return retentionPeriodInDays;
        }

        @Override
        public final Builder retentionPeriodInDays(Integer retentionPeriodInDays) {
            this.retentionPeriodInDays = retentionPeriodInDays;
            return this;
        }

        public final void setRetentionPeriodInDays(Integer retentionPeriodInDays) {
            this.retentionPeriodInDays = retentionPeriodInDays;
        }

        @Override
        public RetentionConfiguration build() {
            return new RetentionConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
