/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutConformancePackResponse extends ConfigResponse implements
        ToCopyableBuilder<PutConformancePackResponse.Builder, PutConformancePackResponse> {
    private static final SdkField<String> CONFORMANCE_PACK_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PutConformancePackResponse::conformancePackArn)).setter(setter(Builder::conformancePackArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConformancePackArn").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFORMANCE_PACK_ARN_FIELD));

    private final String conformancePackArn;

    private PutConformancePackResponse(BuilderImpl builder) {
        super(builder);
        this.conformancePackArn = builder.conformancePackArn;
    }

    /**
     * <p>
     * ARN of the conformance pack.
     * </p>
     * 
     * @return ARN of the conformance pack.
     */
    public String conformancePackArn() {
        return conformancePackArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(conformancePackArn());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutConformancePackResponse)) {
            return false;
        }
        PutConformancePackResponse other = (PutConformancePackResponse) obj;
        return Objects.equals(conformancePackArn(), other.conformancePackArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("PutConformancePackResponse").add("ConformancePackArn", conformancePackArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConformancePackArn":
            return Optional.ofNullable(clazz.cast(conformancePackArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutConformancePackResponse, T> g) {
        return obj -> g.apply((PutConformancePackResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConfigResponse.Builder, SdkPojo, CopyableBuilder<Builder, PutConformancePackResponse> {
        /**
         * <p>
         * ARN of the conformance pack.
         * </p>
         * 
         * @param conformancePackArn
         *        ARN of the conformance pack.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conformancePackArn(String conformancePackArn);
    }

    static final class BuilderImpl extends ConfigResponse.BuilderImpl implements Builder {
        private String conformancePackArn;

        private BuilderImpl() {
        }

        private BuilderImpl(PutConformancePackResponse model) {
            super(model);
            conformancePackArn(model.conformancePackArn);
        }

        public final String getConformancePackArn() {
            return conformancePackArn;
        }

        @Override
        public final Builder conformancePackArn(String conformancePackArn) {
            this.conformancePackArn = conformancePackArn;
            return this;
        }

        public final void setConformancePackArn(String conformancePackArn) {
            this.conformancePackArn = conformancePackArn;
        }

        @Override
        public PutConformancePackResponse build() {
            return new PutConformancePackResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
