/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Compliance information of one or more AWS Config rules within a conformance pack. You can filter using AWS Config
 * rule names and compliance types.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConformancePackRuleCompliance implements SdkPojo, Serializable,
        ToCopyableBuilder<ConformancePackRuleCompliance.Builder, ConformancePackRuleCompliance> {
    private static final SdkField<String> CONFIG_RULE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ConformancePackRuleCompliance::configRuleName)).setter(setter(Builder::configRuleName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigRuleName").build()).build();

    private static final SdkField<String> COMPLIANCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ConformancePackRuleCompliance::complianceTypeAsString)).setter(setter(Builder::complianceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComplianceType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIG_RULE_NAME_FIELD,
            COMPLIANCE_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String configRuleName;

    private final String complianceType;

    private ConformancePackRuleCompliance(BuilderImpl builder) {
        this.configRuleName = builder.configRuleName;
        this.complianceType = builder.complianceType;
    }

    /**
     * <p>
     * Name of the config rule.
     * </p>
     * 
     * @return Name of the config rule.
     */
    public String configRuleName() {
        return configRuleName;
    }

    /**
     * <p>
     * Compliance of the AWS Config rule
     * </p>
     * <p>
     * The allowed values are <code>COMPLIANT</code> and <code>NON_COMPLIANT</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #complianceType}
     * will return {@link ConformancePackComplianceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #complianceTypeAsString}.
     * </p>
     * 
     * @return Compliance of the AWS Config rule</p>
     *         <p>
     *         The allowed values are <code>COMPLIANT</code> and <code>NON_COMPLIANT</code>.
     * @see ConformancePackComplianceType
     */
    public ConformancePackComplianceType complianceType() {
        return ConformancePackComplianceType.fromValue(complianceType);
    }

    /**
     * <p>
     * Compliance of the AWS Config rule
     * </p>
     * <p>
     * The allowed values are <code>COMPLIANT</code> and <code>NON_COMPLIANT</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #complianceType}
     * will return {@link ConformancePackComplianceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #complianceTypeAsString}.
     * </p>
     * 
     * @return Compliance of the AWS Config rule</p>
     *         <p>
     *         The allowed values are <code>COMPLIANT</code> and <code>NON_COMPLIANT</code>.
     * @see ConformancePackComplianceType
     */
    public String complianceTypeAsString() {
        return complianceType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(configRuleName());
        hashCode = 31 * hashCode + Objects.hashCode(complianceTypeAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConformancePackRuleCompliance)) {
            return false;
        }
        ConformancePackRuleCompliance other = (ConformancePackRuleCompliance) obj;
        return Objects.equals(configRuleName(), other.configRuleName())
                && Objects.equals(complianceTypeAsString(), other.complianceTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ConformancePackRuleCompliance").add("ConfigRuleName", configRuleName())
                .add("ComplianceType", complianceTypeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConfigRuleName":
            return Optional.ofNullable(clazz.cast(configRuleName()));
        case "ComplianceType":
            return Optional.ofNullable(clazz.cast(complianceTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConformancePackRuleCompliance, T> g) {
        return obj -> g.apply((ConformancePackRuleCompliance) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConformancePackRuleCompliance> {
        /**
         * <p>
         * Name of the config rule.
         * </p>
         * 
         * @param configRuleName
         *        Name of the config rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configRuleName(String configRuleName);

        /**
         * <p>
         * Compliance of the AWS Config rule
         * </p>
         * <p>
         * The allowed values are <code>COMPLIANT</code> and <code>NON_COMPLIANT</code>.
         * </p>
         * 
         * @param complianceType
         *        Compliance of the AWS Config rule</p>
         *        <p>
         *        The allowed values are <code>COMPLIANT</code> and <code>NON_COMPLIANT</code>.
         * @see ConformancePackComplianceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConformancePackComplianceType
         */
        Builder complianceType(String complianceType);

        /**
         * <p>
         * Compliance of the AWS Config rule
         * </p>
         * <p>
         * The allowed values are <code>COMPLIANT</code> and <code>NON_COMPLIANT</code>.
         * </p>
         * 
         * @param complianceType
         *        Compliance of the AWS Config rule</p>
         *        <p>
         *        The allowed values are <code>COMPLIANT</code> and <code>NON_COMPLIANT</code>.
         * @see ConformancePackComplianceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConformancePackComplianceType
         */
        Builder complianceType(ConformancePackComplianceType complianceType);
    }

    static final class BuilderImpl implements Builder {
        private String configRuleName;

        private String complianceType;

        private BuilderImpl() {
        }

        private BuilderImpl(ConformancePackRuleCompliance model) {
            configRuleName(model.configRuleName);
            complianceType(model.complianceType);
        }

        public final String getConfigRuleName() {
            return configRuleName;
        }

        @Override
        public final Builder configRuleName(String configRuleName) {
            this.configRuleName = configRuleName;
            return this;
        }

        public final void setConfigRuleName(String configRuleName) {
            this.configRuleName = configRuleName;
        }

        public final String getComplianceTypeAsString() {
            return complianceType;
        }

        @Override
        public final Builder complianceType(String complianceType) {
            this.complianceType = complianceType;
            return this;
        }

        @Override
        public final Builder complianceType(ConformancePackComplianceType complianceType) {
            this.complianceType(complianceType == null ? null : complianceType.toString());
            return this;
        }

        public final void setComplianceType(String complianceType) {
            this.complianceType = complianceType;
        }

        @Override
        public ConformancePackRuleCompliance build() {
            return new ConformancePackRuleCompliance(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
