/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Filters the conformance pack by compliance types and AWS Config rule names.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConformancePackComplianceFilters implements SdkPojo, Serializable,
        ToCopyableBuilder<ConformancePackComplianceFilters.Builder, ConformancePackComplianceFilters> {
    private static final SdkField<List<String>> CONFIG_RULE_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(ConformancePackComplianceFilters::configRuleNames))
            .setter(setter(Builder::configRuleNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigRuleNames").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> COMPLIANCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ConformancePackComplianceFilters::complianceTypeAsString)).setter(setter(Builder::complianceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComplianceType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIG_RULE_NAMES_FIELD,
            COMPLIANCE_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> configRuleNames;

    private final String complianceType;

    private ConformancePackComplianceFilters(BuilderImpl builder) {
        this.configRuleNames = builder.configRuleNames;
        this.complianceType = builder.complianceType;
    }

    /**
     * Returns true if the ConfigRuleNames property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasConfigRuleNames() {
        return configRuleNames != null && !(configRuleNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Filters the results by AWS Config rule names.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasConfigRuleNames()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Filters the results by AWS Config rule names.
     */
    public List<String> configRuleNames() {
        return configRuleNames;
    }

    /**
     * <p>
     * Filters the results by compliance.
     * </p>
     * <p>
     * The allowed values are <code>COMPLIANT</code> and <code>NON_COMPLIANT</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #complianceType}
     * will return {@link ConformancePackComplianceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #complianceTypeAsString}.
     * </p>
     * 
     * @return Filters the results by compliance.</p>
     *         <p>
     *         The allowed values are <code>COMPLIANT</code> and <code>NON_COMPLIANT</code>.
     * @see ConformancePackComplianceType
     */
    public ConformancePackComplianceType complianceType() {
        return ConformancePackComplianceType.fromValue(complianceType);
    }

    /**
     * <p>
     * Filters the results by compliance.
     * </p>
     * <p>
     * The allowed values are <code>COMPLIANT</code> and <code>NON_COMPLIANT</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #complianceType}
     * will return {@link ConformancePackComplianceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #complianceTypeAsString}.
     * </p>
     * 
     * @return Filters the results by compliance.</p>
     *         <p>
     *         The allowed values are <code>COMPLIANT</code> and <code>NON_COMPLIANT</code>.
     * @see ConformancePackComplianceType
     */
    public String complianceTypeAsString() {
        return complianceType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(configRuleNames());
        hashCode = 31 * hashCode + Objects.hashCode(complianceTypeAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConformancePackComplianceFilters)) {
            return false;
        }
        ConformancePackComplianceFilters other = (ConformancePackComplianceFilters) obj;
        return Objects.equals(configRuleNames(), other.configRuleNames())
                && Objects.equals(complianceTypeAsString(), other.complianceTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ConformancePackComplianceFilters").add("ConfigRuleNames", configRuleNames())
                .add("ComplianceType", complianceTypeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConfigRuleNames":
            return Optional.ofNullable(clazz.cast(configRuleNames()));
        case "ComplianceType":
            return Optional.ofNullable(clazz.cast(complianceTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConformancePackComplianceFilters, T> g) {
        return obj -> g.apply((ConformancePackComplianceFilters) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConformancePackComplianceFilters> {
        /**
         * <p>
         * Filters the results by AWS Config rule names.
         * </p>
         * 
         * @param configRuleNames
         *        Filters the results by AWS Config rule names.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configRuleNames(Collection<String> configRuleNames);

        /**
         * <p>
         * Filters the results by AWS Config rule names.
         * </p>
         * 
         * @param configRuleNames
         *        Filters the results by AWS Config rule names.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configRuleNames(String... configRuleNames);

        /**
         * <p>
         * Filters the results by compliance.
         * </p>
         * <p>
         * The allowed values are <code>COMPLIANT</code> and <code>NON_COMPLIANT</code>.
         * </p>
         * 
         * @param complianceType
         *        Filters the results by compliance.</p>
         *        <p>
         *        The allowed values are <code>COMPLIANT</code> and <code>NON_COMPLIANT</code>.
         * @see ConformancePackComplianceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConformancePackComplianceType
         */
        Builder complianceType(String complianceType);

        /**
         * <p>
         * Filters the results by compliance.
         * </p>
         * <p>
         * The allowed values are <code>COMPLIANT</code> and <code>NON_COMPLIANT</code>.
         * </p>
         * 
         * @param complianceType
         *        Filters the results by compliance.</p>
         *        <p>
         *        The allowed values are <code>COMPLIANT</code> and <code>NON_COMPLIANT</code>.
         * @see ConformancePackComplianceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConformancePackComplianceType
         */
        Builder complianceType(ConformancePackComplianceType complianceType);
    }

    static final class BuilderImpl implements Builder {
        private List<String> configRuleNames = DefaultSdkAutoConstructList.getInstance();

        private String complianceType;

        private BuilderImpl() {
        }

        private BuilderImpl(ConformancePackComplianceFilters model) {
            configRuleNames(model.configRuleNames);
            complianceType(model.complianceType);
        }

        public final Collection<String> getConfigRuleNames() {
            return configRuleNames;
        }

        @Override
        public final Builder configRuleNames(Collection<String> configRuleNames) {
            this.configRuleNames = ConformancePackConfigRuleNamesCopier.copy(configRuleNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configRuleNames(String... configRuleNames) {
            configRuleNames(Arrays.asList(configRuleNames));
            return this;
        }

        public final void setConfigRuleNames(Collection<String> configRuleNames) {
            this.configRuleNames = ConformancePackConfigRuleNamesCopier.copy(configRuleNames);
        }

        public final String getComplianceTypeAsString() {
            return complianceType;
        }

        @Override
        public final Builder complianceType(String complianceType) {
            this.complianceType = complianceType;
            return this;
        }

        @Override
        public final Builder complianceType(ConformancePackComplianceType complianceType) {
            this.complianceType(complianceType == null ? null : complianceType.toString());
            return this;
        }

        public final void setComplianceType(String complianceType) {
            this.complianceType = complianceType;
        }

        @Override
        public ConformancePackComplianceFilters build() {
            return new ConformancePackComplianceFilters(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
