/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeRemediationExceptionsResponse extends ConfigResponse implements
        ToCopyableBuilder<DescribeRemediationExceptionsResponse.Builder, DescribeRemediationExceptionsResponse> {
    private static final SdkField<List<RemediationException>> REMEDIATION_EXCEPTIONS_FIELD = SdkField
            .<List<RemediationException>> builder(MarshallingType.LIST)
            .getter(getter(DescribeRemediationExceptionsResponse::remediationExceptions))
            .setter(setter(Builder::remediationExceptions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemediationExceptions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RemediationException> builder(MarshallingType.SDK_POJO)
                                            .constructor(RemediationException::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeRemediationExceptionsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REMEDIATION_EXCEPTIONS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<RemediationException> remediationExceptions;

    private final String nextToken;

    private DescribeRemediationExceptionsResponse(BuilderImpl builder) {
        super(builder);
        this.remediationExceptions = builder.remediationExceptions;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the RemediationExceptions property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasRemediationExceptions() {
        return remediationExceptions != null && !(remediationExceptions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Returns a list of remediation exception objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasRemediationExceptions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Returns a list of remediation exception objects.
     */
    public List<RemediationException> remediationExceptions() {
        return remediationExceptions;
    }

    /**
     * <p>
     * The <code>nextToken</code> string returned in a previous request that you use to request the next page of results
     * in a paginated response.
     * </p>
     * 
     * @return The <code>nextToken</code> string returned in a previous request that you use to request the next page of
     *         results in a paginated response.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(remediationExceptions());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeRemediationExceptionsResponse)) {
            return false;
        }
        DescribeRemediationExceptionsResponse other = (DescribeRemediationExceptionsResponse) obj;
        return Objects.equals(remediationExceptions(), other.remediationExceptions())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeRemediationExceptionsResponse").add("RemediationExceptions", remediationExceptions())
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RemediationExceptions":
            return Optional.ofNullable(clazz.cast(remediationExceptions()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeRemediationExceptionsResponse, T> g) {
        return obj -> g.apply((DescribeRemediationExceptionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConfigResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeRemediationExceptionsResponse> {
        /**
         * <p>
         * Returns a list of remediation exception objects.
         * </p>
         * 
         * @param remediationExceptions
         *        Returns a list of remediation exception objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder remediationExceptions(Collection<RemediationException> remediationExceptions);

        /**
         * <p>
         * Returns a list of remediation exception objects.
         * </p>
         * 
         * @param remediationExceptions
         *        Returns a list of remediation exception objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder remediationExceptions(RemediationException... remediationExceptions);

        /**
         * <p>
         * Returns a list of remediation exception objects.
         * </p>
         * This is a convenience that creates an instance of the {@link List<RemediationException>.Builder} avoiding the
         * need to create one manually via {@link List<RemediationException>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<RemediationException>.Builder#build()} is called immediately
         * and its result is passed to {@link #remediationExceptions(List<RemediationException>)}.
         * 
         * @param remediationExceptions
         *        a consumer that will call methods on {@link List<RemediationException>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #remediationExceptions(List<RemediationException>)
         */
        Builder remediationExceptions(Consumer<RemediationException.Builder>... remediationExceptions);

        /**
         * <p>
         * The <code>nextToken</code> string returned in a previous request that you use to request the next page of
         * results in a paginated response.
         * </p>
         * 
         * @param nextToken
         *        The <code>nextToken</code> string returned in a previous request that you use to request the next page
         *        of results in a paginated response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ConfigResponse.BuilderImpl implements Builder {
        private List<RemediationException> remediationExceptions = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeRemediationExceptionsResponse model) {
            super(model);
            remediationExceptions(model.remediationExceptions);
            nextToken(model.nextToken);
        }

        public final Collection<RemediationException.Builder> getRemediationExceptions() {
            return remediationExceptions != null ? remediationExceptions.stream().map(RemediationException::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder remediationExceptions(Collection<RemediationException> remediationExceptions) {
            this.remediationExceptions = RemediationExceptionsCopier.copy(remediationExceptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder remediationExceptions(RemediationException... remediationExceptions) {
            remediationExceptions(Arrays.asList(remediationExceptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder remediationExceptions(Consumer<RemediationException.Builder>... remediationExceptions) {
            remediationExceptions(Stream.of(remediationExceptions)
                    .map(c -> RemediationException.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRemediationExceptions(Collection<RemediationException.BuilderImpl> remediationExceptions) {
            this.remediationExceptions = RemediationExceptionsCopier.copyFromBuilder(remediationExceptions);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeRemediationExceptionsResponse build() {
            return new DescribeRemediationExceptionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
