/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeConformancePacksResponse extends ConfigResponse implements
        ToCopyableBuilder<DescribeConformancePacksResponse.Builder, DescribeConformancePacksResponse> {
    private static final SdkField<List<ConformancePackDetail>> CONFORMANCE_PACK_DETAILS_FIELD = SdkField
            .<List<ConformancePackDetail>> builder(MarshallingType.LIST)
            .getter(getter(DescribeConformancePacksResponse::conformancePackDetails))
            .setter(setter(Builder::conformancePackDetails))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConformancePackDetails").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ConformancePackDetail> builder(MarshallingType.SDK_POJO)
                                            .constructor(ConformancePackDetail::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeConformancePacksResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CONFORMANCE_PACK_DETAILS_FIELD, NEXT_TOKEN_FIELD));

    private final List<ConformancePackDetail> conformancePackDetails;

    private final String nextToken;

    private DescribeConformancePacksResponse(BuilderImpl builder) {
        super(builder);
        this.conformancePackDetails = builder.conformancePackDetails;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the ConformancePackDetails property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasConformancePackDetails() {
        return conformancePackDetails != null && !(conformancePackDetails instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Returns a list of <code>ConformancePackDetail</code> objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasConformancePackDetails()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Returns a list of <code>ConformancePackDetail</code> objects.
     */
    public List<ConformancePackDetail> conformancePackDetails() {
        return conformancePackDetails;
    }

    /**
     * <p>
     * The <code>nextToken</code> string returned in a previous request that you use to request the next page of results
     * in a paginated response.
     * </p>
     * 
     * @return The <code>nextToken</code> string returned in a previous request that you use to request the next page of
     *         results in a paginated response.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(conformancePackDetails());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeConformancePacksResponse)) {
            return false;
        }
        DescribeConformancePacksResponse other = (DescribeConformancePacksResponse) obj;
        return Objects.equals(conformancePackDetails(), other.conformancePackDetails())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeConformancePacksResponse").add("ConformancePackDetails", conformancePackDetails())
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConformancePackDetails":
            return Optional.ofNullable(clazz.cast(conformancePackDetails()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeConformancePacksResponse, T> g) {
        return obj -> g.apply((DescribeConformancePacksResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConfigResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeConformancePacksResponse> {
        /**
         * <p>
         * Returns a list of <code>ConformancePackDetail</code> objects.
         * </p>
         * 
         * @param conformancePackDetails
         *        Returns a list of <code>ConformancePackDetail</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conformancePackDetails(Collection<ConformancePackDetail> conformancePackDetails);

        /**
         * <p>
         * Returns a list of <code>ConformancePackDetail</code> objects.
         * </p>
         * 
         * @param conformancePackDetails
         *        Returns a list of <code>ConformancePackDetail</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conformancePackDetails(ConformancePackDetail... conformancePackDetails);

        /**
         * <p>
         * Returns a list of <code>ConformancePackDetail</code> objects.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ConformancePackDetail>.Builder} avoiding
         * the need to create one manually via {@link List<ConformancePackDetail>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ConformancePackDetail>.Builder#build()} is called
         * immediately and its result is passed to {@link #conformancePackDetails(List<ConformancePackDetail>)}.
         * 
         * @param conformancePackDetails
         *        a consumer that will call methods on {@link List<ConformancePackDetail>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #conformancePackDetails(List<ConformancePackDetail>)
         */
        Builder conformancePackDetails(Consumer<ConformancePackDetail.Builder>... conformancePackDetails);

        /**
         * <p>
         * The <code>nextToken</code> string returned in a previous request that you use to request the next page of
         * results in a paginated response.
         * </p>
         * 
         * @param nextToken
         *        The <code>nextToken</code> string returned in a previous request that you use to request the next page
         *        of results in a paginated response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ConfigResponse.BuilderImpl implements Builder {
        private List<ConformancePackDetail> conformancePackDetails = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeConformancePacksResponse model) {
            super(model);
            conformancePackDetails(model.conformancePackDetails);
            nextToken(model.nextToken);
        }

        public final Collection<ConformancePackDetail.Builder> getConformancePackDetails() {
            return conformancePackDetails != null ? conformancePackDetails.stream().map(ConformancePackDetail::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder conformancePackDetails(Collection<ConformancePackDetail> conformancePackDetails) {
            this.conformancePackDetails = ConformancePackDetailListCopier.copy(conformancePackDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder conformancePackDetails(ConformancePackDetail... conformancePackDetails) {
            conformancePackDetails(Arrays.asList(conformancePackDetails));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder conformancePackDetails(Consumer<ConformancePackDetail.Builder>... conformancePackDetails) {
            conformancePackDetails(Stream.of(conformancePackDetails)
                    .map(c -> ConformancePackDetail.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setConformancePackDetails(Collection<ConformancePackDetail.BuilderImpl> conformancePackDetails) {
            this.conformancePackDetails = ConformancePackDetailListCopier.copyFromBuilder(conformancePackDetails);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeConformancePacksResponse build() {
            return new DescribeConformancePacksResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
