/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * AWS Systems Manager (SSM) specific remediation controls.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SsmControls implements SdkPojo, Serializable, ToCopyableBuilder<SsmControls.Builder, SsmControls> {
    private static final SdkField<Integer> CONCURRENT_EXECUTION_RATE_PERCENTAGE_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(SsmControls::concurrentExecutionRatePercentage))
            .setter(setter(Builder::concurrentExecutionRatePercentage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConcurrentExecutionRatePercentage")
                    .build()).build();

    private static final SdkField<Integer> ERROR_PERCENTAGE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(SsmControls::errorPercentage)).setter(setter(Builder::errorPercentage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorPercentage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CONCURRENT_EXECUTION_RATE_PERCENTAGE_FIELD, ERROR_PERCENTAGE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer concurrentExecutionRatePercentage;

    private final Integer errorPercentage;

    private SsmControls(BuilderImpl builder) {
        this.concurrentExecutionRatePercentage = builder.concurrentExecutionRatePercentage;
        this.errorPercentage = builder.errorPercentage;
    }

    /**
     * <p>
     * The maximum percentage of remediation actions allowed to run in parallel on the non-compliant resources for that
     * specific rule. You can specify a percentage, such as 10%. The default value is 10.
     * </p>
     * 
     * @return The maximum percentage of remediation actions allowed to run in parallel on the non-compliant resources
     *         for that specific rule. You can specify a percentage, such as 10%. The default value is 10.
     */
    public Integer concurrentExecutionRatePercentage() {
        return concurrentExecutionRatePercentage;
    }

    /**
     * <p>
     * The percentage of errors that are allowed before SSM stops running automations on non-compliant resources for
     * that specific rule. You can specify a percentage of errors, for example 10%. If you do not specifiy a percentage,
     * the default is 50%. For example, if you set the ErrorPercentage to 40% for 10 non-compliant resources, then SSM
     * stops running the automations when the fifth error is received.
     * </p>
     * 
     * @return The percentage of errors that are allowed before SSM stops running automations on non-compliant resources
     *         for that specific rule. You can specify a percentage of errors, for example 10%. If you do not specifiy a
     *         percentage, the default is 50%. For example, if you set the ErrorPercentage to 40% for 10 non-compliant
     *         resources, then SSM stops running the automations when the fifth error is received.
     */
    public Integer errorPercentage() {
        return errorPercentage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(concurrentExecutionRatePercentage());
        hashCode = 31 * hashCode + Objects.hashCode(errorPercentage());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SsmControls)) {
            return false;
        }
        SsmControls other = (SsmControls) obj;
        return Objects.equals(concurrentExecutionRatePercentage(), other.concurrentExecutionRatePercentage())
                && Objects.equals(errorPercentage(), other.errorPercentage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("SsmControls").add("ConcurrentExecutionRatePercentage", concurrentExecutionRatePercentage())
                .add("ErrorPercentage", errorPercentage()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConcurrentExecutionRatePercentage":
            return Optional.ofNullable(clazz.cast(concurrentExecutionRatePercentage()));
        case "ErrorPercentage":
            return Optional.ofNullable(clazz.cast(errorPercentage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SsmControls, T> g) {
        return obj -> g.apply((SsmControls) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SsmControls> {
        /**
         * <p>
         * The maximum percentage of remediation actions allowed to run in parallel on the non-compliant resources for
         * that specific rule. You can specify a percentage, such as 10%. The default value is 10.
         * </p>
         * 
         * @param concurrentExecutionRatePercentage
         *        The maximum percentage of remediation actions allowed to run in parallel on the non-compliant
         *        resources for that specific rule. You can specify a percentage, such as 10%. The default value is 10.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder concurrentExecutionRatePercentage(Integer concurrentExecutionRatePercentage);

        /**
         * <p>
         * The percentage of errors that are allowed before SSM stops running automations on non-compliant resources for
         * that specific rule. You can specify a percentage of errors, for example 10%. If you do not specifiy a
         * percentage, the default is 50%. For example, if you set the ErrorPercentage to 40% for 10 non-compliant
         * resources, then SSM stops running the automations when the fifth error is received.
         * </p>
         * 
         * @param errorPercentage
         *        The percentage of errors that are allowed before SSM stops running automations on non-compliant
         *        resources for that specific rule. You can specify a percentage of errors, for example 10%. If you do
         *        not specifiy a percentage, the default is 50%. For example, if you set the ErrorPercentage to 40% for
         *        10 non-compliant resources, then SSM stops running the automations when the fifth error is received.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorPercentage(Integer errorPercentage);
    }

    static final class BuilderImpl implements Builder {
        private Integer concurrentExecutionRatePercentage;

        private Integer errorPercentage;

        private BuilderImpl() {
        }

        private BuilderImpl(SsmControls model) {
            concurrentExecutionRatePercentage(model.concurrentExecutionRatePercentage);
            errorPercentage(model.errorPercentage);
        }

        public final Integer getConcurrentExecutionRatePercentage() {
            return concurrentExecutionRatePercentage;
        }

        @Override
        public final Builder concurrentExecutionRatePercentage(Integer concurrentExecutionRatePercentage) {
            this.concurrentExecutionRatePercentage = concurrentExecutionRatePercentage;
            return this;
        }

        public final void setConcurrentExecutionRatePercentage(Integer concurrentExecutionRatePercentage) {
            this.concurrentExecutionRatePercentage = concurrentExecutionRatePercentage;
        }

        public final Integer getErrorPercentage() {
            return errorPercentage;
        }

        @Override
        public final Builder errorPercentage(Integer errorPercentage) {
            this.errorPercentage = errorPercentage;
            return this;
        }

        public final void setErrorPercentage(Integer errorPercentage) {
            this.errorPercentage = errorPercentage;
        }

        @Override
        public SsmControls build() {
            return new SsmControls(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
