/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The dynamic value of the resource.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResourceValue implements SdkPojo, Serializable, ToCopyableBuilder<ResourceValue.Builder, ResourceValue> {
    private static final SdkField<String> VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ResourceValue::valueAsString)).setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VALUE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String value;

    private ResourceValue(BuilderImpl builder) {
        this.value = builder.value;
    }

    /**
     * <p>
     * The value is a resource ID.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #value} will return
     * {@link ResourceValueType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #valueAsString}.
     * </p>
     * 
     * @return The value is a resource ID.
     * @see ResourceValueType
     */
    public ResourceValueType value() {
        return ResourceValueType.fromValue(value);
    }

    /**
     * <p>
     * The value is a resource ID.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #value} will return
     * {@link ResourceValueType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #valueAsString}.
     * </p>
     * 
     * @return The value is a resource ID.
     * @see ResourceValueType
     */
    public String valueAsString() {
        return value;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(valueAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceValue)) {
            return false;
        }
        ResourceValue other = (ResourceValue) obj;
        return Objects.equals(valueAsString(), other.valueAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ResourceValue").add("Value", valueAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Value":
            return Optional.ofNullable(clazz.cast(valueAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResourceValue, T> g) {
        return obj -> g.apply((ResourceValue) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResourceValue> {
        /**
         * <p>
         * The value is a resource ID.
         * </p>
         * 
         * @param value
         *        The value is a resource ID.
         * @see ResourceValueType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceValueType
         */
        Builder value(String value);

        /**
         * <p>
         * The value is a resource ID.
         * </p>
         * 
         * @param value
         *        The value is a resource ID.
         * @see ResourceValueType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceValueType
         */
        Builder value(ResourceValueType value);
    }

    static final class BuilderImpl implements Builder {
        private String value;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceValue model) {
            value(model.value);
        }

        public final String getValueAsString() {
            return value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        @Override
        public final Builder value(ResourceValueType value) {
            this.value(value == null ? null : value.toString());
            return this;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        @Override
        public ResourceValue build() {
            return new ResourceValue(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
