/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The number of AWS Config rules or AWS resources that are compliant and noncompliant.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ComplianceSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<ComplianceSummary.Builder, ComplianceSummary> {
    private static final SdkField<ComplianceContributorCount> COMPLIANT_RESOURCE_COUNT_FIELD = SdkField
            .<ComplianceContributorCount> builder(MarshallingType.SDK_POJO)
            .getter(getter(ComplianceSummary::compliantResourceCount)).setter(setter(Builder::compliantResourceCount))
            .constructor(ComplianceContributorCount::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompliantResourceCount").build())
            .build();

    private static final SdkField<ComplianceContributorCount> NON_COMPLIANT_RESOURCE_COUNT_FIELD = SdkField
            .<ComplianceContributorCount> builder(MarshallingType.SDK_POJO)
            .getter(getter(ComplianceSummary::nonCompliantResourceCount)).setter(setter(Builder::nonCompliantResourceCount))
            .constructor(ComplianceContributorCount::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NonCompliantResourceCount").build())
            .build();

    private static final SdkField<Instant> COMPLIANCE_SUMMARY_TIMESTAMP_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(ComplianceSummary::complianceSummaryTimestamp))
            .setter(setter(Builder::complianceSummaryTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComplianceSummaryTimestamp").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            COMPLIANT_RESOURCE_COUNT_FIELD, NON_COMPLIANT_RESOURCE_COUNT_FIELD, COMPLIANCE_SUMMARY_TIMESTAMP_FIELD));

    private static final long serialVersionUID = 1L;

    private final ComplianceContributorCount compliantResourceCount;

    private final ComplianceContributorCount nonCompliantResourceCount;

    private final Instant complianceSummaryTimestamp;

    private ComplianceSummary(BuilderImpl builder) {
        this.compliantResourceCount = builder.compliantResourceCount;
        this.nonCompliantResourceCount = builder.nonCompliantResourceCount;
        this.complianceSummaryTimestamp = builder.complianceSummaryTimestamp;
    }

    /**
     * <p>
     * The number of AWS Config rules or AWS resources that are compliant, up to a maximum of 25 for rules and 100 for
     * resources.
     * </p>
     * 
     * @return The number of AWS Config rules or AWS resources that are compliant, up to a maximum of 25 for rules and
     *         100 for resources.
     */
    public ComplianceContributorCount compliantResourceCount() {
        return compliantResourceCount;
    }

    /**
     * <p>
     * The number of AWS Config rules or AWS resources that are noncompliant, up to a maximum of 25 for rules and 100
     * for resources.
     * </p>
     * 
     * @return The number of AWS Config rules or AWS resources that are noncompliant, up to a maximum of 25 for rules
     *         and 100 for resources.
     */
    public ComplianceContributorCount nonCompliantResourceCount() {
        return nonCompliantResourceCount;
    }

    /**
     * <p>
     * The time that AWS Config created the compliance summary.
     * </p>
     * 
     * @return The time that AWS Config created the compliance summary.
     */
    public Instant complianceSummaryTimestamp() {
        return complianceSummaryTimestamp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(compliantResourceCount());
        hashCode = 31 * hashCode + Objects.hashCode(nonCompliantResourceCount());
        hashCode = 31 * hashCode + Objects.hashCode(complianceSummaryTimestamp());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComplianceSummary)) {
            return false;
        }
        ComplianceSummary other = (ComplianceSummary) obj;
        return Objects.equals(compliantResourceCount(), other.compliantResourceCount())
                && Objects.equals(nonCompliantResourceCount(), other.nonCompliantResourceCount())
                && Objects.equals(complianceSummaryTimestamp(), other.complianceSummaryTimestamp());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ComplianceSummary").add("CompliantResourceCount", compliantResourceCount())
                .add("NonCompliantResourceCount", nonCompliantResourceCount())
                .add("ComplianceSummaryTimestamp", complianceSummaryTimestamp()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CompliantResourceCount":
            return Optional.ofNullable(clazz.cast(compliantResourceCount()));
        case "NonCompliantResourceCount":
            return Optional.ofNullable(clazz.cast(nonCompliantResourceCount()));
        case "ComplianceSummaryTimestamp":
            return Optional.ofNullable(clazz.cast(complianceSummaryTimestamp()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ComplianceSummary, T> g) {
        return obj -> g.apply((ComplianceSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ComplianceSummary> {
        /**
         * <p>
         * The number of AWS Config rules or AWS resources that are compliant, up to a maximum of 25 for rules and 100
         * for resources.
         * </p>
         * 
         * @param compliantResourceCount
         *        The number of AWS Config rules or AWS resources that are compliant, up to a maximum of 25 for rules
         *        and 100 for resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder compliantResourceCount(ComplianceContributorCount compliantResourceCount);

        /**
         * <p>
         * The number of AWS Config rules or AWS resources that are compliant, up to a maximum of 25 for rules and 100
         * for resources.
         * </p>
         * This is a convenience that creates an instance of the {@link ComplianceContributorCount.Builder} avoiding the
         * need to create one manually via {@link ComplianceContributorCount#builder()}.
         *
         * When the {@link Consumer} completes, {@link ComplianceContributorCount.Builder#build()} is called immediately
         * and its result is passed to {@link #compliantResourceCount(ComplianceContributorCount)}.
         * 
         * @param compliantResourceCount
         *        a consumer that will call methods on {@link ComplianceContributorCount.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #compliantResourceCount(ComplianceContributorCount)
         */
        default Builder compliantResourceCount(Consumer<ComplianceContributorCount.Builder> compliantResourceCount) {
            return compliantResourceCount(ComplianceContributorCount.builder().applyMutation(compliantResourceCount).build());
        }

        /**
         * <p>
         * The number of AWS Config rules or AWS resources that are noncompliant, up to a maximum of 25 for rules and
         * 100 for resources.
         * </p>
         * 
         * @param nonCompliantResourceCount
         *        The number of AWS Config rules or AWS resources that are noncompliant, up to a maximum of 25 for rules
         *        and 100 for resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nonCompliantResourceCount(ComplianceContributorCount nonCompliantResourceCount);

        /**
         * <p>
         * The number of AWS Config rules or AWS resources that are noncompliant, up to a maximum of 25 for rules and
         * 100 for resources.
         * </p>
         * This is a convenience that creates an instance of the {@link ComplianceContributorCount.Builder} avoiding the
         * need to create one manually via {@link ComplianceContributorCount#builder()}.
         *
         * When the {@link Consumer} completes, {@link ComplianceContributorCount.Builder#build()} is called immediately
         * and its result is passed to {@link #nonCompliantResourceCount(ComplianceContributorCount)}.
         * 
         * @param nonCompliantResourceCount
         *        a consumer that will call methods on {@link ComplianceContributorCount.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #nonCompliantResourceCount(ComplianceContributorCount)
         */
        default Builder nonCompliantResourceCount(Consumer<ComplianceContributorCount.Builder> nonCompliantResourceCount) {
            return nonCompliantResourceCount(ComplianceContributorCount.builder().applyMutation(nonCompliantResourceCount)
                    .build());
        }

        /**
         * <p>
         * The time that AWS Config created the compliance summary.
         * </p>
         * 
         * @param complianceSummaryTimestamp
         *        The time that AWS Config created the compliance summary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder complianceSummaryTimestamp(Instant complianceSummaryTimestamp);
    }

    static final class BuilderImpl implements Builder {
        private ComplianceContributorCount compliantResourceCount;

        private ComplianceContributorCount nonCompliantResourceCount;

        private Instant complianceSummaryTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(ComplianceSummary model) {
            compliantResourceCount(model.compliantResourceCount);
            nonCompliantResourceCount(model.nonCompliantResourceCount);
            complianceSummaryTimestamp(model.complianceSummaryTimestamp);
        }

        public final ComplianceContributorCount.Builder getCompliantResourceCount() {
            return compliantResourceCount != null ? compliantResourceCount.toBuilder() : null;
        }

        @Override
        public final Builder compliantResourceCount(ComplianceContributorCount compliantResourceCount) {
            this.compliantResourceCount = compliantResourceCount;
            return this;
        }

        public final void setCompliantResourceCount(ComplianceContributorCount.BuilderImpl compliantResourceCount) {
            this.compliantResourceCount = compliantResourceCount != null ? compliantResourceCount.build() : null;
        }

        public final ComplianceContributorCount.Builder getNonCompliantResourceCount() {
            return nonCompliantResourceCount != null ? nonCompliantResourceCount.toBuilder() : null;
        }

        @Override
        public final Builder nonCompliantResourceCount(ComplianceContributorCount nonCompliantResourceCount) {
            this.nonCompliantResourceCount = nonCompliantResourceCount;
            return this;
        }

        public final void setNonCompliantResourceCount(ComplianceContributorCount.BuilderImpl nonCompliantResourceCount) {
            this.nonCompliantResourceCount = nonCompliantResourceCount != null ? nonCompliantResourceCount.build() : null;
        }

        public final Instant getComplianceSummaryTimestamp() {
            return complianceSummaryTimestamp;
        }

        @Override
        public final Builder complianceSummaryTimestamp(Instant complianceSummaryTimestamp) {
            this.complianceSummaryTimestamp = complianceSummaryTimestamp;
            return this;
        }

        public final void setComplianceSummaryTimestamp(Instant complianceSummaryTimestamp) {
            this.complianceSummaryTimestamp = complianceSummaryTimestamp;
        }

        @Override
        public ComplianceSummary build() {
            return new ComplianceSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
