/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetOrganizationConformancePackDetailedStatusResponse extends ConfigResponse
        implements
        ToCopyableBuilder<GetOrganizationConformancePackDetailedStatusResponse.Builder, GetOrganizationConformancePackDetailedStatusResponse> {
    private static final SdkField<List<OrganizationConformancePackDetailedStatus>> ORGANIZATION_CONFORMANCE_PACK_DETAILED_STATUSES_FIELD = SdkField
            .<List<OrganizationConformancePackDetailedStatus>> builder(MarshallingType.LIST)
            .getter(getter(GetOrganizationConformancePackDetailedStatusResponse::organizationConformancePackDetailedStatuses))
            .setter(setter(Builder::organizationConformancePackDetailedStatuses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("OrganizationConformancePackDetailedStatuses").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<OrganizationConformancePackDetailedStatus> builder(MarshallingType.SDK_POJO)
                                            .constructor(OrganizationConformancePackDetailedStatus::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetOrganizationConformancePackDetailedStatusResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ORGANIZATION_CONFORMANCE_PACK_DETAILED_STATUSES_FIELD, NEXT_TOKEN_FIELD));

    private final List<OrganizationConformancePackDetailedStatus> organizationConformancePackDetailedStatuses;

    private final String nextToken;

    private GetOrganizationConformancePackDetailedStatusResponse(BuilderImpl builder) {
        super(builder);
        this.organizationConformancePackDetailedStatuses = builder.organizationConformancePackDetailedStatuses;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the OrganizationConformancePackDetailedStatuses property was specified by the sender (it may be
     * empty), or false if the sender did not specify the value (it will be empty). For responses returned by the SDK,
     * the sender is the AWS service.
     */
    public boolean hasOrganizationConformancePackDetailedStatuses() {
        return organizationConformancePackDetailedStatuses != null
                && !(organizationConformancePackDetailedStatuses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <code>OrganizationConformancePackDetailedStatus</code> objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasOrganizationConformancePackDetailedStatuses()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of <code>OrganizationConformancePackDetailedStatus</code> objects.
     */
    public List<OrganizationConformancePackDetailedStatus> organizationConformancePackDetailedStatuses() {
        return organizationConformancePackDetailedStatuses;
    }

    /**
     * <p>
     * The nextToken string returned on a previous page that you use to get the next page of results in a paginated
     * response.
     * </p>
     * 
     * @return The nextToken string returned on a previous page that you use to get the next page of results in a
     *         paginated response.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(organizationConformancePackDetailedStatuses());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetOrganizationConformancePackDetailedStatusResponse)) {
            return false;
        }
        GetOrganizationConformancePackDetailedStatusResponse other = (GetOrganizationConformancePackDetailedStatusResponse) obj;
        return Objects.equals(organizationConformancePackDetailedStatuses(), other.organizationConformancePackDetailedStatuses())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetOrganizationConformancePackDetailedStatusResponse")
                .add("OrganizationConformancePackDetailedStatuses", organizationConformancePackDetailedStatuses())
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OrganizationConformancePackDetailedStatuses":
            return Optional.ofNullable(clazz.cast(organizationConformancePackDetailedStatuses()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetOrganizationConformancePackDetailedStatusResponse, T> g) {
        return obj -> g.apply((GetOrganizationConformancePackDetailedStatusResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConfigResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetOrganizationConformancePackDetailedStatusResponse> {
        /**
         * <p>
         * A list of <code>OrganizationConformancePackDetailedStatus</code> objects.
         * </p>
         * 
         * @param organizationConformancePackDetailedStatuses
         *        A list of <code>OrganizationConformancePackDetailedStatus</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder organizationConformancePackDetailedStatuses(
                Collection<OrganizationConformancePackDetailedStatus> organizationConformancePackDetailedStatuses);

        /**
         * <p>
         * A list of <code>OrganizationConformancePackDetailedStatus</code> objects.
         * </p>
         * 
         * @param organizationConformancePackDetailedStatuses
         *        A list of <code>OrganizationConformancePackDetailedStatus</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder organizationConformancePackDetailedStatuses(
                OrganizationConformancePackDetailedStatus... organizationConformancePackDetailedStatuses);

        /**
         * <p>
         * A list of <code>OrganizationConformancePackDetailedStatus</code> objects.
         * </p>
         * This is a convenience that creates an instance of the {@link List
         * <OrganizationConformancePackDetailedStatus>.Builder} avoiding the need to create one manually via
         * {@link List<OrganizationConformancePackDetailedStatus>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<OrganizationConformancePackDetailedStatus>.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #organizationConformancePackDetailedStatuses(List<OrganizationConformancePackDetailedStatus>)}.
         * 
         * @param organizationConformancePackDetailedStatuses
         *        a consumer that will call methods on {@link List<OrganizationConformancePackDetailedStatus>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #organizationConformancePackDetailedStatuses(List<OrganizationConformancePackDetailedStatus>)
         */
        Builder organizationConformancePackDetailedStatuses(
                Consumer<OrganizationConformancePackDetailedStatus.Builder>... organizationConformancePackDetailedStatuses);

        /**
         * <p>
         * The nextToken string returned on a previous page that you use to get the next page of results in a paginated
         * response.
         * </p>
         * 
         * @param nextToken
         *        The nextToken string returned on a previous page that you use to get the next page of results in a
         *        paginated response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ConfigResponse.BuilderImpl implements Builder {
        private List<OrganizationConformancePackDetailedStatus> organizationConformancePackDetailedStatuses = DefaultSdkAutoConstructList
                .getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetOrganizationConformancePackDetailedStatusResponse model) {
            super(model);
            organizationConformancePackDetailedStatuses(model.organizationConformancePackDetailedStatuses);
            nextToken(model.nextToken);
        }

        public final Collection<OrganizationConformancePackDetailedStatus.Builder> getOrganizationConformancePackDetailedStatuses() {
            return organizationConformancePackDetailedStatuses != null ? organizationConformancePackDetailedStatuses.stream()
                    .map(OrganizationConformancePackDetailedStatus::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder organizationConformancePackDetailedStatuses(
                Collection<OrganizationConformancePackDetailedStatus> organizationConformancePackDetailedStatuses) {
            this.organizationConformancePackDetailedStatuses = OrganizationConformancePackDetailedStatusesCopier
                    .copy(organizationConformancePackDetailedStatuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder organizationConformancePackDetailedStatuses(
                OrganizationConformancePackDetailedStatus... organizationConformancePackDetailedStatuses) {
            organizationConformancePackDetailedStatuses(Arrays.asList(organizationConformancePackDetailedStatuses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder organizationConformancePackDetailedStatuses(
                Consumer<OrganizationConformancePackDetailedStatus.Builder>... organizationConformancePackDetailedStatuses) {
            organizationConformancePackDetailedStatuses(Stream.of(organizationConformancePackDetailedStatuses)
                    .map(c -> OrganizationConformancePackDetailedStatus.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setOrganizationConformancePackDetailedStatuses(
                Collection<OrganizationConformancePackDetailedStatus.BuilderImpl> organizationConformancePackDetailedStatuses) {
            this.organizationConformancePackDetailedStatuses = OrganizationConformancePackDetailedStatusesCopier
                    .copyFromBuilder(organizationConformancePackDetailedStatuses);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public GetOrganizationConformancePackDetailedStatusResponse build() {
            return new GetOrganizationConformancePackDetailedStatusResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
