/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that represents the details about the remediation exception. The details include the rule name, an
 * explanation of an exception, the time when the exception will be deleted, the resource ID, and resource type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RemediationException implements SdkPojo, Serializable,
        ToCopyableBuilder<RemediationException.Builder, RemediationException> {
    private static final SdkField<String> CONFIG_RULE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RemediationException::configRuleName)).setter(setter(Builder::configRuleName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigRuleName").build()).build();

    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RemediationException::resourceType)).setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()).build();

    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RemediationException::resourceId)).setter(setter(Builder::resourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceId").build()).build();

    private static final SdkField<String> MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RemediationException::message)).setter(setter(Builder::message))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Message").build()).build();

    private static final SdkField<Instant> EXPIRATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(RemediationException::expirationTime)).setter(setter(Builder::expirationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpirationTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIG_RULE_NAME_FIELD,
            RESOURCE_TYPE_FIELD, RESOURCE_ID_FIELD, MESSAGE_FIELD, EXPIRATION_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String configRuleName;

    private final String resourceType;

    private final String resourceId;

    private final String message;

    private final Instant expirationTime;

    private RemediationException(BuilderImpl builder) {
        this.configRuleName = builder.configRuleName;
        this.resourceType = builder.resourceType;
        this.resourceId = builder.resourceId;
        this.message = builder.message;
        this.expirationTime = builder.expirationTime;
    }

    /**
     * <p>
     * The name of the AWS Config rule.
     * </p>
     * 
     * @return The name of the AWS Config rule.
     */
    public String configRuleName() {
        return configRuleName;
    }

    /**
     * <p>
     * The type of a resource.
     * </p>
     * 
     * @return The type of a resource.
     */
    public String resourceType() {
        return resourceType;
    }

    /**
     * <p>
     * The ID of the resource (for example., sg-xxxxxx).
     * </p>
     * 
     * @return The ID of the resource (for example., sg-xxxxxx).
     */
    public String resourceId() {
        return resourceId;
    }

    /**
     * <p>
     * An explanation of an remediation exception.
     * </p>
     * 
     * @return An explanation of an remediation exception.
     */
    public String message() {
        return message;
    }

    /**
     * <p>
     * The time when the remediation exception will be deleted.
     * </p>
     * 
     * @return The time when the remediation exception will be deleted.
     */
    public Instant expirationTime() {
        return expirationTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(configRuleName());
        hashCode = 31 * hashCode + Objects.hashCode(resourceType());
        hashCode = 31 * hashCode + Objects.hashCode(resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(message());
        hashCode = 31 * hashCode + Objects.hashCode(expirationTime());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RemediationException)) {
            return false;
        }
        RemediationException other = (RemediationException) obj;
        return Objects.equals(configRuleName(), other.configRuleName()) && Objects.equals(resourceType(), other.resourceType())
                && Objects.equals(resourceId(), other.resourceId()) && Objects.equals(message(), other.message())
                && Objects.equals(expirationTime(), other.expirationTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("RemediationException").add("ConfigRuleName", configRuleName())
                .add("ResourceType", resourceType()).add("ResourceId", resourceId()).add("Message", message())
                .add("ExpirationTime", expirationTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConfigRuleName":
            return Optional.ofNullable(clazz.cast(configRuleName()));
        case "ResourceType":
            return Optional.ofNullable(clazz.cast(resourceType()));
        case "ResourceId":
            return Optional.ofNullable(clazz.cast(resourceId()));
        case "Message":
            return Optional.ofNullable(clazz.cast(message()));
        case "ExpirationTime":
            return Optional.ofNullable(clazz.cast(expirationTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RemediationException, T> g) {
        return obj -> g.apply((RemediationException) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RemediationException> {
        /**
         * <p>
         * The name of the AWS Config rule.
         * </p>
         * 
         * @param configRuleName
         *        The name of the AWS Config rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configRuleName(String configRuleName);

        /**
         * <p>
         * The type of a resource.
         * </p>
         * 
         * @param resourceType
         *        The type of a resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * The ID of the resource (for example., sg-xxxxxx).
         * </p>
         * 
         * @param resourceId
         *        The ID of the resource (for example., sg-xxxxxx).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceId(String resourceId);

        /**
         * <p>
         * An explanation of an remediation exception.
         * </p>
         * 
         * @param message
         *        An explanation of an remediation exception.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);

        /**
         * <p>
         * The time when the remediation exception will be deleted.
         * </p>
         * 
         * @param expirationTime
         *        The time when the remediation exception will be deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expirationTime(Instant expirationTime);
    }

    static final class BuilderImpl implements Builder {
        private String configRuleName;

        private String resourceType;

        private String resourceId;

        private String message;

        private Instant expirationTime;

        private BuilderImpl() {
        }

        private BuilderImpl(RemediationException model) {
            configRuleName(model.configRuleName);
            resourceType(model.resourceType);
            resourceId(model.resourceId);
            message(model.message);
            expirationTime(model.expirationTime);
        }

        public final String getConfigRuleName() {
            return configRuleName;
        }

        @Override
        public final Builder configRuleName(String configRuleName) {
            this.configRuleName = configRuleName;
            return this;
        }

        public final void setConfigRuleName(String configRuleName) {
            this.configRuleName = configRuleName;
        }

        public final String getResourceType() {
            return resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public final String getResourceId() {
            return resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        public final String getMessage() {
            return message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        public final Instant getExpirationTime() {
            return expirationTime;
        }

        @Override
        public final Builder expirationTime(Instant expirationTime) {
            this.expirationTime = expirationTime;
            return this;
        }

        public final void setExpirationTime(Instant expirationTime) {
            this.expirationTime = expirationTime;
        }

        @Override
        public RemediationException build() {
            return new RemediationException(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
