/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutRemediationConfigurationsRequest extends ConfigRequest implements
        ToCopyableBuilder<PutRemediationConfigurationsRequest.Builder, PutRemediationConfigurationsRequest> {
    private static final SdkField<List<RemediationConfiguration>> REMEDIATION_CONFIGURATIONS_FIELD = SdkField
            .<List<RemediationConfiguration>> builder(MarshallingType.LIST)
            .getter(getter(PutRemediationConfigurationsRequest::remediationConfigurations))
            .setter(setter(Builder::remediationConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemediationConfigurations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RemediationConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(RemediationConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(REMEDIATION_CONFIGURATIONS_FIELD));

    private final List<RemediationConfiguration> remediationConfigurations;

    private PutRemediationConfigurationsRequest(BuilderImpl builder) {
        super(builder);
        this.remediationConfigurations = builder.remediationConfigurations;
    }

    /**
     * Returns true if the RemediationConfigurations property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasRemediationConfigurations() {
        return remediationConfigurations != null && !(remediationConfigurations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of remediation configuration objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasRemediationConfigurations()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of remediation configuration objects.
     */
    public List<RemediationConfiguration> remediationConfigurations() {
        return remediationConfigurations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(remediationConfigurations());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutRemediationConfigurationsRequest)) {
            return false;
        }
        PutRemediationConfigurationsRequest other = (PutRemediationConfigurationsRequest) obj;
        return Objects.equals(remediationConfigurations(), other.remediationConfigurations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("PutRemediationConfigurationsRequest")
                .add("RemediationConfigurations", remediationConfigurations()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RemediationConfigurations":
            return Optional.ofNullable(clazz.cast(remediationConfigurations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutRemediationConfigurationsRequest, T> g) {
        return obj -> g.apply((PutRemediationConfigurationsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConfigRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, PutRemediationConfigurationsRequest> {
        /**
         * <p>
         * A list of remediation configuration objects.
         * </p>
         * 
         * @param remediationConfigurations
         *        A list of remediation configuration objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder remediationConfigurations(Collection<RemediationConfiguration> remediationConfigurations);

        /**
         * <p>
         * A list of remediation configuration objects.
         * </p>
         * 
         * @param remediationConfigurations
         *        A list of remediation configuration objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder remediationConfigurations(RemediationConfiguration... remediationConfigurations);

        /**
         * <p>
         * A list of remediation configuration objects.
         * </p>
         * This is a convenience that creates an instance of the {@link List<RemediationConfiguration>.Builder} avoiding
         * the need to create one manually via {@link List<RemediationConfiguration>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<RemediationConfiguration>.Builder#build()} is called
         * immediately and its result is passed to {@link #remediationConfigurations(List<RemediationConfiguration>)}.
         * 
         * @param remediationConfigurations
         *        a consumer that will call methods on {@link List<RemediationConfiguration>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #remediationConfigurations(List<RemediationConfiguration>)
         */
        Builder remediationConfigurations(Consumer<RemediationConfiguration.Builder>... remediationConfigurations);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ConfigRequest.BuilderImpl implements Builder {
        private List<RemediationConfiguration> remediationConfigurations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PutRemediationConfigurationsRequest model) {
            super(model);
            remediationConfigurations(model.remediationConfigurations);
        }

        public final Collection<RemediationConfiguration.Builder> getRemediationConfigurations() {
            return remediationConfigurations != null ? remediationConfigurations.stream()
                    .map(RemediationConfiguration::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder remediationConfigurations(Collection<RemediationConfiguration> remediationConfigurations) {
            this.remediationConfigurations = RemediationConfigurationsCopier.copy(remediationConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder remediationConfigurations(RemediationConfiguration... remediationConfigurations) {
            remediationConfigurations(Arrays.asList(remediationConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder remediationConfigurations(Consumer<RemediationConfiguration.Builder>... remediationConfigurations) {
            remediationConfigurations(Stream.of(remediationConfigurations)
                    .map(c -> RemediationConfiguration.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRemediationConfigurations(Collection<RemediationConfiguration.BuilderImpl> remediationConfigurations) {
            this.remediationConfigurations = RemediationConfigurationsCopier.copyFromBuilder(remediationConfigurations);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutRemediationConfigurationsRequest build() {
            return new PutRemediationConfigurationsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
