/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Returns the status for an organization config rule in an organization.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OrganizationConfigRuleStatus implements SdkPojo, Serializable,
        ToCopyableBuilder<OrganizationConfigRuleStatus.Builder, OrganizationConfigRuleStatus> {
    private static final SdkField<String> ORGANIZATION_CONFIG_RULE_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(OrganizationConfigRuleStatus::organizationConfigRuleName))
            .setter(setter(Builder::organizationConfigRuleName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationConfigRuleName").build())
            .build();

    private static final SdkField<String> ORGANIZATION_RULE_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(OrganizationConfigRuleStatus::organizationRuleStatusAsString))
            .setter(setter(Builder::organizationRuleStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationRuleStatus").build())
            .build();

    private static final SdkField<String> ERROR_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(OrganizationConfigRuleStatus::errorCode)).setter(setter(Builder::errorCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorCode").build()).build();

    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(OrganizationConfigRuleStatus::errorMessage)).setter(setter(Builder::errorMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorMessage").build()).build();

    private static final SdkField<Instant> LAST_UPDATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(OrganizationConfigRuleStatus::lastUpdateTime)).setter(setter(Builder::lastUpdateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdateTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ORGANIZATION_CONFIG_RULE_NAME_FIELD, ORGANIZATION_RULE_STATUS_FIELD, ERROR_CODE_FIELD, ERROR_MESSAGE_FIELD,
            LAST_UPDATE_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String organizationConfigRuleName;

    private final String organizationRuleStatus;

    private final String errorCode;

    private final String errorMessage;

    private final Instant lastUpdateTime;

    private OrganizationConfigRuleStatus(BuilderImpl builder) {
        this.organizationConfigRuleName = builder.organizationConfigRuleName;
        this.organizationRuleStatus = builder.organizationRuleStatus;
        this.errorCode = builder.errorCode;
        this.errorMessage = builder.errorMessage;
        this.lastUpdateTime = builder.lastUpdateTime;
    }

    /**
     * <p>
     * The name that you assign to organization config rule.
     * </p>
     * 
     * @return The name that you assign to organization config rule.
     */
    public String organizationConfigRuleName() {
        return organizationConfigRuleName;
    }

    /**
     * <p>
     * Indicates deployment status of an organization config rule. When master account calls PutOrganizationConfigRule
     * action for the first time, config rule status is created in all the member accounts. When master account calls
     * PutOrganizationConfigRule action for the second time, config rule status is updated in all the member accounts.
     * Additionally, config rule status is updated when one or more member accounts join or leave an organization.
     * Config rule status is deleted when the master account deletes OrganizationConfigRule in all the member accounts
     * and disables service access for <code>config-multiaccountsetup.amazonaws.com</code>.
     * </p>
     * <p>
     * AWS Config sets the state of the rule to:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CREATE_SUCCESSFUL</code> when an organization config rule has been successfully created in all the member
     * accounts.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CREATE_IN_PROGRESS</code> when an organization config rule creation is in progress.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CREATE_FAILED</code> when an organization config rule creation failed in one or more member accounts within
     * that organization.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETE_FAILED</code> when an organization config rule deletion failed in one or more member accounts within
     * that organization.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETE_IN_PROGRESS</code> when an organization config rule deletion is in progress.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETE_SUCCESSFUL</code> when an organization config rule has been successfully deleted from all the member
     * accounts.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UPDATE_SUCCESSFUL</code> when an organization config rule has been successfully updated in all the member
     * accounts.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UPDATE_IN_PROGRESS</code> when an organization config rule update is in progress.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UPDATE_FAILED</code> when an organization config rule update failed in one or more member accounts within
     * that organization.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #organizationRuleStatus} will return {@link OrganizationRuleStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #organizationRuleStatusAsString}.
     * </p>
     * 
     * @return Indicates deployment status of an organization config rule. When master account calls
     *         PutOrganizationConfigRule action for the first time, config rule status is created in all the member
     *         accounts. When master account calls PutOrganizationConfigRule action for the second time, config rule
     *         status is updated in all the member accounts. Additionally, config rule status is updated when one or
     *         more member accounts join or leave an organization. Config rule status is deleted when the master account
     *         deletes OrganizationConfigRule in all the member accounts and disables service access for
     *         <code>config-multiaccountsetup.amazonaws.com</code>.</p>
     *         <p>
     *         AWS Config sets the state of the rule to:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CREATE_SUCCESSFUL</code> when an organization config rule has been successfully created in all the
     *         member accounts.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CREATE_IN_PROGRESS</code> when an organization config rule creation is in progress.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CREATE_FAILED</code> when an organization config rule creation failed in one or more member
     *         accounts within that organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELETE_FAILED</code> when an organization config rule deletion failed in one or more member
     *         accounts within that organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELETE_IN_PROGRESS</code> when an organization config rule deletion is in progress.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELETE_SUCCESSFUL</code> when an organization config rule has been successfully deleted from all
     *         the member accounts.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UPDATE_SUCCESSFUL</code> when an organization config rule has been successfully updated in all the
     *         member accounts.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UPDATE_IN_PROGRESS</code> when an organization config rule update is in progress.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UPDATE_FAILED</code> when an organization config rule update failed in one or more member accounts
     *         within that organization.
     *         </p>
     *         </li>
     * @see OrganizationRuleStatus
     */
    public OrganizationRuleStatus organizationRuleStatus() {
        return OrganizationRuleStatus.fromValue(organizationRuleStatus);
    }

    /**
     * <p>
     * Indicates deployment status of an organization config rule. When master account calls PutOrganizationConfigRule
     * action for the first time, config rule status is created in all the member accounts. When master account calls
     * PutOrganizationConfigRule action for the second time, config rule status is updated in all the member accounts.
     * Additionally, config rule status is updated when one or more member accounts join or leave an organization.
     * Config rule status is deleted when the master account deletes OrganizationConfigRule in all the member accounts
     * and disables service access for <code>config-multiaccountsetup.amazonaws.com</code>.
     * </p>
     * <p>
     * AWS Config sets the state of the rule to:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CREATE_SUCCESSFUL</code> when an organization config rule has been successfully created in all the member
     * accounts.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CREATE_IN_PROGRESS</code> when an organization config rule creation is in progress.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CREATE_FAILED</code> when an organization config rule creation failed in one or more member accounts within
     * that organization.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETE_FAILED</code> when an organization config rule deletion failed in one or more member accounts within
     * that organization.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETE_IN_PROGRESS</code> when an organization config rule deletion is in progress.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETE_SUCCESSFUL</code> when an organization config rule has been successfully deleted from all the member
     * accounts.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UPDATE_SUCCESSFUL</code> when an organization config rule has been successfully updated in all the member
     * accounts.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UPDATE_IN_PROGRESS</code> when an organization config rule update is in progress.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UPDATE_FAILED</code> when an organization config rule update failed in one or more member accounts within
     * that organization.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #organizationRuleStatus} will return {@link OrganizationRuleStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #organizationRuleStatusAsString}.
     * </p>
     * 
     * @return Indicates deployment status of an organization config rule. When master account calls
     *         PutOrganizationConfigRule action for the first time, config rule status is created in all the member
     *         accounts. When master account calls PutOrganizationConfigRule action for the second time, config rule
     *         status is updated in all the member accounts. Additionally, config rule status is updated when one or
     *         more member accounts join or leave an organization. Config rule status is deleted when the master account
     *         deletes OrganizationConfigRule in all the member accounts and disables service access for
     *         <code>config-multiaccountsetup.amazonaws.com</code>.</p>
     *         <p>
     *         AWS Config sets the state of the rule to:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CREATE_SUCCESSFUL</code> when an organization config rule has been successfully created in all the
     *         member accounts.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CREATE_IN_PROGRESS</code> when an organization config rule creation is in progress.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CREATE_FAILED</code> when an organization config rule creation failed in one or more member
     *         accounts within that organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELETE_FAILED</code> when an organization config rule deletion failed in one or more member
     *         accounts within that organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELETE_IN_PROGRESS</code> when an organization config rule deletion is in progress.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELETE_SUCCESSFUL</code> when an organization config rule has been successfully deleted from all
     *         the member accounts.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UPDATE_SUCCESSFUL</code> when an organization config rule has been successfully updated in all the
     *         member accounts.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UPDATE_IN_PROGRESS</code> when an organization config rule update is in progress.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UPDATE_FAILED</code> when an organization config rule update failed in one or more member accounts
     *         within that organization.
     *         </p>
     *         </li>
     * @see OrganizationRuleStatus
     */
    public String organizationRuleStatusAsString() {
        return organizationRuleStatus;
    }

    /**
     * <p>
     * An error code that is returned when organization config rule creation or deletion has failed.
     * </p>
     * 
     * @return An error code that is returned when organization config rule creation or deletion has failed.
     */
    public String errorCode() {
        return errorCode;
    }

    /**
     * <p>
     * An error message indicating that organization config rule creation or deletion failed due to an error.
     * </p>
     * 
     * @return An error message indicating that organization config rule creation or deletion failed due to an error.
     */
    public String errorMessage() {
        return errorMessage;
    }

    /**
     * <p>
     * The timestamp of the last update.
     * </p>
     * 
     * @return The timestamp of the last update.
     */
    public Instant lastUpdateTime() {
        return lastUpdateTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(organizationConfigRuleName());
        hashCode = 31 * hashCode + Objects.hashCode(organizationRuleStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(errorCode());
        hashCode = 31 * hashCode + Objects.hashCode(errorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdateTime());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OrganizationConfigRuleStatus)) {
            return false;
        }
        OrganizationConfigRuleStatus other = (OrganizationConfigRuleStatus) obj;
        return Objects.equals(organizationConfigRuleName(), other.organizationConfigRuleName())
                && Objects.equals(organizationRuleStatusAsString(), other.organizationRuleStatusAsString())
                && Objects.equals(errorCode(), other.errorCode()) && Objects.equals(errorMessage(), other.errorMessage())
                && Objects.equals(lastUpdateTime(), other.lastUpdateTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("OrganizationConfigRuleStatus").add("OrganizationConfigRuleName", organizationConfigRuleName())
                .add("OrganizationRuleStatus", organizationRuleStatusAsString()).add("ErrorCode", errorCode())
                .add("ErrorMessage", errorMessage()).add("LastUpdateTime", lastUpdateTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OrganizationConfigRuleName":
            return Optional.ofNullable(clazz.cast(organizationConfigRuleName()));
        case "OrganizationRuleStatus":
            return Optional.ofNullable(clazz.cast(organizationRuleStatusAsString()));
        case "ErrorCode":
            return Optional.ofNullable(clazz.cast(errorCode()));
        case "ErrorMessage":
            return Optional.ofNullable(clazz.cast(errorMessage()));
        case "LastUpdateTime":
            return Optional.ofNullable(clazz.cast(lastUpdateTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OrganizationConfigRuleStatus, T> g) {
        return obj -> g.apply((OrganizationConfigRuleStatus) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OrganizationConfigRuleStatus> {
        /**
         * <p>
         * The name that you assign to organization config rule.
         * </p>
         * 
         * @param organizationConfigRuleName
         *        The name that you assign to organization config rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder organizationConfigRuleName(String organizationConfigRuleName);

        /**
         * <p>
         * Indicates deployment status of an organization config rule. When master account calls
         * PutOrganizationConfigRule action for the first time, config rule status is created in all the member
         * accounts. When master account calls PutOrganizationConfigRule action for the second time, config rule status
         * is updated in all the member accounts. Additionally, config rule status is updated when one or more member
         * accounts join or leave an organization. Config rule status is deleted when the master account deletes
         * OrganizationConfigRule in all the member accounts and disables service access for
         * <code>config-multiaccountsetup.amazonaws.com</code>.
         * </p>
         * <p>
         * AWS Config sets the state of the rule to:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CREATE_SUCCESSFUL</code> when an organization config rule has been successfully created in all the
         * member accounts.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CREATE_IN_PROGRESS</code> when an organization config rule creation is in progress.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CREATE_FAILED</code> when an organization config rule creation failed in one or more member accounts
         * within that organization.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETE_FAILED</code> when an organization config rule deletion failed in one or more member accounts
         * within that organization.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETE_IN_PROGRESS</code> when an organization config rule deletion is in progress.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETE_SUCCESSFUL</code> when an organization config rule has been successfully deleted from all the
         * member accounts.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UPDATE_SUCCESSFUL</code> when an organization config rule has been successfully updated in all the
         * member accounts.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UPDATE_IN_PROGRESS</code> when an organization config rule update is in progress.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UPDATE_FAILED</code> when an organization config rule update failed in one or more member accounts
         * within that organization.
         * </p>
         * </li>
         * </ul>
         * 
         * @param organizationRuleStatus
         *        Indicates deployment status of an organization config rule. When master account calls
         *        PutOrganizationConfigRule action for the first time, config rule status is created in all the member
         *        accounts. When master account calls PutOrganizationConfigRule action for the second time, config rule
         *        status is updated in all the member accounts. Additionally, config rule status is updated when one or
         *        more member accounts join or leave an organization. Config rule status is deleted when the master
         *        account deletes OrganizationConfigRule in all the member accounts and disables service access for
         *        <code>config-multiaccountsetup.amazonaws.com</code>.</p>
         *        <p>
         *        AWS Config sets the state of the rule to:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CREATE_SUCCESSFUL</code> when an organization config rule has been successfully created in all
         *        the member accounts.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CREATE_IN_PROGRESS</code> when an organization config rule creation is in progress.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CREATE_FAILED</code> when an organization config rule creation failed in one or more member
         *        accounts within that organization.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETE_FAILED</code> when an organization config rule deletion failed in one or more member
         *        accounts within that organization.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETE_IN_PROGRESS</code> when an organization config rule deletion is in progress.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETE_SUCCESSFUL</code> when an organization config rule has been successfully deleted from all
         *        the member accounts.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UPDATE_SUCCESSFUL</code> when an organization config rule has been successfully updated in all
         *        the member accounts.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UPDATE_IN_PROGRESS</code> when an organization config rule update is in progress.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UPDATE_FAILED</code> when an organization config rule update failed in one or more member
         *        accounts within that organization.
         *        </p>
         *        </li>
         * @see OrganizationRuleStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OrganizationRuleStatus
         */
        Builder organizationRuleStatus(String organizationRuleStatus);

        /**
         * <p>
         * Indicates deployment status of an organization config rule. When master account calls
         * PutOrganizationConfigRule action for the first time, config rule status is created in all the member
         * accounts. When master account calls PutOrganizationConfigRule action for the second time, config rule status
         * is updated in all the member accounts. Additionally, config rule status is updated when one or more member
         * accounts join or leave an organization. Config rule status is deleted when the master account deletes
         * OrganizationConfigRule in all the member accounts and disables service access for
         * <code>config-multiaccountsetup.amazonaws.com</code>.
         * </p>
         * <p>
         * AWS Config sets the state of the rule to:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CREATE_SUCCESSFUL</code> when an organization config rule has been successfully created in all the
         * member accounts.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CREATE_IN_PROGRESS</code> when an organization config rule creation is in progress.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CREATE_FAILED</code> when an organization config rule creation failed in one or more member accounts
         * within that organization.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETE_FAILED</code> when an organization config rule deletion failed in one or more member accounts
         * within that organization.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETE_IN_PROGRESS</code> when an organization config rule deletion is in progress.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETE_SUCCESSFUL</code> when an organization config rule has been successfully deleted from all the
         * member accounts.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UPDATE_SUCCESSFUL</code> when an organization config rule has been successfully updated in all the
         * member accounts.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UPDATE_IN_PROGRESS</code> when an organization config rule update is in progress.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UPDATE_FAILED</code> when an organization config rule update failed in one or more member accounts
         * within that organization.
         * </p>
         * </li>
         * </ul>
         * 
         * @param organizationRuleStatus
         *        Indicates deployment status of an organization config rule. When master account calls
         *        PutOrganizationConfigRule action for the first time, config rule status is created in all the member
         *        accounts. When master account calls PutOrganizationConfigRule action for the second time, config rule
         *        status is updated in all the member accounts. Additionally, config rule status is updated when one or
         *        more member accounts join or leave an organization. Config rule status is deleted when the master
         *        account deletes OrganizationConfigRule in all the member accounts and disables service access for
         *        <code>config-multiaccountsetup.amazonaws.com</code>.</p>
         *        <p>
         *        AWS Config sets the state of the rule to:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CREATE_SUCCESSFUL</code> when an organization config rule has been successfully created in all
         *        the member accounts.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CREATE_IN_PROGRESS</code> when an organization config rule creation is in progress.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CREATE_FAILED</code> when an organization config rule creation failed in one or more member
         *        accounts within that organization.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETE_FAILED</code> when an organization config rule deletion failed in one or more member
         *        accounts within that organization.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETE_IN_PROGRESS</code> when an organization config rule deletion is in progress.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETE_SUCCESSFUL</code> when an organization config rule has been successfully deleted from all
         *        the member accounts.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UPDATE_SUCCESSFUL</code> when an organization config rule has been successfully updated in all
         *        the member accounts.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UPDATE_IN_PROGRESS</code> when an organization config rule update is in progress.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UPDATE_FAILED</code> when an organization config rule update failed in one or more member
         *        accounts within that organization.
         *        </p>
         *        </li>
         * @see OrganizationRuleStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OrganizationRuleStatus
         */
        Builder organizationRuleStatus(OrganizationRuleStatus organizationRuleStatus);

        /**
         * <p>
         * An error code that is returned when organization config rule creation or deletion has failed.
         * </p>
         * 
         * @param errorCode
         *        An error code that is returned when organization config rule creation or deletion has failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorCode(String errorCode);

        /**
         * <p>
         * An error message indicating that organization config rule creation or deletion failed due to an error.
         * </p>
         * 
         * @param errorMessage
         *        An error message indicating that organization config rule creation or deletion failed due to an error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorMessage(String errorMessage);

        /**
         * <p>
         * The timestamp of the last update.
         * </p>
         * 
         * @param lastUpdateTime
         *        The timestamp of the last update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdateTime(Instant lastUpdateTime);
    }

    static final class BuilderImpl implements Builder {
        private String organizationConfigRuleName;

        private String organizationRuleStatus;

        private String errorCode;

        private String errorMessage;

        private Instant lastUpdateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(OrganizationConfigRuleStatus model) {
            organizationConfigRuleName(model.organizationConfigRuleName);
            organizationRuleStatus(model.organizationRuleStatus);
            errorCode(model.errorCode);
            errorMessage(model.errorMessage);
            lastUpdateTime(model.lastUpdateTime);
        }

        public final String getOrganizationConfigRuleName() {
            return organizationConfigRuleName;
        }

        @Override
        public final Builder organizationConfigRuleName(String organizationConfigRuleName) {
            this.organizationConfigRuleName = organizationConfigRuleName;
            return this;
        }

        public final void setOrganizationConfigRuleName(String organizationConfigRuleName) {
            this.organizationConfigRuleName = organizationConfigRuleName;
        }

        public final String getOrganizationRuleStatusAsString() {
            return organizationRuleStatus;
        }

        @Override
        public final Builder organizationRuleStatus(String organizationRuleStatus) {
            this.organizationRuleStatus = organizationRuleStatus;
            return this;
        }

        @Override
        public final Builder organizationRuleStatus(OrganizationRuleStatus organizationRuleStatus) {
            this.organizationRuleStatus(organizationRuleStatus == null ? null : organizationRuleStatus.toString());
            return this;
        }

        public final void setOrganizationRuleStatus(String organizationRuleStatus) {
            this.organizationRuleStatus = organizationRuleStatus;
        }

        public final String getErrorCode() {
            return errorCode;
        }

        @Override
        public final Builder errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        public final void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public final String getErrorMessage() {
            return errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        public final Instant getLastUpdateTime() {
            return lastUpdateTime;
        }

        @Override
        public final Builder lastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
            return this;
        }

        public final void setLastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
        }

        @Override
        public OrganizationConfigRuleStatus build() {
            return new OrganizationConfigRuleStatus(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
