/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import static java.util.stream.Collectors.toList;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class RemediationExceptionsCopier {
    static List<RemediationException> copy(Collection<RemediationException> remediationExceptionsParam) {
        if (remediationExceptionsParam == null || remediationExceptionsParam instanceof SdkAutoConstructList) {
            return DefaultSdkAutoConstructList.getInstance();
        }
        List<RemediationException> remediationExceptionsParamCopy = new ArrayList<>(remediationExceptionsParam);
        return Collections.unmodifiableList(remediationExceptionsParamCopy);
    }

    static List<RemediationException> copyFromBuilder(
            Collection<? extends RemediationException.Builder> remediationExceptionsParam) {
        if (remediationExceptionsParam == null) {
            return null;
        }
        return copy(remediationExceptionsParam.stream().map(RemediationException.Builder::build).collect(toList()));
    }
}
