/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeOrganizationConformancePackStatusesResponse extends ConfigResponse
        implements
        ToCopyableBuilder<DescribeOrganizationConformancePackStatusesResponse.Builder, DescribeOrganizationConformancePackStatusesResponse> {
    private static final SdkField<List<OrganizationConformancePackStatus>> ORGANIZATION_CONFORMANCE_PACK_STATUSES_FIELD = SdkField
            .<List<OrganizationConformancePackStatus>> builder(MarshallingType.LIST)
            .getter(getter(DescribeOrganizationConformancePackStatusesResponse::organizationConformancePackStatuses))
            .setter(setter(Builder::organizationConformancePackStatuses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("OrganizationConformancePackStatuses").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<OrganizationConformancePackStatus> builder(MarshallingType.SDK_POJO)
                                            .constructor(OrganizationConformancePackStatus::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeOrganizationConformancePackStatusesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ORGANIZATION_CONFORMANCE_PACK_STATUSES_FIELD, NEXT_TOKEN_FIELD));

    private final List<OrganizationConformancePackStatus> organizationConformancePackStatuses;

    private final String nextToken;

    private DescribeOrganizationConformancePackStatusesResponse(BuilderImpl builder) {
        super(builder);
        this.organizationConformancePackStatuses = builder.organizationConformancePackStatuses;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the OrganizationConformancePackStatuses property was specified by the sender (it may be empty),
     * or false if the sender did not specify the value (it will be empty). For responses returned by the SDK, the
     * sender is the AWS service.
     */
    public boolean hasOrganizationConformancePackStatuses() {
        return organizationConformancePackStatuses != null
                && !(organizationConformancePackStatuses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <code>OrganizationConformancePackStatus</code> objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasOrganizationConformancePackStatuses()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of <code>OrganizationConformancePackStatus</code> objects.
     */
    public List<OrganizationConformancePackStatus> organizationConformancePackStatuses() {
        return organizationConformancePackStatuses;
    }

    /**
     * <p>
     * The nextToken string returned on a previous page that you use to get the next page of results in a paginated
     * response.
     * </p>
     * 
     * @return The nextToken string returned on a previous page that you use to get the next page of results in a
     *         paginated response.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(organizationConformancePackStatuses());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeOrganizationConformancePackStatusesResponse)) {
            return false;
        }
        DescribeOrganizationConformancePackStatusesResponse other = (DescribeOrganizationConformancePackStatusesResponse) obj;
        return Objects.equals(organizationConformancePackStatuses(), other.organizationConformancePackStatuses())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeOrganizationConformancePackStatusesResponse")
                .add("OrganizationConformancePackStatuses", organizationConformancePackStatuses()).add("NextToken", nextToken())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OrganizationConformancePackStatuses":
            return Optional.ofNullable(clazz.cast(organizationConformancePackStatuses()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeOrganizationConformancePackStatusesResponse, T> g) {
        return obj -> g.apply((DescribeOrganizationConformancePackStatusesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConfigResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeOrganizationConformancePackStatusesResponse> {
        /**
         * <p>
         * A list of <code>OrganizationConformancePackStatus</code> objects.
         * </p>
         * 
         * @param organizationConformancePackStatuses
         *        A list of <code>OrganizationConformancePackStatus</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder organizationConformancePackStatuses(
                Collection<OrganizationConformancePackStatus> organizationConformancePackStatuses);

        /**
         * <p>
         * A list of <code>OrganizationConformancePackStatus</code> objects.
         * </p>
         * 
         * @param organizationConformancePackStatuses
         *        A list of <code>OrganizationConformancePackStatus</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder organizationConformancePackStatuses(OrganizationConformancePackStatus... organizationConformancePackStatuses);

        /**
         * <p>
         * A list of <code>OrganizationConformancePackStatus</code> objects.
         * </p>
         * This is a convenience that creates an instance of the {@link List<OrganizationConformancePackStatus>.Builder}
         * avoiding the need to create one manually via {@link List<OrganizationConformancePackStatus>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<OrganizationConformancePackStatus>.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #organizationConformancePackStatuses(List<OrganizationConformancePackStatus>)}.
         * 
         * @param organizationConformancePackStatuses
         *        a consumer that will call methods on {@link List<OrganizationConformancePackStatus>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #organizationConformancePackStatuses(List<OrganizationConformancePackStatus>)
         */
        Builder organizationConformancePackStatuses(
                Consumer<OrganizationConformancePackStatus.Builder>... organizationConformancePackStatuses);

        /**
         * <p>
         * The nextToken string returned on a previous page that you use to get the next page of results in a paginated
         * response.
         * </p>
         * 
         * @param nextToken
         *        The nextToken string returned on a previous page that you use to get the next page of results in a
         *        paginated response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ConfigResponse.BuilderImpl implements Builder {
        private List<OrganizationConformancePackStatus> organizationConformancePackStatuses = DefaultSdkAutoConstructList
                .getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeOrganizationConformancePackStatusesResponse model) {
            super(model);
            organizationConformancePackStatuses(model.organizationConformancePackStatuses);
            nextToken(model.nextToken);
        }

        public final Collection<OrganizationConformancePackStatus.Builder> getOrganizationConformancePackStatuses() {
            return organizationConformancePackStatuses != null ? organizationConformancePackStatuses.stream()
                    .map(OrganizationConformancePackStatus::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder organizationConformancePackStatuses(
                Collection<OrganizationConformancePackStatus> organizationConformancePackStatuses) {
            this.organizationConformancePackStatuses = OrganizationConformancePackStatusesCopier
                    .copy(organizationConformancePackStatuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder organizationConformancePackStatuses(
                OrganizationConformancePackStatus... organizationConformancePackStatuses) {
            organizationConformancePackStatuses(Arrays.asList(organizationConformancePackStatuses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder organizationConformancePackStatuses(
                Consumer<OrganizationConformancePackStatus.Builder>... organizationConformancePackStatuses) {
            organizationConformancePackStatuses(Stream.of(organizationConformancePackStatuses)
                    .map(c -> OrganizationConformancePackStatus.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setOrganizationConformancePackStatuses(
                Collection<OrganizationConformancePackStatus.BuilderImpl> organizationConformancePackStatuses) {
            this.organizationConformancePackStatuses = OrganizationConformancePackStatusesCopier
                    .copyFromBuilder(organizationConformancePackStatuses);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeOrganizationConformancePackStatusesResponse build() {
            return new DescribeOrganizationConformancePackStatusesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
