/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Filters the compliance results based on account ID, region, compliance type, and rule name.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConfigRuleComplianceFilters implements SdkPojo, Serializable,
        ToCopyableBuilder<ConfigRuleComplianceFilters.Builder, ConfigRuleComplianceFilters> {
    private static final SdkField<String> CONFIG_RULE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ConfigRuleComplianceFilters::configRuleName)).setter(setter(Builder::configRuleName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigRuleName").build()).build();

    private static final SdkField<String> COMPLIANCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ConfigRuleComplianceFilters::complianceTypeAsString)).setter(setter(Builder::complianceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComplianceType").build()).build();

    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ConfigRuleComplianceFilters::accountId)).setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountId").build()).build();

    private static final SdkField<String> AWS_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ConfigRuleComplianceFilters::awsRegion)).setter(setter(Builder::awsRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsRegion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIG_RULE_NAME_FIELD,
            COMPLIANCE_TYPE_FIELD, ACCOUNT_ID_FIELD, AWS_REGION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String configRuleName;

    private final String complianceType;

    private final String accountId;

    private final String awsRegion;

    private ConfigRuleComplianceFilters(BuilderImpl builder) {
        this.configRuleName = builder.configRuleName;
        this.complianceType = builder.complianceType;
        this.accountId = builder.accountId;
        this.awsRegion = builder.awsRegion;
    }

    /**
     * <p>
     * The name of the AWS Config rule.
     * </p>
     * 
     * @return The name of the AWS Config rule.
     */
    public String configRuleName() {
        return configRuleName;
    }

    /**
     * <p>
     * The rule compliance status.
     * </p>
     * <p>
     * For the <code>ConfigRuleComplianceFilters</code> data type, AWS Config supports only <code>COMPLIANT</code> and
     * <code>NON_COMPLIANT</code>. AWS Config does not support the <code>NOT_APPLICABLE</code> and the
     * <code>INSUFFICIENT_DATA</code> values.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #complianceType}
     * will return {@link ComplianceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #complianceTypeAsString}.
     * </p>
     * 
     * @return The rule compliance status.</p>
     *         <p>
     *         For the <code>ConfigRuleComplianceFilters</code> data type, AWS Config supports only
     *         <code>COMPLIANT</code> and <code>NON_COMPLIANT</code>. AWS Config does not support the
     *         <code>NOT_APPLICABLE</code> and the <code>INSUFFICIENT_DATA</code> values.
     * @see ComplianceType
     */
    public ComplianceType complianceType() {
        return ComplianceType.fromValue(complianceType);
    }

    /**
     * <p>
     * The rule compliance status.
     * </p>
     * <p>
     * For the <code>ConfigRuleComplianceFilters</code> data type, AWS Config supports only <code>COMPLIANT</code> and
     * <code>NON_COMPLIANT</code>. AWS Config does not support the <code>NOT_APPLICABLE</code> and the
     * <code>INSUFFICIENT_DATA</code> values.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #complianceType}
     * will return {@link ComplianceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #complianceTypeAsString}.
     * </p>
     * 
     * @return The rule compliance status.</p>
     *         <p>
     *         For the <code>ConfigRuleComplianceFilters</code> data type, AWS Config supports only
     *         <code>COMPLIANT</code> and <code>NON_COMPLIANT</code>. AWS Config does not support the
     *         <code>NOT_APPLICABLE</code> and the <code>INSUFFICIENT_DATA</code> values.
     * @see ComplianceType
     */
    public String complianceTypeAsString() {
        return complianceType;
    }

    /**
     * <p>
     * The 12-digit account ID of the source account.
     * </p>
     * 
     * @return The 12-digit account ID of the source account.
     */
    public String accountId() {
        return accountId;
    }

    /**
     * <p>
     * The source region where the data is aggregated.
     * </p>
     * 
     * @return The source region where the data is aggregated.
     */
    public String awsRegion() {
        return awsRegion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(configRuleName());
        hashCode = 31 * hashCode + Objects.hashCode(complianceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(awsRegion());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfigRuleComplianceFilters)) {
            return false;
        }
        ConfigRuleComplianceFilters other = (ConfigRuleComplianceFilters) obj;
        return Objects.equals(configRuleName(), other.configRuleName())
                && Objects.equals(complianceTypeAsString(), other.complianceTypeAsString())
                && Objects.equals(accountId(), other.accountId()) && Objects.equals(awsRegion(), other.awsRegion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ConfigRuleComplianceFilters").add("ConfigRuleName", configRuleName())
                .add("ComplianceType", complianceTypeAsString()).add("AccountId", accountId()).add("AwsRegion", awsRegion())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConfigRuleName":
            return Optional.ofNullable(clazz.cast(configRuleName()));
        case "ComplianceType":
            return Optional.ofNullable(clazz.cast(complianceTypeAsString()));
        case "AccountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "AwsRegion":
            return Optional.ofNullable(clazz.cast(awsRegion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConfigRuleComplianceFilters, T> g) {
        return obj -> g.apply((ConfigRuleComplianceFilters) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConfigRuleComplianceFilters> {
        /**
         * <p>
         * The name of the AWS Config rule.
         * </p>
         * 
         * @param configRuleName
         *        The name of the AWS Config rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configRuleName(String configRuleName);

        /**
         * <p>
         * The rule compliance status.
         * </p>
         * <p>
         * For the <code>ConfigRuleComplianceFilters</code> data type, AWS Config supports only <code>COMPLIANT</code>
         * and <code>NON_COMPLIANT</code>. AWS Config does not support the <code>NOT_APPLICABLE</code> and the
         * <code>INSUFFICIENT_DATA</code> values.
         * </p>
         * 
         * @param complianceType
         *        The rule compliance status.</p>
         *        <p>
         *        For the <code>ConfigRuleComplianceFilters</code> data type, AWS Config supports only
         *        <code>COMPLIANT</code> and <code>NON_COMPLIANT</code>. AWS Config does not support the
         *        <code>NOT_APPLICABLE</code> and the <code>INSUFFICIENT_DATA</code> values.
         * @see ComplianceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ComplianceType
         */
        Builder complianceType(String complianceType);

        /**
         * <p>
         * The rule compliance status.
         * </p>
         * <p>
         * For the <code>ConfigRuleComplianceFilters</code> data type, AWS Config supports only <code>COMPLIANT</code>
         * and <code>NON_COMPLIANT</code>. AWS Config does not support the <code>NOT_APPLICABLE</code> and the
         * <code>INSUFFICIENT_DATA</code> values.
         * </p>
         * 
         * @param complianceType
         *        The rule compliance status.</p>
         *        <p>
         *        For the <code>ConfigRuleComplianceFilters</code> data type, AWS Config supports only
         *        <code>COMPLIANT</code> and <code>NON_COMPLIANT</code>. AWS Config does not support the
         *        <code>NOT_APPLICABLE</code> and the <code>INSUFFICIENT_DATA</code> values.
         * @see ComplianceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ComplianceType
         */
        Builder complianceType(ComplianceType complianceType);

        /**
         * <p>
         * The 12-digit account ID of the source account.
         * </p>
         * 
         * @param accountId
         *        The 12-digit account ID of the source account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * The source region where the data is aggregated.
         * </p>
         * 
         * @param awsRegion
         *        The source region where the data is aggregated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsRegion(String awsRegion);
    }

    static final class BuilderImpl implements Builder {
        private String configRuleName;

        private String complianceType;

        private String accountId;

        private String awsRegion;

        private BuilderImpl() {
        }

        private BuilderImpl(ConfigRuleComplianceFilters model) {
            configRuleName(model.configRuleName);
            complianceType(model.complianceType);
            accountId(model.accountId);
            awsRegion(model.awsRegion);
        }

        public final String getConfigRuleName() {
            return configRuleName;
        }

        @Override
        public final Builder configRuleName(String configRuleName) {
            this.configRuleName = configRuleName;
            return this;
        }

        public final void setConfigRuleName(String configRuleName) {
            this.configRuleName = configRuleName;
        }

        public final String getComplianceTypeAsString() {
            return complianceType;
        }

        @Override
        public final Builder complianceType(String complianceType) {
            this.complianceType = complianceType;
            return this;
        }

        @Override
        public final Builder complianceType(ComplianceType complianceType) {
            this.complianceType(complianceType == null ? null : complianceType.toString());
            return this;
        }

        public final void setComplianceType(String complianceType) {
            this.complianceType = complianceType;
        }

        public final String getAccountId() {
            return accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        public final String getAwsRegion() {
            return awsRegion;
        }

        @Override
        public final Builder awsRegion(String awsRegion) {
            this.awsRegion = awsRegion;
            return this;
        }

        public final void setAwsRegion(String awsRegion) {
            this.awsRegion = awsRegion;
        }

        @Override
        public ConfigRuleComplianceFilters build() {
            return new ConfigRuleComplianceFilters(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
