/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutRemediationExceptionsResponse extends ConfigResponse implements
        ToCopyableBuilder<PutRemediationExceptionsResponse.Builder, PutRemediationExceptionsResponse> {
    private static final SdkField<List<FailedRemediationExceptionBatch>> FAILED_BATCHES_FIELD = SdkField
            .<List<FailedRemediationExceptionBatch>> builder(MarshallingType.LIST)
            .getter(getter(PutRemediationExceptionsResponse::failedBatches))
            .setter(setter(Builder::failedBatches))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailedBatches").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FailedRemediationExceptionBatch> builder(MarshallingType.SDK_POJO)
                                            .constructor(FailedRemediationExceptionBatch::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FAILED_BATCHES_FIELD));

    private final List<FailedRemediationExceptionBatch> failedBatches;

    private PutRemediationExceptionsResponse(BuilderImpl builder) {
        super(builder);
        this.failedBatches = builder.failedBatches;
    }

    /**
     * Returns true if the FailedBatches property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasFailedBatches() {
        return failedBatches != null && !(failedBatches instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Returns a list of failed remediation exceptions batch objects. Each object in the batch consists of a list of
     * failed items and failure messages.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasFailedBatches()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Returns a list of failed remediation exceptions batch objects. Each object in the batch consists of a
     *         list of failed items and failure messages.
     */
    public List<FailedRemediationExceptionBatch> failedBatches() {
        return failedBatches;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(failedBatches());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutRemediationExceptionsResponse)) {
            return false;
        }
        PutRemediationExceptionsResponse other = (PutRemediationExceptionsResponse) obj;
        return Objects.equals(failedBatches(), other.failedBatches());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("PutRemediationExceptionsResponse").add("FailedBatches", failedBatches()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FailedBatches":
            return Optional.ofNullable(clazz.cast(failedBatches()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutRemediationExceptionsResponse, T> g) {
        return obj -> g.apply((PutRemediationExceptionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConfigResponse.Builder, SdkPojo, CopyableBuilder<Builder, PutRemediationExceptionsResponse> {
        /**
         * <p>
         * Returns a list of failed remediation exceptions batch objects. Each object in the batch consists of a list of
         * failed items and failure messages.
         * </p>
         * 
         * @param failedBatches
         *        Returns a list of failed remediation exceptions batch objects. Each object in the batch consists of a
         *        list of failed items and failure messages.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failedBatches(Collection<FailedRemediationExceptionBatch> failedBatches);

        /**
         * <p>
         * Returns a list of failed remediation exceptions batch objects. Each object in the batch consists of a list of
         * failed items and failure messages.
         * </p>
         * 
         * @param failedBatches
         *        Returns a list of failed remediation exceptions batch objects. Each object in the batch consists of a
         *        list of failed items and failure messages.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failedBatches(FailedRemediationExceptionBatch... failedBatches);

        /**
         * <p>
         * Returns a list of failed remediation exceptions batch objects. Each object in the batch consists of a list of
         * failed items and failure messages.
         * </p>
         * This is a convenience that creates an instance of the {@link List<FailedRemediationExceptionBatch>.Builder}
         * avoiding the need to create one manually via {@link List<FailedRemediationExceptionBatch>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<FailedRemediationExceptionBatch>.Builder#build()} is called
         * immediately and its result is passed to {@link #failedBatches(List<FailedRemediationExceptionBatch>)}.
         * 
         * @param failedBatches
         *        a consumer that will call methods on {@link List<FailedRemediationExceptionBatch>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #failedBatches(List<FailedRemediationExceptionBatch>)
         */
        Builder failedBatches(Consumer<FailedRemediationExceptionBatch.Builder>... failedBatches);
    }

    static final class BuilderImpl extends ConfigResponse.BuilderImpl implements Builder {
        private List<FailedRemediationExceptionBatch> failedBatches = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PutRemediationExceptionsResponse model) {
            super(model);
            failedBatches(model.failedBatches);
        }

        public final Collection<FailedRemediationExceptionBatch.Builder> getFailedBatches() {
            return failedBatches != null ? failedBatches.stream().map(FailedRemediationExceptionBatch::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder failedBatches(Collection<FailedRemediationExceptionBatch> failedBatches) {
            this.failedBatches = FailedRemediationExceptionBatchesCopier.copy(failedBatches);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failedBatches(FailedRemediationExceptionBatch... failedBatches) {
            failedBatches(Arrays.asList(failedBatches));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failedBatches(Consumer<FailedRemediationExceptionBatch.Builder>... failedBatches) {
            failedBatches(Stream.of(failedBatches).map(c -> FailedRemediationExceptionBatch.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setFailedBatches(Collection<FailedRemediationExceptionBatch.BuilderImpl> failedBatches) {
            this.failedBatches = FailedRemediationExceptionBatchesCopier.copyFromBuilder(failedBatches);
        }

        @Override
        public PutRemediationExceptionsResponse build() {
            return new PutRemediationExceptionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
