/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetAggregateDiscoveredResourceCountsResponse extends ConfigResponse implements
        ToCopyableBuilder<GetAggregateDiscoveredResourceCountsResponse.Builder, GetAggregateDiscoveredResourceCountsResponse> {
    private static final SdkField<Long> TOTAL_DISCOVERED_RESOURCES_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(GetAggregateDiscoveredResourceCountsResponse::totalDiscoveredResources))
            .setter(setter(Builder::totalDiscoveredResources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalDiscoveredResources").build())
            .build();

    private static final SdkField<String> GROUP_BY_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetAggregateDiscoveredResourceCountsResponse::groupByKey)).setter(setter(Builder::groupByKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupByKey").build()).build();

    private static final SdkField<List<GroupedResourceCount>> GROUPED_RESOURCE_COUNTS_FIELD = SdkField
            .<List<GroupedResourceCount>> builder(MarshallingType.LIST)
            .getter(getter(GetAggregateDiscoveredResourceCountsResponse::groupedResourceCounts))
            .setter(setter(Builder::groupedResourceCounts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupedResourceCounts").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<GroupedResourceCount> builder(MarshallingType.SDK_POJO)
                                            .constructor(GroupedResourceCount::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetAggregateDiscoveredResourceCountsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            TOTAL_DISCOVERED_RESOURCES_FIELD, GROUP_BY_KEY_FIELD, GROUPED_RESOURCE_COUNTS_FIELD, NEXT_TOKEN_FIELD));

    private final Long totalDiscoveredResources;

    private final String groupByKey;

    private final List<GroupedResourceCount> groupedResourceCounts;

    private final String nextToken;

    private GetAggregateDiscoveredResourceCountsResponse(BuilderImpl builder) {
        super(builder);
        this.totalDiscoveredResources = builder.totalDiscoveredResources;
        this.groupByKey = builder.groupByKey;
        this.groupedResourceCounts = builder.groupedResourceCounts;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The total number of resources that are present in an aggregator with the filters that you provide.
     * </p>
     * 
     * @return The total number of resources that are present in an aggregator with the filters that you provide.
     */
    public Long totalDiscoveredResources() {
        return totalDiscoveredResources;
    }

    /**
     * <p>
     * The key passed into the request object. If <code>GroupByKey</code> is not provided, the result will be empty.
     * </p>
     * 
     * @return The key passed into the request object. If <code>GroupByKey</code> is not provided, the result will be
     *         empty.
     */
    public String groupByKey() {
        return groupByKey;
    }

    /**
     * Returns true if the GroupedResourceCounts property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasGroupedResourceCounts() {
        return groupedResourceCounts != null && !(groupedResourceCounts instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Returns a list of GroupedResourceCount objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasGroupedResourceCounts()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Returns a list of GroupedResourceCount objects.
     */
    public List<GroupedResourceCount> groupedResourceCounts() {
        return groupedResourceCounts;
    }

    /**
     * <p>
     * The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a
     * paginated response.
     * </p>
     * 
     * @return The <code>nextToken</code> string returned on a previous page that you use to get the next page of
     *         results in a paginated response.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(totalDiscoveredResources());
        hashCode = 31 * hashCode + Objects.hashCode(groupByKey());
        hashCode = 31 * hashCode + Objects.hashCode(groupedResourceCounts());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAggregateDiscoveredResourceCountsResponse)) {
            return false;
        }
        GetAggregateDiscoveredResourceCountsResponse other = (GetAggregateDiscoveredResourceCountsResponse) obj;
        return Objects.equals(totalDiscoveredResources(), other.totalDiscoveredResources())
                && Objects.equals(groupByKey(), other.groupByKey())
                && Objects.equals(groupedResourceCounts(), other.groupedResourceCounts())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetAggregateDiscoveredResourceCountsResponse")
                .add("TotalDiscoveredResources", totalDiscoveredResources()).add("GroupByKey", groupByKey())
                .add("GroupedResourceCounts", groupedResourceCounts()).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TotalDiscoveredResources":
            return Optional.ofNullable(clazz.cast(totalDiscoveredResources()));
        case "GroupByKey":
            return Optional.ofNullable(clazz.cast(groupByKey()));
        case "GroupedResourceCounts":
            return Optional.ofNullable(clazz.cast(groupedResourceCounts()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetAggregateDiscoveredResourceCountsResponse, T> g) {
        return obj -> g.apply((GetAggregateDiscoveredResourceCountsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConfigResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetAggregateDiscoveredResourceCountsResponse> {
        /**
         * <p>
         * The total number of resources that are present in an aggregator with the filters that you provide.
         * </p>
         * 
         * @param totalDiscoveredResources
         *        The total number of resources that are present in an aggregator with the filters that you provide.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalDiscoveredResources(Long totalDiscoveredResources);

        /**
         * <p>
         * The key passed into the request object. If <code>GroupByKey</code> is not provided, the result will be empty.
         * </p>
         * 
         * @param groupByKey
         *        The key passed into the request object. If <code>GroupByKey</code> is not provided, the result will be
         *        empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupByKey(String groupByKey);

        /**
         * <p>
         * Returns a list of GroupedResourceCount objects.
         * </p>
         * 
         * @param groupedResourceCounts
         *        Returns a list of GroupedResourceCount objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupedResourceCounts(Collection<GroupedResourceCount> groupedResourceCounts);

        /**
         * <p>
         * Returns a list of GroupedResourceCount objects.
         * </p>
         * 
         * @param groupedResourceCounts
         *        Returns a list of GroupedResourceCount objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupedResourceCounts(GroupedResourceCount... groupedResourceCounts);

        /**
         * <p>
         * Returns a list of GroupedResourceCount objects.
         * </p>
         * This is a convenience that creates an instance of the {@link List<GroupedResourceCount>.Builder} avoiding the
         * need to create one manually via {@link List<GroupedResourceCount>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<GroupedResourceCount>.Builder#build()} is called immediately
         * and its result is passed to {@link #groupedResourceCounts(List<GroupedResourceCount>)}.
         * 
         * @param groupedResourceCounts
         *        a consumer that will call methods on {@link List<GroupedResourceCount>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #groupedResourceCounts(List<GroupedResourceCount>)
         */
        Builder groupedResourceCounts(Consumer<GroupedResourceCount.Builder>... groupedResourceCounts);

        /**
         * <p>
         * The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in
         * a paginated response.
         * </p>
         * 
         * @param nextToken
         *        The <code>nextToken</code> string returned on a previous page that you use to get the next page of
         *        results in a paginated response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ConfigResponse.BuilderImpl implements Builder {
        private Long totalDiscoveredResources;

        private String groupByKey;

        private List<GroupedResourceCount> groupedResourceCounts = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAggregateDiscoveredResourceCountsResponse model) {
            super(model);
            totalDiscoveredResources(model.totalDiscoveredResources);
            groupByKey(model.groupByKey);
            groupedResourceCounts(model.groupedResourceCounts);
            nextToken(model.nextToken);
        }

        public final Long getTotalDiscoveredResources() {
            return totalDiscoveredResources;
        }

        @Override
        public final Builder totalDiscoveredResources(Long totalDiscoveredResources) {
            this.totalDiscoveredResources = totalDiscoveredResources;
            return this;
        }

        public final void setTotalDiscoveredResources(Long totalDiscoveredResources) {
            this.totalDiscoveredResources = totalDiscoveredResources;
        }

        public final String getGroupByKey() {
            return groupByKey;
        }

        @Override
        public final Builder groupByKey(String groupByKey) {
            this.groupByKey = groupByKey;
            return this;
        }

        public final void setGroupByKey(String groupByKey) {
            this.groupByKey = groupByKey;
        }

        public final Collection<GroupedResourceCount.Builder> getGroupedResourceCounts() {
            return groupedResourceCounts != null ? groupedResourceCounts.stream().map(GroupedResourceCount::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder groupedResourceCounts(Collection<GroupedResourceCount> groupedResourceCounts) {
            this.groupedResourceCounts = GroupedResourceCountListCopier.copy(groupedResourceCounts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupedResourceCounts(GroupedResourceCount... groupedResourceCounts) {
            groupedResourceCounts(Arrays.asList(groupedResourceCounts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupedResourceCounts(Consumer<GroupedResourceCount.Builder>... groupedResourceCounts) {
            groupedResourceCounts(Stream.of(groupedResourceCounts)
                    .map(c -> GroupedResourceCount.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setGroupedResourceCounts(Collection<GroupedResourceCount.BuilderImpl> groupedResourceCounts) {
            this.groupedResourceCounts = GroupedResourceCountListCopier.copyFromBuilder(groupedResourceCounts);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public GetAggregateDiscoveredResourceCountsResponse build() {
            return new GetAggregateDiscoveredResourceCountsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
