/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Summary includes the name and status of the conformance pack.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConformancePackComplianceSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<ConformancePackComplianceSummary.Builder, ConformancePackComplianceSummary> {
    private static final SdkField<String> CONFORMANCE_PACK_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ConformancePackComplianceSummary::conformancePackName)).setter(setter(Builder::conformancePackName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConformancePackName").build())
            .build();

    private static final SdkField<String> CONFORMANCE_PACK_COMPLIANCE_STATUS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(ConformancePackComplianceSummary::conformancePackComplianceStatusAsString))
            .setter(setter(Builder::conformancePackComplianceStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConformancePackComplianceStatus")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFORMANCE_PACK_NAME_FIELD,
            CONFORMANCE_PACK_COMPLIANCE_STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String conformancePackName;

    private final String conformancePackComplianceStatus;

    private ConformancePackComplianceSummary(BuilderImpl builder) {
        this.conformancePackName = builder.conformancePackName;
        this.conformancePackComplianceStatus = builder.conformancePackComplianceStatus;
    }

    /**
     * <p>
     * The name of the conformance pack name.
     * </p>
     * 
     * @return The name of the conformance pack name.
     */
    public String conformancePackName() {
        return conformancePackName;
    }

    /**
     * <p>
     * The status of the conformance pack. The allowed values are COMPLIANT and NON_COMPLIANT.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #conformancePackComplianceStatus} will return {@link ConformancePackComplianceType#UNKNOWN_TO_SDK_VERSION}
     * . The raw value returned by the service is available from {@link #conformancePackComplianceStatusAsString}.
     * </p>
     * 
     * @return The status of the conformance pack. The allowed values are COMPLIANT and NON_COMPLIANT.
     * @see ConformancePackComplianceType
     */
    public ConformancePackComplianceType conformancePackComplianceStatus() {
        return ConformancePackComplianceType.fromValue(conformancePackComplianceStatus);
    }

    /**
     * <p>
     * The status of the conformance pack. The allowed values are COMPLIANT and NON_COMPLIANT.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #conformancePackComplianceStatus} will return {@link ConformancePackComplianceType#UNKNOWN_TO_SDK_VERSION}
     * . The raw value returned by the service is available from {@link #conformancePackComplianceStatusAsString}.
     * </p>
     * 
     * @return The status of the conformance pack. The allowed values are COMPLIANT and NON_COMPLIANT.
     * @see ConformancePackComplianceType
     */
    public String conformancePackComplianceStatusAsString() {
        return conformancePackComplianceStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(conformancePackName());
        hashCode = 31 * hashCode + Objects.hashCode(conformancePackComplianceStatusAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConformancePackComplianceSummary)) {
            return false;
        }
        ConformancePackComplianceSummary other = (ConformancePackComplianceSummary) obj;
        return Objects.equals(conformancePackName(), other.conformancePackName())
                && Objects.equals(conformancePackComplianceStatusAsString(), other.conformancePackComplianceStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ConformancePackComplianceSummary").add("ConformancePackName", conformancePackName())
                .add("ConformancePackComplianceStatus", conformancePackComplianceStatusAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConformancePackName":
            return Optional.ofNullable(clazz.cast(conformancePackName()));
        case "ConformancePackComplianceStatus":
            return Optional.ofNullable(clazz.cast(conformancePackComplianceStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConformancePackComplianceSummary, T> g) {
        return obj -> g.apply((ConformancePackComplianceSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConformancePackComplianceSummary> {
        /**
         * <p>
         * The name of the conformance pack name.
         * </p>
         * 
         * @param conformancePackName
         *        The name of the conformance pack name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conformancePackName(String conformancePackName);

        /**
         * <p>
         * The status of the conformance pack. The allowed values are COMPLIANT and NON_COMPLIANT.
         * </p>
         * 
         * @param conformancePackComplianceStatus
         *        The status of the conformance pack. The allowed values are COMPLIANT and NON_COMPLIANT.
         * @see ConformancePackComplianceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConformancePackComplianceType
         */
        Builder conformancePackComplianceStatus(String conformancePackComplianceStatus);

        /**
         * <p>
         * The status of the conformance pack. The allowed values are COMPLIANT and NON_COMPLIANT.
         * </p>
         * 
         * @param conformancePackComplianceStatus
         *        The status of the conformance pack. The allowed values are COMPLIANT and NON_COMPLIANT.
         * @see ConformancePackComplianceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConformancePackComplianceType
         */
        Builder conformancePackComplianceStatus(ConformancePackComplianceType conformancePackComplianceStatus);
    }

    static final class BuilderImpl implements Builder {
        private String conformancePackName;

        private String conformancePackComplianceStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(ConformancePackComplianceSummary model) {
            conformancePackName(model.conformancePackName);
            conformancePackComplianceStatus(model.conformancePackComplianceStatus);
        }

        public final String getConformancePackName() {
            return conformancePackName;
        }

        @Override
        public final Builder conformancePackName(String conformancePackName) {
            this.conformancePackName = conformancePackName;
            return this;
        }

        public final void setConformancePackName(String conformancePackName) {
            this.conformancePackName = conformancePackName;
        }

        public final String getConformancePackComplianceStatus() {
            return conformancePackComplianceStatus;
        }

        @Override
        public final Builder conformancePackComplianceStatus(String conformancePackComplianceStatus) {
            this.conformancePackComplianceStatus = conformancePackComplianceStatus;
            return this;
        }

        @Override
        public final Builder conformancePackComplianceStatus(ConformancePackComplianceType conformancePackComplianceStatus) {
            this.conformancePackComplianceStatus(conformancePackComplianceStatus == null ? null : conformancePackComplianceStatus
                    .toString());
            return this;
        }

        public final void setConformancePackComplianceStatus(String conformancePackComplianceStatus) {
            this.conformancePackComplianceStatus = conformancePackComplianceStatus;
        }

        @Override
        public ConformancePackComplianceSummary build() {
            return new ConformancePackComplianceSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
