/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The details that identify a resource within AWS Config, including the resource type and resource ID.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RemediationExceptionResourceKey implements SdkPojo, Serializable,
        ToCopyableBuilder<RemediationExceptionResourceKey.Builder, RemediationExceptionResourceKey> {
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RemediationExceptionResourceKey::resourceType)).setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()).build();

    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RemediationExceptionResourceKey::resourceId)).setter(setter(Builder::resourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_TYPE_FIELD,
            RESOURCE_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String resourceType;

    private final String resourceId;

    private RemediationExceptionResourceKey(BuilderImpl builder) {
        this.resourceType = builder.resourceType;
        this.resourceId = builder.resourceId;
    }

    /**
     * <p>
     * The type of a resource.
     * </p>
     * 
     * @return The type of a resource.
     */
    public String resourceType() {
        return resourceType;
    }

    /**
     * <p>
     * The ID of the resource (for example., sg-xxxxxx).
     * </p>
     * 
     * @return The ID of the resource (for example., sg-xxxxxx).
     */
    public String resourceId() {
        return resourceId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(resourceType());
        hashCode = 31 * hashCode + Objects.hashCode(resourceId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RemediationExceptionResourceKey)) {
            return false;
        }
        RemediationExceptionResourceKey other = (RemediationExceptionResourceKey) obj;
        return Objects.equals(resourceType(), other.resourceType()) && Objects.equals(resourceId(), other.resourceId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("RemediationExceptionResourceKey").add("ResourceType", resourceType())
                .add("ResourceId", resourceId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceType":
            return Optional.ofNullable(clazz.cast(resourceType()));
        case "ResourceId":
            return Optional.ofNullable(clazz.cast(resourceId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RemediationExceptionResourceKey, T> g) {
        return obj -> g.apply((RemediationExceptionResourceKey) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RemediationExceptionResourceKey> {
        /**
         * <p>
         * The type of a resource.
         * </p>
         * 
         * @param resourceType
         *        The type of a resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * The ID of the resource (for example., sg-xxxxxx).
         * </p>
         * 
         * @param resourceId
         *        The ID of the resource (for example., sg-xxxxxx).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceId(String resourceId);
    }

    static final class BuilderImpl implements Builder {
        private String resourceType;

        private String resourceId;

        private BuilderImpl() {
        }

        private BuilderImpl(RemediationExceptionResourceKey model) {
            resourceType(model.resourceType);
            resourceId(model.resourceId);
        }

        public final String getResourceType() {
            return resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public final String getResourceId() {
            return resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        @Override
        public RemediationExceptionResourceKey build() {
            return new RemediationExceptionResourceKey(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
