/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.config.model.ConfigResponse;
import software.amazon.awssdk.services.config.model.OrganizationConfigRuleStatus;
import software.amazon.awssdk.services.config.model.OrganizationConfigRuleStatusesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeOrganizationConfigRuleStatusesResponse
extends ConfigResponse
implements ToCopyableBuilder<Builder, DescribeOrganizationConfigRuleStatusesResponse> {
    private static final SdkField<List<OrganizationConfigRuleStatus>> ORGANIZATION_CONFIG_RULE_STATUSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeOrganizationConfigRuleStatusesResponse.getter(DescribeOrganizationConfigRuleStatusesResponse::organizationConfigRuleStatuses)).setter(DescribeOrganizationConfigRuleStatusesResponse.setter(Builder::organizationConfigRuleStatuses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationConfigRuleStatuses").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(OrganizationConfigRuleStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeOrganizationConfigRuleStatusesResponse.getter(DescribeOrganizationConfigRuleStatusesResponse::nextToken)).setter(DescribeOrganizationConfigRuleStatusesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ORGANIZATION_CONFIG_RULE_STATUSES_FIELD, NEXT_TOKEN_FIELD));
    private final List<OrganizationConfigRuleStatus> organizationConfigRuleStatuses;
    private final String nextToken;

    private DescribeOrganizationConfigRuleStatusesResponse(BuilderImpl builder) {
        super(builder);
        this.organizationConfigRuleStatuses = builder.organizationConfigRuleStatuses;
        this.nextToken = builder.nextToken;
    }

    public boolean hasOrganizationConfigRuleStatuses() {
        return this.organizationConfigRuleStatuses != null && !(this.organizationConfigRuleStatuses instanceof SdkAutoConstructList);
    }

    public List<OrganizationConfigRuleStatus> organizationConfigRuleStatuses() {
        return this.organizationConfigRuleStatuses;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.organizationConfigRuleStatuses());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeOrganizationConfigRuleStatusesResponse)) {
            return false;
        }
        DescribeOrganizationConfigRuleStatusesResponse other = (DescribeOrganizationConfigRuleStatusesResponse)((Object)obj);
        return Objects.equals(this.organizationConfigRuleStatuses(), other.organizationConfigRuleStatuses()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeOrganizationConfigRuleStatusesResponse").add("OrganizationConfigRuleStatuses", this.organizationConfigRuleStatuses()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OrganizationConfigRuleStatuses": {
                return Optional.ofNullable(clazz.cast(this.organizationConfigRuleStatuses()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeOrganizationConfigRuleStatusesResponse, T> g) {
        return obj -> g.apply((DescribeOrganizationConfigRuleStatusesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConfigResponse.BuilderImpl
    implements Builder {
        private List<OrganizationConfigRuleStatus> organizationConfigRuleStatuses = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeOrganizationConfigRuleStatusesResponse model) {
            super(model);
            this.organizationConfigRuleStatuses(model.organizationConfigRuleStatuses);
            this.nextToken(model.nextToken);
        }

        public final Collection<OrganizationConfigRuleStatus.Builder> getOrganizationConfigRuleStatuses() {
            return this.organizationConfigRuleStatuses != null ? (Collection)this.organizationConfigRuleStatuses.stream().map(OrganizationConfigRuleStatus::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder organizationConfigRuleStatuses(Collection<OrganizationConfigRuleStatus> organizationConfigRuleStatuses) {
            this.organizationConfigRuleStatuses = OrganizationConfigRuleStatusesCopier.copy(organizationConfigRuleStatuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder organizationConfigRuleStatuses(OrganizationConfigRuleStatus ... organizationConfigRuleStatuses) {
            this.organizationConfigRuleStatuses(Arrays.asList(organizationConfigRuleStatuses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder organizationConfigRuleStatuses(Consumer<OrganizationConfigRuleStatus.Builder> ... organizationConfigRuleStatuses) {
            this.organizationConfigRuleStatuses(Stream.of(organizationConfigRuleStatuses).map(c -> (OrganizationConfigRuleStatus)((OrganizationConfigRuleStatus.Builder)OrganizationConfigRuleStatus.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setOrganizationConfigRuleStatuses(Collection<OrganizationConfigRuleStatus.BuilderImpl> organizationConfigRuleStatuses) {
            this.organizationConfigRuleStatuses = OrganizationConfigRuleStatusesCopier.copyFromBuilder(organizationConfigRuleStatuses);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeOrganizationConfigRuleStatusesResponse build() {
            return new DescribeOrganizationConfigRuleStatusesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ConfigResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeOrganizationConfigRuleStatusesResponse> {
        public Builder organizationConfigRuleStatuses(Collection<OrganizationConfigRuleStatus> var1);

        public Builder organizationConfigRuleStatuses(OrganizationConfigRuleStatus ... var1);

        public Builder organizationConfigRuleStatuses(Consumer<OrganizationConfigRuleStatus.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

