/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The detailed configuration of a specified resource.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BaseConfigurationItem implements SdkPojo, Serializable,
        ToCopyableBuilder<BaseConfigurationItem.Builder, BaseConfigurationItem> {
    private static final SdkField<String> VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(BaseConfigurationItem::version)).setter(setter(Builder::version))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()).build();

    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(BaseConfigurationItem::accountId)).setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountId").build()).build();

    private static final SdkField<Instant> CONFIGURATION_ITEM_CAPTURE_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(BaseConfigurationItem::configurationItemCaptureTime))
            .setter(setter(Builder::configurationItemCaptureTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configurationItemCaptureTime")
                    .build()).build();

    private static final SdkField<String> CONFIGURATION_ITEM_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(BaseConfigurationItem::configurationItemStatusAsString))
            .setter(setter(Builder::configurationItemStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configurationItemStatus").build())
            .build();

    private static final SdkField<String> CONFIGURATION_STATE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(BaseConfigurationItem::configurationStateId)).setter(setter(Builder::configurationStateId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configurationStateId").build())
            .build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(BaseConfigurationItem::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(BaseConfigurationItem::resourceTypeAsString)).setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceType").build()).build();

    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(BaseConfigurationItem::resourceId)).setter(setter(Builder::resourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceId").build()).build();

    private static final SdkField<String> RESOURCE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(BaseConfigurationItem::resourceName)).setter(setter(Builder::resourceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceName").build()).build();

    private static final SdkField<String> AWS_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(BaseConfigurationItem::awsRegion)).setter(setter(Builder::awsRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsRegion").build()).build();

    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(BaseConfigurationItem::availabilityZone)).setter(setter(Builder::availabilityZone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("availabilityZone").build()).build();

    private static final SdkField<Instant> RESOURCE_CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(BaseConfigurationItem::resourceCreationTime)).setter(setter(Builder::resourceCreationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceCreationTime").build())
            .build();

    private static final SdkField<String> CONFIGURATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(BaseConfigurationItem::configuration)).setter(setter(Builder::configuration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuration").build()).build();

    private static final SdkField<Map<String, String>> SUPPLEMENTARY_CONFIGURATION_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(BaseConfigurationItem::supplementaryConfiguration))
            .setter(setter(Builder::supplementaryConfiguration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("supplementaryConfiguration").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VERSION_FIELD,
            ACCOUNT_ID_FIELD, CONFIGURATION_ITEM_CAPTURE_TIME_FIELD, CONFIGURATION_ITEM_STATUS_FIELD,
            CONFIGURATION_STATE_ID_FIELD, ARN_FIELD, RESOURCE_TYPE_FIELD, RESOURCE_ID_FIELD, RESOURCE_NAME_FIELD,
            AWS_REGION_FIELD, AVAILABILITY_ZONE_FIELD, RESOURCE_CREATION_TIME_FIELD, CONFIGURATION_FIELD,
            SUPPLEMENTARY_CONFIGURATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String version;

    private final String accountId;

    private final Instant configurationItemCaptureTime;

    private final String configurationItemStatus;

    private final String configurationStateId;

    private final String arn;

    private final String resourceType;

    private final String resourceId;

    private final String resourceName;

    private final String awsRegion;

    private final String availabilityZone;

    private final Instant resourceCreationTime;

    private final String configuration;

    private final Map<String, String> supplementaryConfiguration;

    private BaseConfigurationItem(BuilderImpl builder) {
        this.version = builder.version;
        this.accountId = builder.accountId;
        this.configurationItemCaptureTime = builder.configurationItemCaptureTime;
        this.configurationItemStatus = builder.configurationItemStatus;
        this.configurationStateId = builder.configurationStateId;
        this.arn = builder.arn;
        this.resourceType = builder.resourceType;
        this.resourceId = builder.resourceId;
        this.resourceName = builder.resourceName;
        this.awsRegion = builder.awsRegion;
        this.availabilityZone = builder.availabilityZone;
        this.resourceCreationTime = builder.resourceCreationTime;
        this.configuration = builder.configuration;
        this.supplementaryConfiguration = builder.supplementaryConfiguration;
    }

    /**
     * <p>
     * The version number of the resource configuration.
     * </p>
     * 
     * @return The version number of the resource configuration.
     */
    public String version() {
        return version;
    }

    /**
     * <p>
     * The 12-digit AWS account ID associated with the resource.
     * </p>
     * 
     * @return The 12-digit AWS account ID associated with the resource.
     */
    public String accountId() {
        return accountId;
    }

    /**
     * <p>
     * The time when the configuration recording was initiated.
     * </p>
     * 
     * @return The time when the configuration recording was initiated.
     */
    public Instant configurationItemCaptureTime() {
        return configurationItemCaptureTime;
    }

    /**
     * <p>
     * The configuration item status. The valid values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * OK – The resource configuration has been updated
     * </p>
     * </li>
     * <li>
     * <p>
     * ResourceDiscovered – The resource was newly discovered
     * </p>
     * </li>
     * <li>
     * <p>
     * ResourceNotRecorded – The resource was discovered but its configuration was not recorded since the recorder
     * excludes the recording of resources of this type
     * </p>
     * </li>
     * <li>
     * <p>
     * ResourceDeleted – The resource was deleted
     * </p>
     * </li>
     * <li>
     * <p>
     * ResourceDeletedNotRecorded – The resource was deleted but its configuration was not recorded since the recorder
     * excludes the recording of resources of this type
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * The CIs do not incur any cost.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #configurationItemStatus} will return {@link ConfigurationItemStatus#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #configurationItemStatusAsString}.
     * </p>
     * 
     * @return The configuration item status. The valid values are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         OK – The resource configuration has been updated
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ResourceDiscovered – The resource was newly discovered
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ResourceNotRecorded – The resource was discovered but its configuration was not recorded since the
     *         recorder excludes the recording of resources of this type
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ResourceDeleted – The resource was deleted
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ResourceDeletedNotRecorded – The resource was deleted but its configuration was not recorded since the
     *         recorder excludes the recording of resources of this type
     *         </p>
     *         </li>
     *         </ul>
     *         <note>
     *         <p>
     *         The CIs do not incur any cost.
     *         </p>
     * @see ConfigurationItemStatus
     */
    public ConfigurationItemStatus configurationItemStatus() {
        return ConfigurationItemStatus.fromValue(configurationItemStatus);
    }

    /**
     * <p>
     * The configuration item status. The valid values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * OK – The resource configuration has been updated
     * </p>
     * </li>
     * <li>
     * <p>
     * ResourceDiscovered – The resource was newly discovered
     * </p>
     * </li>
     * <li>
     * <p>
     * ResourceNotRecorded – The resource was discovered but its configuration was not recorded since the recorder
     * excludes the recording of resources of this type
     * </p>
     * </li>
     * <li>
     * <p>
     * ResourceDeleted – The resource was deleted
     * </p>
     * </li>
     * <li>
     * <p>
     * ResourceDeletedNotRecorded – The resource was deleted but its configuration was not recorded since the recorder
     * excludes the recording of resources of this type
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * The CIs do not incur any cost.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #configurationItemStatus} will return {@link ConfigurationItemStatus#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #configurationItemStatusAsString}.
     * </p>
     * 
     * @return The configuration item status. The valid values are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         OK – The resource configuration has been updated
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ResourceDiscovered – The resource was newly discovered
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ResourceNotRecorded – The resource was discovered but its configuration was not recorded since the
     *         recorder excludes the recording of resources of this type
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ResourceDeleted – The resource was deleted
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ResourceDeletedNotRecorded – The resource was deleted but its configuration was not recorded since the
     *         recorder excludes the recording of resources of this type
     *         </p>
     *         </li>
     *         </ul>
     *         <note>
     *         <p>
     *         The CIs do not incur any cost.
     *         </p>
     * @see ConfigurationItemStatus
     */
    public String configurationItemStatusAsString() {
        return configurationItemStatus;
    }

    /**
     * <p>
     * An identifier that indicates the ordering of the configuration items of a resource.
     * </p>
     * 
     * @return An identifier that indicates the ordering of the configuration items of a resource.
     */
    public String configurationStateId() {
        return configurationStateId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the resource.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the resource.
     */
    public String arn() {
        return arn;
    }

    /**
     * <p>
     * The type of AWS resource.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link ResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return The type of AWS resource.
     * @see ResourceType
     */
    public ResourceType resourceType() {
        return ResourceType.fromValue(resourceType);
    }

    /**
     * <p>
     * The type of AWS resource.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link ResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return The type of AWS resource.
     * @see ResourceType
     */
    public String resourceTypeAsString() {
        return resourceType;
    }

    /**
     * <p>
     * The ID of the resource (for example., sg-xxxxxx).
     * </p>
     * 
     * @return The ID of the resource (for example., sg-xxxxxx).
     */
    public String resourceId() {
        return resourceId;
    }

    /**
     * <p>
     * The custom name of the resource, if available.
     * </p>
     * 
     * @return The custom name of the resource, if available.
     */
    public String resourceName() {
        return resourceName;
    }

    /**
     * <p>
     * The region where the resource resides.
     * </p>
     * 
     * @return The region where the resource resides.
     */
    public String awsRegion() {
        return awsRegion;
    }

    /**
     * <p>
     * The Availability Zone associated with the resource.
     * </p>
     * 
     * @return The Availability Zone associated with the resource.
     */
    public String availabilityZone() {
        return availabilityZone;
    }

    /**
     * <p>
     * The time stamp when the resource was created.
     * </p>
     * 
     * @return The time stamp when the resource was created.
     */
    public Instant resourceCreationTime() {
        return resourceCreationTime;
    }

    /**
     * <p>
     * The description of the resource configuration.
     * </p>
     * 
     * @return The description of the resource configuration.
     */
    public String configuration() {
        return configuration;
    }

    /**
     * Returns true if the SupplementaryConfiguration property was specified by the sender (it may be empty), or false
     * if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the
     * AWS service.
     */
    public boolean hasSupplementaryConfiguration() {
        return supplementaryConfiguration != null && !(supplementaryConfiguration instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Configuration attributes that AWS Config returns for certain resource types to supplement the information
     * returned for the configuration parameter.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSupplementaryConfiguration()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Configuration attributes that AWS Config returns for certain resource types to supplement the information
     *         returned for the configuration parameter.
     */
    public Map<String, String> supplementaryConfiguration() {
        return supplementaryConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(version());
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(configurationItemCaptureTime());
        hashCode = 31 * hashCode + Objects.hashCode(configurationItemStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(configurationStateId());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(resourceName());
        hashCode = 31 * hashCode + Objects.hashCode(awsRegion());
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(resourceCreationTime());
        hashCode = 31 * hashCode + Objects.hashCode(configuration());
        hashCode = 31 * hashCode + Objects.hashCode(supplementaryConfiguration());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BaseConfigurationItem)) {
            return false;
        }
        BaseConfigurationItem other = (BaseConfigurationItem) obj;
        return Objects.equals(version(), other.version()) && Objects.equals(accountId(), other.accountId())
                && Objects.equals(configurationItemCaptureTime(), other.configurationItemCaptureTime())
                && Objects.equals(configurationItemStatusAsString(), other.configurationItemStatusAsString())
                && Objects.equals(configurationStateId(), other.configurationStateId()) && Objects.equals(arn(), other.arn())
                && Objects.equals(resourceTypeAsString(), other.resourceTypeAsString())
                && Objects.equals(resourceId(), other.resourceId()) && Objects.equals(resourceName(), other.resourceName())
                && Objects.equals(awsRegion(), other.awsRegion()) && Objects.equals(availabilityZone(), other.availabilityZone())
                && Objects.equals(resourceCreationTime(), other.resourceCreationTime())
                && Objects.equals(configuration(), other.configuration())
                && Objects.equals(supplementaryConfiguration(), other.supplementaryConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("BaseConfigurationItem").add("Version", version()).add("AccountId", accountId())
                .add("ConfigurationItemCaptureTime", configurationItemCaptureTime())
                .add("ConfigurationItemStatus", configurationItemStatusAsString())
                .add("ConfigurationStateId", configurationStateId()).add("Arn", arn())
                .add("ResourceType", resourceTypeAsString()).add("ResourceId", resourceId()).add("ResourceName", resourceName())
                .add("AwsRegion", awsRegion()).add("AvailabilityZone", availabilityZone())
                .add("ResourceCreationTime", resourceCreationTime()).add("Configuration", configuration())
                .add("SupplementaryConfiguration", supplementaryConfiguration()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "version":
            return Optional.ofNullable(clazz.cast(version()));
        case "accountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "configurationItemCaptureTime":
            return Optional.ofNullable(clazz.cast(configurationItemCaptureTime()));
        case "configurationItemStatus":
            return Optional.ofNullable(clazz.cast(configurationItemStatusAsString()));
        case "configurationStateId":
            return Optional.ofNullable(clazz.cast(configurationStateId()));
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "resourceType":
            return Optional.ofNullable(clazz.cast(resourceTypeAsString()));
        case "resourceId":
            return Optional.ofNullable(clazz.cast(resourceId()));
        case "resourceName":
            return Optional.ofNullable(clazz.cast(resourceName()));
        case "awsRegion":
            return Optional.ofNullable(clazz.cast(awsRegion()));
        case "availabilityZone":
            return Optional.ofNullable(clazz.cast(availabilityZone()));
        case "resourceCreationTime":
            return Optional.ofNullable(clazz.cast(resourceCreationTime()));
        case "configuration":
            return Optional.ofNullable(clazz.cast(configuration()));
        case "supplementaryConfiguration":
            return Optional.ofNullable(clazz.cast(supplementaryConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BaseConfigurationItem, T> g) {
        return obj -> g.apply((BaseConfigurationItem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BaseConfigurationItem> {
        /**
         * <p>
         * The version number of the resource configuration.
         * </p>
         * 
         * @param version
         *        The version number of the resource configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(String version);

        /**
         * <p>
         * The 12-digit AWS account ID associated with the resource.
         * </p>
         * 
         * @param accountId
         *        The 12-digit AWS account ID associated with the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * The time when the configuration recording was initiated.
         * </p>
         * 
         * @param configurationItemCaptureTime
         *        The time when the configuration recording was initiated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationItemCaptureTime(Instant configurationItemCaptureTime);

        /**
         * <p>
         * The configuration item status. The valid values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * OK – The resource configuration has been updated
         * </p>
         * </li>
         * <li>
         * <p>
         * ResourceDiscovered – The resource was newly discovered
         * </p>
         * </li>
         * <li>
         * <p>
         * ResourceNotRecorded – The resource was discovered but its configuration was not recorded since the recorder
         * excludes the recording of resources of this type
         * </p>
         * </li>
         * <li>
         * <p>
         * ResourceDeleted – The resource was deleted
         * </p>
         * </li>
         * <li>
         * <p>
         * ResourceDeletedNotRecorded – The resource was deleted but its configuration was not recorded since the
         * recorder excludes the recording of resources of this type
         * </p>
         * </li>
         * </ul>
         * <note>
         * <p>
         * The CIs do not incur any cost.
         * </p>
         * </note>
         * 
         * @param configurationItemStatus
         *        The configuration item status. The valid values are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        OK – The resource configuration has been updated
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        ResourceDiscovered – The resource was newly discovered
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        ResourceNotRecorded – The resource was discovered but its configuration was not recorded since the
         *        recorder excludes the recording of resources of this type
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        ResourceDeleted – The resource was deleted
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        ResourceDeletedNotRecorded – The resource was deleted but its configuration was not recorded since the
         *        recorder excludes the recording of resources of this type
         *        </p>
         *        </li>
         *        </ul>
         *        <note>
         *        <p>
         *        The CIs do not incur any cost.
         *        </p>
         * @see ConfigurationItemStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConfigurationItemStatus
         */
        Builder configurationItemStatus(String configurationItemStatus);

        /**
         * <p>
         * The configuration item status. The valid values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * OK – The resource configuration has been updated
         * </p>
         * </li>
         * <li>
         * <p>
         * ResourceDiscovered – The resource was newly discovered
         * </p>
         * </li>
         * <li>
         * <p>
         * ResourceNotRecorded – The resource was discovered but its configuration was not recorded since the recorder
         * excludes the recording of resources of this type
         * </p>
         * </li>
         * <li>
         * <p>
         * ResourceDeleted – The resource was deleted
         * </p>
         * </li>
         * <li>
         * <p>
         * ResourceDeletedNotRecorded – The resource was deleted but its configuration was not recorded since the
         * recorder excludes the recording of resources of this type
         * </p>
         * </li>
         * </ul>
         * <note>
         * <p>
         * The CIs do not incur any cost.
         * </p>
         * </note>
         * 
         * @param configurationItemStatus
         *        The configuration item status. The valid values are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        OK – The resource configuration has been updated
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        ResourceDiscovered – The resource was newly discovered
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        ResourceNotRecorded – The resource was discovered but its configuration was not recorded since the
         *        recorder excludes the recording of resources of this type
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        ResourceDeleted – The resource was deleted
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        ResourceDeletedNotRecorded – The resource was deleted but its configuration was not recorded since the
         *        recorder excludes the recording of resources of this type
         *        </p>
         *        </li>
         *        </ul>
         *        <note>
         *        <p>
         *        The CIs do not incur any cost.
         *        </p>
         * @see ConfigurationItemStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConfigurationItemStatus
         */
        Builder configurationItemStatus(ConfigurationItemStatus configurationItemStatus);

        /**
         * <p>
         * An identifier that indicates the ordering of the configuration items of a resource.
         * </p>
         * 
         * @param configurationStateId
         *        An identifier that indicates the ordering of the configuration items of a resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationStateId(String configurationStateId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the resource.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The type of AWS resource.
         * </p>
         * 
         * @param resourceType
         *        The type of AWS resource.
         * @see ResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceType
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * The type of AWS resource.
         * </p>
         * 
         * @param resourceType
         *        The type of AWS resource.
         * @see ResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceType
         */
        Builder resourceType(ResourceType resourceType);

        /**
         * <p>
         * The ID of the resource (for example., sg-xxxxxx).
         * </p>
         * 
         * @param resourceId
         *        The ID of the resource (for example., sg-xxxxxx).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceId(String resourceId);

        /**
         * <p>
         * The custom name of the resource, if available.
         * </p>
         * 
         * @param resourceName
         *        The custom name of the resource, if available.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceName(String resourceName);

        /**
         * <p>
         * The region where the resource resides.
         * </p>
         * 
         * @param awsRegion
         *        The region where the resource resides.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsRegion(String awsRegion);

        /**
         * <p>
         * The Availability Zone associated with the resource.
         * </p>
         * 
         * @param availabilityZone
         *        The Availability Zone associated with the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZone(String availabilityZone);

        /**
         * <p>
         * The time stamp when the resource was created.
         * </p>
         * 
         * @param resourceCreationTime
         *        The time stamp when the resource was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceCreationTime(Instant resourceCreationTime);

        /**
         * <p>
         * The description of the resource configuration.
         * </p>
         * 
         * @param configuration
         *        The description of the resource configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configuration(String configuration);

        /**
         * <p>
         * Configuration attributes that AWS Config returns for certain resource types to supplement the information
         * returned for the configuration parameter.
         * </p>
         * 
         * @param supplementaryConfiguration
         *        Configuration attributes that AWS Config returns for certain resource types to supplement the
         *        information returned for the configuration parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supplementaryConfiguration(Map<String, String> supplementaryConfiguration);
    }

    static final class BuilderImpl implements Builder {
        private String version;

        private String accountId;

        private Instant configurationItemCaptureTime;

        private String configurationItemStatus;

        private String configurationStateId;

        private String arn;

        private String resourceType;

        private String resourceId;

        private String resourceName;

        private String awsRegion;

        private String availabilityZone;

        private Instant resourceCreationTime;

        private String configuration;

        private Map<String, String> supplementaryConfiguration = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BaseConfigurationItem model) {
            version(model.version);
            accountId(model.accountId);
            configurationItemCaptureTime(model.configurationItemCaptureTime);
            configurationItemStatus(model.configurationItemStatus);
            configurationStateId(model.configurationStateId);
            arn(model.arn);
            resourceType(model.resourceType);
            resourceId(model.resourceId);
            resourceName(model.resourceName);
            awsRegion(model.awsRegion);
            availabilityZone(model.availabilityZone);
            resourceCreationTime(model.resourceCreationTime);
            configuration(model.configuration);
            supplementaryConfiguration(model.supplementaryConfiguration);
        }

        public final String getVersion() {
            return version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        public final String getAccountId() {
            return accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        public final Instant getConfigurationItemCaptureTime() {
            return configurationItemCaptureTime;
        }

        @Override
        public final Builder configurationItemCaptureTime(Instant configurationItemCaptureTime) {
            this.configurationItemCaptureTime = configurationItemCaptureTime;
            return this;
        }

        public final void setConfigurationItemCaptureTime(Instant configurationItemCaptureTime) {
            this.configurationItemCaptureTime = configurationItemCaptureTime;
        }

        public final String getConfigurationItemStatus() {
            return configurationItemStatus;
        }

        @Override
        public final Builder configurationItemStatus(String configurationItemStatus) {
            this.configurationItemStatus = configurationItemStatus;
            return this;
        }

        @Override
        public final Builder configurationItemStatus(ConfigurationItemStatus configurationItemStatus) {
            this.configurationItemStatus(configurationItemStatus == null ? null : configurationItemStatus.toString());
            return this;
        }

        public final void setConfigurationItemStatus(String configurationItemStatus) {
            this.configurationItemStatus = configurationItemStatus;
        }

        public final String getConfigurationStateId() {
            return configurationStateId;
        }

        @Override
        public final Builder configurationStateId(String configurationStateId) {
            this.configurationStateId = configurationStateId;
            return this;
        }

        public final void setConfigurationStateId(String configurationStateId) {
            this.configurationStateId = configurationStateId;
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getResourceType() {
            return resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(ResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public final String getResourceId() {
            return resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        public final String getResourceName() {
            return resourceName;
        }

        @Override
        public final Builder resourceName(String resourceName) {
            this.resourceName = resourceName;
            return this;
        }

        public final void setResourceName(String resourceName) {
            this.resourceName = resourceName;
        }

        public final String getAwsRegion() {
            return awsRegion;
        }

        @Override
        public final Builder awsRegion(String awsRegion) {
            this.awsRegion = awsRegion;
            return this;
        }

        public final void setAwsRegion(String awsRegion) {
            this.awsRegion = awsRegion;
        }

        public final String getAvailabilityZone() {
            return availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final Instant getResourceCreationTime() {
            return resourceCreationTime;
        }

        @Override
        public final Builder resourceCreationTime(Instant resourceCreationTime) {
            this.resourceCreationTime = resourceCreationTime;
            return this;
        }

        public final void setResourceCreationTime(Instant resourceCreationTime) {
            this.resourceCreationTime = resourceCreationTime;
        }

        public final String getConfiguration() {
            return configuration;
        }

        @Override
        public final Builder configuration(String configuration) {
            this.configuration = configuration;
            return this;
        }

        public final void setConfiguration(String configuration) {
            this.configuration = configuration;
        }

        public final Map<String, String> getSupplementaryConfiguration() {
            return supplementaryConfiguration;
        }

        @Override
        public final Builder supplementaryConfiguration(Map<String, String> supplementaryConfiguration) {
            this.supplementaryConfiguration = SupplementaryConfigurationCopier.copy(supplementaryConfiguration);
            return this;
        }

        public final void setSupplementaryConfiguration(Map<String, String> supplementaryConfiguration) {
            this.supplementaryConfiguration = SupplementaryConfigurationCopier.copy(supplementaryConfiguration);
        }

        @Override
        public BaseConfigurationItem build() {
            return new BaseConfigurationItem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
