/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The status of a specified delivery channel.
 * </p>
 * <p>
 * Valid values: <code>Success</code> | <code>Failure</code>
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeliveryChannelStatus implements SdkPojo, Serializable,
        ToCopyableBuilder<DeliveryChannelStatus.Builder, DeliveryChannelStatus> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DeliveryChannelStatus::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<ConfigExportDeliveryInfo> CONFIG_SNAPSHOT_DELIVERY_INFO_FIELD = SdkField
            .<ConfigExportDeliveryInfo> builder(MarshallingType.SDK_POJO)
            .getter(getter(DeliveryChannelStatus::configSnapshotDeliveryInfo))
            .setter(setter(Builder::configSnapshotDeliveryInfo))
            .constructor(ConfigExportDeliveryInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configSnapshotDeliveryInfo").build())
            .build();

    private static final SdkField<ConfigExportDeliveryInfo> CONFIG_HISTORY_DELIVERY_INFO_FIELD = SdkField
            .<ConfigExportDeliveryInfo> builder(MarshallingType.SDK_POJO)
            .getter(getter(DeliveryChannelStatus::configHistoryDeliveryInfo)).setter(setter(Builder::configHistoryDeliveryInfo))
            .constructor(ConfigExportDeliveryInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configHistoryDeliveryInfo").build())
            .build();

    private static final SdkField<ConfigStreamDeliveryInfo> CONFIG_STREAM_DELIVERY_INFO_FIELD = SdkField
            .<ConfigStreamDeliveryInfo> builder(MarshallingType.SDK_POJO)
            .getter(getter(DeliveryChannelStatus::configStreamDeliveryInfo)).setter(setter(Builder::configStreamDeliveryInfo))
            .constructor(ConfigStreamDeliveryInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configStreamDeliveryInfo").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            CONFIG_SNAPSHOT_DELIVERY_INFO_FIELD, CONFIG_HISTORY_DELIVERY_INFO_FIELD, CONFIG_STREAM_DELIVERY_INFO_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final ConfigExportDeliveryInfo configSnapshotDeliveryInfo;

    private final ConfigExportDeliveryInfo configHistoryDeliveryInfo;

    private final ConfigStreamDeliveryInfo configStreamDeliveryInfo;

    private DeliveryChannelStatus(BuilderImpl builder) {
        this.name = builder.name;
        this.configSnapshotDeliveryInfo = builder.configSnapshotDeliveryInfo;
        this.configHistoryDeliveryInfo = builder.configHistoryDeliveryInfo;
        this.configStreamDeliveryInfo = builder.configStreamDeliveryInfo;
    }

    /**
     * <p>
     * The name of the delivery channel.
     * </p>
     * 
     * @return The name of the delivery channel.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * A list containing the status of the delivery of the snapshot to the specified Amazon S3 bucket.
     * </p>
     * 
     * @return A list containing the status of the delivery of the snapshot to the specified Amazon S3 bucket.
     */
    public ConfigExportDeliveryInfo configSnapshotDeliveryInfo() {
        return configSnapshotDeliveryInfo;
    }

    /**
     * <p>
     * A list that contains the status of the delivery of the configuration history to the specified Amazon S3 bucket.
     * </p>
     * 
     * @return A list that contains the status of the delivery of the configuration history to the specified Amazon S3
     *         bucket.
     */
    public ConfigExportDeliveryInfo configHistoryDeliveryInfo() {
        return configHistoryDeliveryInfo;
    }

    /**
     * <p>
     * A list containing the status of the delivery of the configuration stream notification to the specified Amazon SNS
     * topic.
     * </p>
     * 
     * @return A list containing the status of the delivery of the configuration stream notification to the specified
     *         Amazon SNS topic.
     */
    public ConfigStreamDeliveryInfo configStreamDeliveryInfo() {
        return configStreamDeliveryInfo;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(configSnapshotDeliveryInfo());
        hashCode = 31 * hashCode + Objects.hashCode(configHistoryDeliveryInfo());
        hashCode = 31 * hashCode + Objects.hashCode(configStreamDeliveryInfo());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeliveryChannelStatus)) {
            return false;
        }
        DeliveryChannelStatus other = (DeliveryChannelStatus) obj;
        return Objects.equals(name(), other.name())
                && Objects.equals(configSnapshotDeliveryInfo(), other.configSnapshotDeliveryInfo())
                && Objects.equals(configHistoryDeliveryInfo(), other.configHistoryDeliveryInfo())
                && Objects.equals(configStreamDeliveryInfo(), other.configStreamDeliveryInfo());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DeliveryChannelStatus").add("Name", name())
                .add("ConfigSnapshotDeliveryInfo", configSnapshotDeliveryInfo())
                .add("ConfigHistoryDeliveryInfo", configHistoryDeliveryInfo())
                .add("ConfigStreamDeliveryInfo", configStreamDeliveryInfo()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "configSnapshotDeliveryInfo":
            return Optional.ofNullable(clazz.cast(configSnapshotDeliveryInfo()));
        case "configHistoryDeliveryInfo":
            return Optional.ofNullable(clazz.cast(configHistoryDeliveryInfo()));
        case "configStreamDeliveryInfo":
            return Optional.ofNullable(clazz.cast(configStreamDeliveryInfo()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeliveryChannelStatus, T> g) {
        return obj -> g.apply((DeliveryChannelStatus) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DeliveryChannelStatus> {
        /**
         * <p>
         * The name of the delivery channel.
         * </p>
         * 
         * @param name
         *        The name of the delivery channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A list containing the status of the delivery of the snapshot to the specified Amazon S3 bucket.
         * </p>
         * 
         * @param configSnapshotDeliveryInfo
         *        A list containing the status of the delivery of the snapshot to the specified Amazon S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configSnapshotDeliveryInfo(ConfigExportDeliveryInfo configSnapshotDeliveryInfo);

        /**
         * <p>
         * A list containing the status of the delivery of the snapshot to the specified Amazon S3 bucket.
         * </p>
         * This is a convenience that creates an instance of the {@link ConfigExportDeliveryInfo.Builder} avoiding the
         * need to create one manually via {@link ConfigExportDeliveryInfo#builder()}.
         *
         * When the {@link Consumer} completes, {@link ConfigExportDeliveryInfo.Builder#build()} is called immediately
         * and its result is passed to {@link #configSnapshotDeliveryInfo(ConfigExportDeliveryInfo)}.
         * 
         * @param configSnapshotDeliveryInfo
         *        a consumer that will call methods on {@link ConfigExportDeliveryInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configSnapshotDeliveryInfo(ConfigExportDeliveryInfo)
         */
        default Builder configSnapshotDeliveryInfo(Consumer<ConfigExportDeliveryInfo.Builder> configSnapshotDeliveryInfo) {
            return configSnapshotDeliveryInfo(ConfigExportDeliveryInfo.builder().applyMutation(configSnapshotDeliveryInfo)
                    .build());
        }

        /**
         * <p>
         * A list that contains the status of the delivery of the configuration history to the specified Amazon S3
         * bucket.
         * </p>
         * 
         * @param configHistoryDeliveryInfo
         *        A list that contains the status of the delivery of the configuration history to the specified Amazon
         *        S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configHistoryDeliveryInfo(ConfigExportDeliveryInfo configHistoryDeliveryInfo);

        /**
         * <p>
         * A list that contains the status of the delivery of the configuration history to the specified Amazon S3
         * bucket.
         * </p>
         * This is a convenience that creates an instance of the {@link ConfigExportDeliveryInfo.Builder} avoiding the
         * need to create one manually via {@link ConfigExportDeliveryInfo#builder()}.
         *
         * When the {@link Consumer} completes, {@link ConfigExportDeliveryInfo.Builder#build()} is called immediately
         * and its result is passed to {@link #configHistoryDeliveryInfo(ConfigExportDeliveryInfo)}.
         * 
         * @param configHistoryDeliveryInfo
         *        a consumer that will call methods on {@link ConfigExportDeliveryInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configHistoryDeliveryInfo(ConfigExportDeliveryInfo)
         */
        default Builder configHistoryDeliveryInfo(Consumer<ConfigExportDeliveryInfo.Builder> configHistoryDeliveryInfo) {
            return configHistoryDeliveryInfo(ConfigExportDeliveryInfo.builder().applyMutation(configHistoryDeliveryInfo).build());
        }

        /**
         * <p>
         * A list containing the status of the delivery of the configuration stream notification to the specified Amazon
         * SNS topic.
         * </p>
         * 
         * @param configStreamDeliveryInfo
         *        A list containing the status of the delivery of the configuration stream notification to the specified
         *        Amazon SNS topic.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configStreamDeliveryInfo(ConfigStreamDeliveryInfo configStreamDeliveryInfo);

        /**
         * <p>
         * A list containing the status of the delivery of the configuration stream notification to the specified Amazon
         * SNS topic.
         * </p>
         * This is a convenience that creates an instance of the {@link ConfigStreamDeliveryInfo.Builder} avoiding the
         * need to create one manually via {@link ConfigStreamDeliveryInfo#builder()}.
         *
         * When the {@link Consumer} completes, {@link ConfigStreamDeliveryInfo.Builder#build()} is called immediately
         * and its result is passed to {@link #configStreamDeliveryInfo(ConfigStreamDeliveryInfo)}.
         * 
         * @param configStreamDeliveryInfo
         *        a consumer that will call methods on {@link ConfigStreamDeliveryInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configStreamDeliveryInfo(ConfigStreamDeliveryInfo)
         */
        default Builder configStreamDeliveryInfo(Consumer<ConfigStreamDeliveryInfo.Builder> configStreamDeliveryInfo) {
            return configStreamDeliveryInfo(ConfigStreamDeliveryInfo.builder().applyMutation(configStreamDeliveryInfo).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private ConfigExportDeliveryInfo configSnapshotDeliveryInfo;

        private ConfigExportDeliveryInfo configHistoryDeliveryInfo;

        private ConfigStreamDeliveryInfo configStreamDeliveryInfo;

        private BuilderImpl() {
        }

        private BuilderImpl(DeliveryChannelStatus model) {
            name(model.name);
            configSnapshotDeliveryInfo(model.configSnapshotDeliveryInfo);
            configHistoryDeliveryInfo(model.configHistoryDeliveryInfo);
            configStreamDeliveryInfo(model.configStreamDeliveryInfo);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final ConfigExportDeliveryInfo.Builder getConfigSnapshotDeliveryInfo() {
            return configSnapshotDeliveryInfo != null ? configSnapshotDeliveryInfo.toBuilder() : null;
        }

        @Override
        public final Builder configSnapshotDeliveryInfo(ConfigExportDeliveryInfo configSnapshotDeliveryInfo) {
            this.configSnapshotDeliveryInfo = configSnapshotDeliveryInfo;
            return this;
        }

        public final void setConfigSnapshotDeliveryInfo(ConfigExportDeliveryInfo.BuilderImpl configSnapshotDeliveryInfo) {
            this.configSnapshotDeliveryInfo = configSnapshotDeliveryInfo != null ? configSnapshotDeliveryInfo.build() : null;
        }

        public final ConfigExportDeliveryInfo.Builder getConfigHistoryDeliveryInfo() {
            return configHistoryDeliveryInfo != null ? configHistoryDeliveryInfo.toBuilder() : null;
        }

        @Override
        public final Builder configHistoryDeliveryInfo(ConfigExportDeliveryInfo configHistoryDeliveryInfo) {
            this.configHistoryDeliveryInfo = configHistoryDeliveryInfo;
            return this;
        }

        public final void setConfigHistoryDeliveryInfo(ConfigExportDeliveryInfo.BuilderImpl configHistoryDeliveryInfo) {
            this.configHistoryDeliveryInfo = configHistoryDeliveryInfo != null ? configHistoryDeliveryInfo.build() : null;
        }

        public final ConfigStreamDeliveryInfo.Builder getConfigStreamDeliveryInfo() {
            return configStreamDeliveryInfo != null ? configStreamDeliveryInfo.toBuilder() : null;
        }

        @Override
        public final Builder configStreamDeliveryInfo(ConfigStreamDeliveryInfo configStreamDeliveryInfo) {
            this.configStreamDeliveryInfo = configStreamDeliveryInfo;
            return this;
        }

        public final void setConfigStreamDeliveryInfo(ConfigStreamDeliveryInfo.BuilderImpl configStreamDeliveryInfo) {
            this.configStreamDeliveryInfo = configStreamDeliveryInfo != null ? configStreamDeliveryInfo.build() : null;
        }

        @Override
        public DeliveryChannelStatus build() {
            return new DeliveryChannelStatus(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
