/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The number of AWS resources of a specific type that are compliant or noncompliant, up to a maximum of 100 for each.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ComplianceSummaryByResourceType implements SdkPojo, Serializable,
        ToCopyableBuilder<ComplianceSummaryByResourceType.Builder, ComplianceSummaryByResourceType> {
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ComplianceSummaryByResourceType::resourceType)).setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()).build();

    private static final SdkField<ComplianceSummary> COMPLIANCE_SUMMARY_FIELD = SdkField
            .<ComplianceSummary> builder(MarshallingType.SDK_POJO)
            .getter(getter(ComplianceSummaryByResourceType::complianceSummary)).setter(setter(Builder::complianceSummary))
            .constructor(ComplianceSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComplianceSummary").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_TYPE_FIELD,
            COMPLIANCE_SUMMARY_FIELD));

    private static final long serialVersionUID = 1L;

    private final String resourceType;

    private final ComplianceSummary complianceSummary;

    private ComplianceSummaryByResourceType(BuilderImpl builder) {
        this.resourceType = builder.resourceType;
        this.complianceSummary = builder.complianceSummary;
    }

    /**
     * <p>
     * The type of AWS resource.
     * </p>
     * 
     * @return The type of AWS resource.
     */
    public String resourceType() {
        return resourceType;
    }

    /**
     * <p>
     * The number of AWS resources that are compliant or noncompliant, up to a maximum of 100 for each.
     * </p>
     * 
     * @return The number of AWS resources that are compliant or noncompliant, up to a maximum of 100 for each.
     */
    public ComplianceSummary complianceSummary() {
        return complianceSummary;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(resourceType());
        hashCode = 31 * hashCode + Objects.hashCode(complianceSummary());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComplianceSummaryByResourceType)) {
            return false;
        }
        ComplianceSummaryByResourceType other = (ComplianceSummaryByResourceType) obj;
        return Objects.equals(resourceType(), other.resourceType())
                && Objects.equals(complianceSummary(), other.complianceSummary());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ComplianceSummaryByResourceType").add("ResourceType", resourceType())
                .add("ComplianceSummary", complianceSummary()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceType":
            return Optional.ofNullable(clazz.cast(resourceType()));
        case "ComplianceSummary":
            return Optional.ofNullable(clazz.cast(complianceSummary()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ComplianceSummaryByResourceType, T> g) {
        return obj -> g.apply((ComplianceSummaryByResourceType) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ComplianceSummaryByResourceType> {
        /**
         * <p>
         * The type of AWS resource.
         * </p>
         * 
         * @param resourceType
         *        The type of AWS resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * The number of AWS resources that are compliant or noncompliant, up to a maximum of 100 for each.
         * </p>
         * 
         * @param complianceSummary
         *        The number of AWS resources that are compliant or noncompliant, up to a maximum of 100 for each.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder complianceSummary(ComplianceSummary complianceSummary);

        /**
         * <p>
         * The number of AWS resources that are compliant or noncompliant, up to a maximum of 100 for each.
         * </p>
         * This is a convenience that creates an instance of the {@link ComplianceSummary.Builder} avoiding the need to
         * create one manually via {@link ComplianceSummary#builder()}.
         *
         * When the {@link Consumer} completes, {@link ComplianceSummary.Builder#build()} is called immediately and its
         * result is passed to {@link #complianceSummary(ComplianceSummary)}.
         * 
         * @param complianceSummary
         *        a consumer that will call methods on {@link ComplianceSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #complianceSummary(ComplianceSummary)
         */
        default Builder complianceSummary(Consumer<ComplianceSummary.Builder> complianceSummary) {
            return complianceSummary(ComplianceSummary.builder().applyMutation(complianceSummary).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String resourceType;

        private ComplianceSummary complianceSummary;

        private BuilderImpl() {
        }

        private BuilderImpl(ComplianceSummaryByResourceType model) {
            resourceType(model.resourceType);
            complianceSummary(model.complianceSummary);
        }

        public final String getResourceType() {
            return resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public final ComplianceSummary.Builder getComplianceSummary() {
            return complianceSummary != null ? complianceSummary.toBuilder() : null;
        }

        @Override
        public final Builder complianceSummary(ComplianceSummary complianceSummary) {
            this.complianceSummary = complianceSummary;
            return this;
        }

        public final void setComplianceSummary(ComplianceSummary.BuilderImpl complianceSummary) {
            this.complianceSummary = complianceSummary != null ? complianceSummary.build() : null;
        }

        @Override
        public ComplianceSummaryByResourceType build() {
            return new ComplianceSummaryByResourceType(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
