/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetDiscoveredResourceCountsResponse extends ConfigResponse implements
        ToCopyableBuilder<GetDiscoveredResourceCountsResponse.Builder, GetDiscoveredResourceCountsResponse> {
    private static final SdkField<Long> TOTAL_DISCOVERED_RESOURCES_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(GetDiscoveredResourceCountsResponse::totalDiscoveredResources))
            .setter(setter(Builder::totalDiscoveredResources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("totalDiscoveredResources").build())
            .build();

    private static final SdkField<List<ResourceCount>> RESOURCE_COUNTS_FIELD = SdkField
            .<List<ResourceCount>> builder(MarshallingType.LIST)
            .getter(getter(GetDiscoveredResourceCountsResponse::resourceCounts))
            .setter(setter(Builder::resourceCounts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceCounts").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ResourceCount> builder(MarshallingType.SDK_POJO)
                                            .constructor(ResourceCount::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetDiscoveredResourceCountsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            TOTAL_DISCOVERED_RESOURCES_FIELD, RESOURCE_COUNTS_FIELD, NEXT_TOKEN_FIELD));

    private final Long totalDiscoveredResources;

    private final List<ResourceCount> resourceCounts;

    private final String nextToken;

    private GetDiscoveredResourceCountsResponse(BuilderImpl builder) {
        super(builder);
        this.totalDiscoveredResources = builder.totalDiscoveredResources;
        this.resourceCounts = builder.resourceCounts;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The total number of resources that AWS Config is recording in the region for your account. If you specify
     * resource types in the request, AWS Config returns only the total number of resources for those resource types.
     * </p>
     * <p class="title">
     * <b>Example</b>
     * </p>
     * <ol>
     * <li>
     * <p>
     * AWS Config is recording three resource types in the US East (Ohio) Region for your account: 25 EC2 instances, 20
     * IAM users, and 15 S3 buckets, for a total of 60 resources.
     * </p>
     * </li>
     * <li>
     * <p>
     * You make a call to the <code>GetDiscoveredResourceCounts</code> action and specify the resource type,
     * <code>"AWS::EC2::Instances"</code>, in the request.
     * </p>
     * </li>
     * <li>
     * <p>
     * AWS Config returns 25 for <code>totalDiscoveredResources</code>.
     * </p>
     * </li>
     * </ol>
     * 
     * @return The total number of resources that AWS Config is recording in the region for your account. If you specify
     *         resource types in the request, AWS Config returns only the total number of resources for those resource
     *         types.</p>
     *         <p class="title">
     *         <b>Example</b>
     *         </p>
     *         <ol>
     *         <li>
     *         <p>
     *         AWS Config is recording three resource types in the US East (Ohio) Region for your account: 25 EC2
     *         instances, 20 IAM users, and 15 S3 buckets, for a total of 60 resources.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You make a call to the <code>GetDiscoveredResourceCounts</code> action and specify the resource type,
     *         <code>"AWS::EC2::Instances"</code>, in the request.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         AWS Config returns 25 for <code>totalDiscoveredResources</code>.
     *         </p>
     *         </li>
     */
    public Long totalDiscoveredResources() {
        return totalDiscoveredResources;
    }

    /**
     * Returns true if the ResourceCounts property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasResourceCounts() {
        return resourceCounts != null && !(resourceCounts instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of <code>ResourceCount</code> objects. Each object is listed in descending order by the number of
     * resources.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasResourceCounts()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The list of <code>ResourceCount</code> objects. Each object is listed in descending order by the number
     *         of resources.
     */
    public List<ResourceCount> resourceCounts() {
        return resourceCounts;
    }

    /**
     * <p>
     * The string that you use in a subsequent request to get the next page of results in a paginated response.
     * </p>
     * 
     * @return The string that you use in a subsequent request to get the next page of results in a paginated response.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(totalDiscoveredResources());
        hashCode = 31 * hashCode + Objects.hashCode(resourceCounts());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDiscoveredResourceCountsResponse)) {
            return false;
        }
        GetDiscoveredResourceCountsResponse other = (GetDiscoveredResourceCountsResponse) obj;
        return Objects.equals(totalDiscoveredResources(), other.totalDiscoveredResources())
                && Objects.equals(resourceCounts(), other.resourceCounts()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetDiscoveredResourceCountsResponse")
                .add("TotalDiscoveredResources", totalDiscoveredResources()).add("ResourceCounts", resourceCounts())
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "totalDiscoveredResources":
            return Optional.ofNullable(clazz.cast(totalDiscoveredResources()));
        case "resourceCounts":
            return Optional.ofNullable(clazz.cast(resourceCounts()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetDiscoveredResourceCountsResponse, T> g) {
        return obj -> g.apply((GetDiscoveredResourceCountsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConfigResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetDiscoveredResourceCountsResponse> {
        /**
         * <p>
         * The total number of resources that AWS Config is recording in the region for your account. If you specify
         * resource types in the request, AWS Config returns only the total number of resources for those resource
         * types.
         * </p>
         * <p class="title">
         * <b>Example</b>
         * </p>
         * <ol>
         * <li>
         * <p>
         * AWS Config is recording three resource types in the US East (Ohio) Region for your account: 25 EC2 instances,
         * 20 IAM users, and 15 S3 buckets, for a total of 60 resources.
         * </p>
         * </li>
         * <li>
         * <p>
         * You make a call to the <code>GetDiscoveredResourceCounts</code> action and specify the resource type,
         * <code>"AWS::EC2::Instances"</code>, in the request.
         * </p>
         * </li>
         * <li>
         * <p>
         * AWS Config returns 25 for <code>totalDiscoveredResources</code>.
         * </p>
         * </li>
         * </ol>
         * 
         * @param totalDiscoveredResources
         *        The total number of resources that AWS Config is recording in the region for your account. If you
         *        specify resource types in the request, AWS Config returns only the total number of resources for those
         *        resource types.</p>
         *        <p class="title">
         *        <b>Example</b>
         *        </p>
         *        <ol>
         *        <li>
         *        <p>
         *        AWS Config is recording three resource types in the US East (Ohio) Region for your account: 25 EC2
         *        instances, 20 IAM users, and 15 S3 buckets, for a total of 60 resources.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        You make a call to the <code>GetDiscoveredResourceCounts</code> action and specify the resource type,
         *        <code>"AWS::EC2::Instances"</code>, in the request.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        AWS Config returns 25 for <code>totalDiscoveredResources</code>.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalDiscoveredResources(Long totalDiscoveredResources);

        /**
         * <p>
         * The list of <code>ResourceCount</code> objects. Each object is listed in descending order by the number of
         * resources.
         * </p>
         * 
         * @param resourceCounts
         *        The list of <code>ResourceCount</code> objects. Each object is listed in descending order by the
         *        number of resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceCounts(Collection<ResourceCount> resourceCounts);

        /**
         * <p>
         * The list of <code>ResourceCount</code> objects. Each object is listed in descending order by the number of
         * resources.
         * </p>
         * 
         * @param resourceCounts
         *        The list of <code>ResourceCount</code> objects. Each object is listed in descending order by the
         *        number of resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceCounts(ResourceCount... resourceCounts);

        /**
         * <p>
         * The list of <code>ResourceCount</code> objects. Each object is listed in descending order by the number of
         * resources.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ResourceCount>.Builder} avoiding the need
         * to create one manually via {@link List<ResourceCount>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ResourceCount>.Builder#build()} is called immediately and
         * its result is passed to {@link #resourceCounts(List<ResourceCount>)}.
         * 
         * @param resourceCounts
         *        a consumer that will call methods on {@link List<ResourceCount>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceCounts(List<ResourceCount>)
         */
        Builder resourceCounts(Consumer<ResourceCount.Builder>... resourceCounts);

        /**
         * <p>
         * The string that you use in a subsequent request to get the next page of results in a paginated response.
         * </p>
         * 
         * @param nextToken
         *        The string that you use in a subsequent request to get the next page of results in a paginated
         *        response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ConfigResponse.BuilderImpl implements Builder {
        private Long totalDiscoveredResources;

        private List<ResourceCount> resourceCounts = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDiscoveredResourceCountsResponse model) {
            super(model);
            totalDiscoveredResources(model.totalDiscoveredResources);
            resourceCounts(model.resourceCounts);
            nextToken(model.nextToken);
        }

        public final Long getTotalDiscoveredResources() {
            return totalDiscoveredResources;
        }

        @Override
        public final Builder totalDiscoveredResources(Long totalDiscoveredResources) {
            this.totalDiscoveredResources = totalDiscoveredResources;
            return this;
        }

        public final void setTotalDiscoveredResources(Long totalDiscoveredResources) {
            this.totalDiscoveredResources = totalDiscoveredResources;
        }

        public final Collection<ResourceCount.Builder> getResourceCounts() {
            return resourceCounts != null ? resourceCounts.stream().map(ResourceCount::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder resourceCounts(Collection<ResourceCount> resourceCounts) {
            this.resourceCounts = ResourceCountsCopier.copy(resourceCounts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceCounts(ResourceCount... resourceCounts) {
            resourceCounts(Arrays.asList(resourceCounts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceCounts(Consumer<ResourceCount.Builder>... resourceCounts) {
            resourceCounts(Stream.of(resourceCounts).map(c -> ResourceCount.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setResourceCounts(Collection<ResourceCount.BuilderImpl> resourceCounts) {
            this.resourceCounts = ResourceCountsCopier.copyFromBuilder(resourceCounts);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public GetDiscoveredResourceCountsResponse build() {
            return new GetDiscoveredResourceCountsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
