/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteConfigurationAggregatorRequest extends ConfigRequest implements
        ToCopyableBuilder<DeleteConfigurationAggregatorRequest.Builder, DeleteConfigurationAggregatorRequest> {
    private static final SdkField<String> CONFIGURATION_AGGREGATOR_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ConfigurationAggregatorName")
            .getter(getter(DeleteConfigurationAggregatorRequest::configurationAggregatorName))
            .setter(setter(Builder::configurationAggregatorName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationAggregatorName")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(CONFIGURATION_AGGREGATOR_NAME_FIELD));

    private final String configurationAggregatorName;

    private DeleteConfigurationAggregatorRequest(BuilderImpl builder) {
        super(builder);
        this.configurationAggregatorName = builder.configurationAggregatorName;
    }

    /**
     * <p>
     * The name of the configuration aggregator.
     * </p>
     * 
     * @return The name of the configuration aggregator.
     */
    public String configurationAggregatorName() {
        return configurationAggregatorName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(configurationAggregatorName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteConfigurationAggregatorRequest)) {
            return false;
        }
        DeleteConfigurationAggregatorRequest other = (DeleteConfigurationAggregatorRequest) obj;
        return Objects.equals(configurationAggregatorName(), other.configurationAggregatorName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DeleteConfigurationAggregatorRequest")
                .add("ConfigurationAggregatorName", configurationAggregatorName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConfigurationAggregatorName":
            return Optional.ofNullable(clazz.cast(configurationAggregatorName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteConfigurationAggregatorRequest, T> g) {
        return obj -> g.apply((DeleteConfigurationAggregatorRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConfigRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DeleteConfigurationAggregatorRequest> {
        /**
         * <p>
         * The name of the configuration aggregator.
         * </p>
         * 
         * @param configurationAggregatorName
         *        The name of the configuration aggregator.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationAggregatorName(String configurationAggregatorName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ConfigRequest.BuilderImpl implements Builder {
        private String configurationAggregatorName;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteConfigurationAggregatorRequest model) {
            super(model);
            configurationAggregatorName(model.configurationAggregatorName);
        }

        public final String getConfigurationAggregatorName() {
            return configurationAggregatorName;
        }

        @Override
        public final Builder configurationAggregatorName(String configurationAggregatorName) {
            this.configurationAggregatorName = configurationAggregatorName;
            return this;
        }

        public final void setConfigurationAggregatorName(String configurationAggregatorName) {
            this.configurationAggregatorName = configurationAggregatorName;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteConfigurationAggregatorRequest build() {
            return new DeleteConfigurationAggregatorRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
