/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.config.model.OrganizationRuleStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OrganizationConfigRuleStatus
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OrganizationConfigRuleStatus> {
    private static final SdkField<String> ORGANIZATION_CONFIG_RULE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OrganizationConfigRuleName").getter(OrganizationConfigRuleStatus.getter(OrganizationConfigRuleStatus::organizationConfigRuleName)).setter(OrganizationConfigRuleStatus.setter(Builder::organizationConfigRuleName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationConfigRuleName").build()}).build();
    private static final SdkField<String> ORGANIZATION_RULE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OrganizationRuleStatus").getter(OrganizationConfigRuleStatus.getter(OrganizationConfigRuleStatus::organizationRuleStatusAsString)).setter(OrganizationConfigRuleStatus.setter(Builder::organizationRuleStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationRuleStatus").build()}).build();
    private static final SdkField<String> ERROR_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ErrorCode").getter(OrganizationConfigRuleStatus.getter(OrganizationConfigRuleStatus::errorCode)).setter(OrganizationConfigRuleStatus.setter(Builder::errorCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorCode").build()}).build();
    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ErrorMessage").getter(OrganizationConfigRuleStatus.getter(OrganizationConfigRuleStatus::errorMessage)).setter(OrganizationConfigRuleStatus.setter(Builder::errorMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorMessage").build()}).build();
    private static final SdkField<Instant> LAST_UPDATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastUpdateTime").getter(OrganizationConfigRuleStatus.getter(OrganizationConfigRuleStatus::lastUpdateTime)).setter(OrganizationConfigRuleStatus.setter(Builder::lastUpdateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdateTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ORGANIZATION_CONFIG_RULE_NAME_FIELD, ORGANIZATION_RULE_STATUS_FIELD, ERROR_CODE_FIELD, ERROR_MESSAGE_FIELD, LAST_UPDATE_TIME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String organizationConfigRuleName;
    private final String organizationRuleStatus;
    private final String errorCode;
    private final String errorMessage;
    private final Instant lastUpdateTime;

    private OrganizationConfigRuleStatus(BuilderImpl builder) {
        this.organizationConfigRuleName = builder.organizationConfigRuleName;
        this.organizationRuleStatus = builder.organizationRuleStatus;
        this.errorCode = builder.errorCode;
        this.errorMessage = builder.errorMessage;
        this.lastUpdateTime = builder.lastUpdateTime;
    }

    public String organizationConfigRuleName() {
        return this.organizationConfigRuleName;
    }

    public OrganizationRuleStatus organizationRuleStatus() {
        return OrganizationRuleStatus.fromValue(this.organizationRuleStatus);
    }

    public String organizationRuleStatusAsString() {
        return this.organizationRuleStatus;
    }

    public String errorCode() {
        return this.errorCode;
    }

    public String errorMessage() {
        return this.errorMessage;
    }

    public Instant lastUpdateTime() {
        return this.lastUpdateTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.organizationConfigRuleName());
        hashCode = 31 * hashCode + Objects.hashCode(this.organizationRuleStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdateTime());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OrganizationConfigRuleStatus)) {
            return false;
        }
        OrganizationConfigRuleStatus other = (OrganizationConfigRuleStatus)obj;
        return Objects.equals(this.organizationConfigRuleName(), other.organizationConfigRuleName()) && Objects.equals(this.organizationRuleStatusAsString(), other.organizationRuleStatusAsString()) && Objects.equals(this.errorCode(), other.errorCode()) && Objects.equals(this.errorMessage(), other.errorMessage()) && Objects.equals(this.lastUpdateTime(), other.lastUpdateTime());
    }

    public String toString() {
        return ToString.builder((String)"OrganizationConfigRuleStatus").add("OrganizationConfigRuleName", (Object)this.organizationConfigRuleName()).add("OrganizationRuleStatus", (Object)this.organizationRuleStatusAsString()).add("ErrorCode", (Object)this.errorCode()).add("ErrorMessage", (Object)this.errorMessage()).add("LastUpdateTime", (Object)this.lastUpdateTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OrganizationConfigRuleName": {
                return Optional.ofNullable(clazz.cast(this.organizationConfigRuleName()));
            }
            case "OrganizationRuleStatus": {
                return Optional.ofNullable(clazz.cast(this.organizationRuleStatusAsString()));
            }
            case "ErrorCode": {
                return Optional.ofNullable(clazz.cast(this.errorCode()));
            }
            case "ErrorMessage": {
                return Optional.ofNullable(clazz.cast(this.errorMessage()));
            }
            case "LastUpdateTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdateTime()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OrganizationConfigRuleStatus, T> g) {
        return obj -> g.apply((OrganizationConfigRuleStatus)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String organizationConfigRuleName;
        private String organizationRuleStatus;
        private String errorCode;
        private String errorMessage;
        private Instant lastUpdateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(OrganizationConfigRuleStatus model) {
            this.organizationConfigRuleName(model.organizationConfigRuleName);
            this.organizationRuleStatus(model.organizationRuleStatus);
            this.errorCode(model.errorCode);
            this.errorMessage(model.errorMessage);
            this.lastUpdateTime(model.lastUpdateTime);
        }

        public final String getOrganizationConfigRuleName() {
            return this.organizationConfigRuleName;
        }

        @Override
        public final Builder organizationConfigRuleName(String organizationConfigRuleName) {
            this.organizationConfigRuleName = organizationConfigRuleName;
            return this;
        }

        public final void setOrganizationConfigRuleName(String organizationConfigRuleName) {
            this.organizationConfigRuleName = organizationConfigRuleName;
        }

        public final String getOrganizationRuleStatus() {
            return this.organizationRuleStatus;
        }

        @Override
        public final Builder organizationRuleStatus(String organizationRuleStatus) {
            this.organizationRuleStatus = organizationRuleStatus;
            return this;
        }

        @Override
        public final Builder organizationRuleStatus(OrganizationRuleStatus organizationRuleStatus) {
            this.organizationRuleStatus(organizationRuleStatus == null ? null : organizationRuleStatus.toString());
            return this;
        }

        public final void setOrganizationRuleStatus(String organizationRuleStatus) {
            this.organizationRuleStatus = organizationRuleStatus;
        }

        public final String getErrorCode() {
            return this.errorCode;
        }

        @Override
        public final Builder errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        public final void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public final String getErrorMessage() {
            return this.errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        public final Instant getLastUpdateTime() {
            return this.lastUpdateTime;
        }

        @Override
        public final Builder lastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
            return this;
        }

        public final void setLastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
        }

        public OrganizationConfigRuleStatus build() {
            return new OrganizationConfigRuleStatus(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OrganizationConfigRuleStatus> {
        public Builder organizationConfigRuleName(String var1);

        public Builder organizationRuleStatus(String var1);

        public Builder organizationRuleStatus(OrganizationRuleStatus var1);

        public Builder errorCode(String var1);

        public Builder errorMessage(String var1);

        public Builder lastUpdateTime(Instant var1);
    }
}

