/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The details of a conformance pack evaluation. Provides AWS Config rule and AWS resource type that was evaluated, the
 * compliance of the conformance pack, related time stamps, and supplementary information.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConformancePackEvaluationResult implements SdkPojo, Serializable,
        ToCopyableBuilder<ConformancePackEvaluationResult.Builder, ConformancePackEvaluationResult> {
    private static final SdkField<String> COMPLIANCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ComplianceType").getter(getter(ConformancePackEvaluationResult::complianceTypeAsString))
            .setter(setter(Builder::complianceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComplianceType").build()).build();

    private static final SdkField<EvaluationResultIdentifier> EVALUATION_RESULT_IDENTIFIER_FIELD = SdkField
            .<EvaluationResultIdentifier> builder(MarshallingType.SDK_POJO)
            .memberName("EvaluationResultIdentifier")
            .getter(getter(ConformancePackEvaluationResult::evaluationResultIdentifier))
            .setter(setter(Builder::evaluationResultIdentifier))
            .constructor(EvaluationResultIdentifier::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluationResultIdentifier").build())
            .build();

    private static final SdkField<Instant> CONFIG_RULE_INVOKED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("ConfigRuleInvokedTime").getter(getter(ConformancePackEvaluationResult::configRuleInvokedTime))
            .setter(setter(Builder::configRuleInvokedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigRuleInvokedTime").build())
            .build();

    private static final SdkField<Instant> RESULT_RECORDED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("ResultRecordedTime").getter(getter(ConformancePackEvaluationResult::resultRecordedTime))
            .setter(setter(Builder::resultRecordedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResultRecordedTime").build())
            .build();

    private static final SdkField<String> ANNOTATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Annotation").getter(getter(ConformancePackEvaluationResult::annotation))
            .setter(setter(Builder::annotation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Annotation").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPLIANCE_TYPE_FIELD,
            EVALUATION_RESULT_IDENTIFIER_FIELD, CONFIG_RULE_INVOKED_TIME_FIELD, RESULT_RECORDED_TIME_FIELD, ANNOTATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String complianceType;

    private final EvaluationResultIdentifier evaluationResultIdentifier;

    private final Instant configRuleInvokedTime;

    private final Instant resultRecordedTime;

    private final String annotation;

    private ConformancePackEvaluationResult(BuilderImpl builder) {
        this.complianceType = builder.complianceType;
        this.evaluationResultIdentifier = builder.evaluationResultIdentifier;
        this.configRuleInvokedTime = builder.configRuleInvokedTime;
        this.resultRecordedTime = builder.resultRecordedTime;
        this.annotation = builder.annotation;
    }

    /**
     * <p>
     * The compliance type. The allowed values are <code>COMPLIANT</code> and <code>NON_COMPLIANT</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #complianceType}
     * will return {@link ConformancePackComplianceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #complianceTypeAsString}.
     * </p>
     * 
     * @return The compliance type. The allowed values are <code>COMPLIANT</code> and <code>NON_COMPLIANT</code>.
     * @see ConformancePackComplianceType
     */
    public ConformancePackComplianceType complianceType() {
        return ConformancePackComplianceType.fromValue(complianceType);
    }

    /**
     * <p>
     * The compliance type. The allowed values are <code>COMPLIANT</code> and <code>NON_COMPLIANT</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #complianceType}
     * will return {@link ConformancePackComplianceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #complianceTypeAsString}.
     * </p>
     * 
     * @return The compliance type. The allowed values are <code>COMPLIANT</code> and <code>NON_COMPLIANT</code>.
     * @see ConformancePackComplianceType
     */
    public String complianceTypeAsString() {
        return complianceType;
    }

    /**
     * Returns the value of the EvaluationResultIdentifier property for this object.
     * 
     * @return The value of the EvaluationResultIdentifier property for this object.
     */
    public EvaluationResultIdentifier evaluationResultIdentifier() {
        return evaluationResultIdentifier;
    }

    /**
     * <p>
     * The time when AWS Config rule evaluated AWS resource.
     * </p>
     * 
     * @return The time when AWS Config rule evaluated AWS resource.
     */
    public Instant configRuleInvokedTime() {
        return configRuleInvokedTime;
    }

    /**
     * <p>
     * The time when AWS Config recorded the evaluation result.
     * </p>
     * 
     * @return The time when AWS Config recorded the evaluation result.
     */
    public Instant resultRecordedTime() {
        return resultRecordedTime;
    }

    /**
     * <p>
     * Supplementary information about how the evaluation determined the compliance.
     * </p>
     * 
     * @return Supplementary information about how the evaluation determined the compliance.
     */
    public String annotation() {
        return annotation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(complianceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(evaluationResultIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(configRuleInvokedTime());
        hashCode = 31 * hashCode + Objects.hashCode(resultRecordedTime());
        hashCode = 31 * hashCode + Objects.hashCode(annotation());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConformancePackEvaluationResult)) {
            return false;
        }
        ConformancePackEvaluationResult other = (ConformancePackEvaluationResult) obj;
        return Objects.equals(complianceTypeAsString(), other.complianceTypeAsString())
                && Objects.equals(evaluationResultIdentifier(), other.evaluationResultIdentifier())
                && Objects.equals(configRuleInvokedTime(), other.configRuleInvokedTime())
                && Objects.equals(resultRecordedTime(), other.resultRecordedTime())
                && Objects.equals(annotation(), other.annotation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ConformancePackEvaluationResult").add("ComplianceType", complianceTypeAsString())
                .add("EvaluationResultIdentifier", evaluationResultIdentifier())
                .add("ConfigRuleInvokedTime", configRuleInvokedTime()).add("ResultRecordedTime", resultRecordedTime())
                .add("Annotation", annotation()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ComplianceType":
            return Optional.ofNullable(clazz.cast(complianceTypeAsString()));
        case "EvaluationResultIdentifier":
            return Optional.ofNullable(clazz.cast(evaluationResultIdentifier()));
        case "ConfigRuleInvokedTime":
            return Optional.ofNullable(clazz.cast(configRuleInvokedTime()));
        case "ResultRecordedTime":
            return Optional.ofNullable(clazz.cast(resultRecordedTime()));
        case "Annotation":
            return Optional.ofNullable(clazz.cast(annotation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConformancePackEvaluationResult, T> g) {
        return obj -> g.apply((ConformancePackEvaluationResult) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConformancePackEvaluationResult> {
        /**
         * <p>
         * The compliance type. The allowed values are <code>COMPLIANT</code> and <code>NON_COMPLIANT</code>.
         * </p>
         * 
         * @param complianceType
         *        The compliance type. The allowed values are <code>COMPLIANT</code> and <code>NON_COMPLIANT</code>.
         * @see ConformancePackComplianceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConformancePackComplianceType
         */
        Builder complianceType(String complianceType);

        /**
         * <p>
         * The compliance type. The allowed values are <code>COMPLIANT</code> and <code>NON_COMPLIANT</code>.
         * </p>
         * 
         * @param complianceType
         *        The compliance type. The allowed values are <code>COMPLIANT</code> and <code>NON_COMPLIANT</code>.
         * @see ConformancePackComplianceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConformancePackComplianceType
         */
        Builder complianceType(ConformancePackComplianceType complianceType);

        /**
         * Sets the value of the EvaluationResultIdentifier property for this object.
         *
         * @param evaluationResultIdentifier
         *        The new value for the EvaluationResultIdentifier property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evaluationResultIdentifier(EvaluationResultIdentifier evaluationResultIdentifier);

        /**
         * Sets the value of the EvaluationResultIdentifier property for this object.
         *
         * This is a convenience that creates an instance of the {@link EvaluationResultIdentifier.Builder} avoiding the
         * need to create one manually via {@link EvaluationResultIdentifier#builder()}.
         *
         * When the {@link Consumer} completes, {@link EvaluationResultIdentifier.Builder#build()} is called immediately
         * and its result is passed to {@link #evaluationResultIdentifier(EvaluationResultIdentifier)}.
         * 
         * @param evaluationResultIdentifier
         *        a consumer that will call methods on {@link EvaluationResultIdentifier.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #evaluationResultIdentifier(EvaluationResultIdentifier)
         */
        default Builder evaluationResultIdentifier(Consumer<EvaluationResultIdentifier.Builder> evaluationResultIdentifier) {
            return evaluationResultIdentifier(EvaluationResultIdentifier.builder().applyMutation(evaluationResultIdentifier)
                    .build());
        }

        /**
         * <p>
         * The time when AWS Config rule evaluated AWS resource.
         * </p>
         * 
         * @param configRuleInvokedTime
         *        The time when AWS Config rule evaluated AWS resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configRuleInvokedTime(Instant configRuleInvokedTime);

        /**
         * <p>
         * The time when AWS Config recorded the evaluation result.
         * </p>
         * 
         * @param resultRecordedTime
         *        The time when AWS Config recorded the evaluation result.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resultRecordedTime(Instant resultRecordedTime);

        /**
         * <p>
         * Supplementary information about how the evaluation determined the compliance.
         * </p>
         * 
         * @param annotation
         *        Supplementary information about how the evaluation determined the compliance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder annotation(String annotation);
    }

    static final class BuilderImpl implements Builder {
        private String complianceType;

        private EvaluationResultIdentifier evaluationResultIdentifier;

        private Instant configRuleInvokedTime;

        private Instant resultRecordedTime;

        private String annotation;

        private BuilderImpl() {
        }

        private BuilderImpl(ConformancePackEvaluationResult model) {
            complianceType(model.complianceType);
            evaluationResultIdentifier(model.evaluationResultIdentifier);
            configRuleInvokedTime(model.configRuleInvokedTime);
            resultRecordedTime(model.resultRecordedTime);
            annotation(model.annotation);
        }

        public final String getComplianceType() {
            return complianceType;
        }

        @Override
        public final Builder complianceType(String complianceType) {
            this.complianceType = complianceType;
            return this;
        }

        @Override
        public final Builder complianceType(ConformancePackComplianceType complianceType) {
            this.complianceType(complianceType == null ? null : complianceType.toString());
            return this;
        }

        public final void setComplianceType(String complianceType) {
            this.complianceType = complianceType;
        }

        public final EvaluationResultIdentifier.Builder getEvaluationResultIdentifier() {
            return evaluationResultIdentifier != null ? evaluationResultIdentifier.toBuilder() : null;
        }

        @Override
        public final Builder evaluationResultIdentifier(EvaluationResultIdentifier evaluationResultIdentifier) {
            this.evaluationResultIdentifier = evaluationResultIdentifier;
            return this;
        }

        public final void setEvaluationResultIdentifier(EvaluationResultIdentifier.BuilderImpl evaluationResultIdentifier) {
            this.evaluationResultIdentifier = evaluationResultIdentifier != null ? evaluationResultIdentifier.build() : null;
        }

        public final Instant getConfigRuleInvokedTime() {
            return configRuleInvokedTime;
        }

        @Override
        public final Builder configRuleInvokedTime(Instant configRuleInvokedTime) {
            this.configRuleInvokedTime = configRuleInvokedTime;
            return this;
        }

        public final void setConfigRuleInvokedTime(Instant configRuleInvokedTime) {
            this.configRuleInvokedTime = configRuleInvokedTime;
        }

        public final Instant getResultRecordedTime() {
            return resultRecordedTime;
        }

        @Override
        public final Builder resultRecordedTime(Instant resultRecordedTime) {
            this.resultRecordedTime = resultRecordedTime;
            return this;
        }

        public final void setResultRecordedTime(Instant resultRecordedTime) {
            this.resultRecordedTime = resultRecordedTime;
        }

        public final String getAnnotation() {
            return annotation;
        }

        @Override
        public final Builder annotation(String annotation) {
            this.annotation = annotation;
            return this;
        }

        public final void setAnnotation(String annotation) {
            this.annotation = annotation;
        }

        @Override
        public ConformancePackEvaluationResult build() {
            return new ConformancePackEvaluationResult(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
