/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.config.model.ComplianceResourceTypesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Scope
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Scope> {
    private static final SdkField<List<String>> COMPLIANCE_RESOURCE_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ComplianceResourceTypes").getter(Scope.getter(Scope::complianceResourceTypes)).setter(Scope.setter(Builder::complianceResourceTypes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComplianceResourceTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> TAG_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TagKey").getter(Scope.getter(Scope::tagKey)).setter(Scope.setter(Builder::tagKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagKey").build()}).build();
    private static final SdkField<String> TAG_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TagValue").getter(Scope.getter(Scope::tagValue)).setter(Scope.setter(Builder::tagValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagValue").build()}).build();
    private static final SdkField<String> COMPLIANCE_RESOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ComplianceResourceId").getter(Scope.getter(Scope::complianceResourceId)).setter(Scope.setter(Builder::complianceResourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComplianceResourceId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPLIANCE_RESOURCE_TYPES_FIELD, TAG_KEY_FIELD, TAG_VALUE_FIELD, COMPLIANCE_RESOURCE_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> complianceResourceTypes;
    private final String tagKey;
    private final String tagValue;
    private final String complianceResourceId;

    private Scope(BuilderImpl builder) {
        this.complianceResourceTypes = builder.complianceResourceTypes;
        this.tagKey = builder.tagKey;
        this.tagValue = builder.tagValue;
        this.complianceResourceId = builder.complianceResourceId;
    }

    public boolean hasComplianceResourceTypes() {
        return this.complianceResourceTypes != null && !(this.complianceResourceTypes instanceof SdkAutoConstructList);
    }

    public List<String> complianceResourceTypes() {
        return this.complianceResourceTypes;
    }

    public String tagKey() {
        return this.tagKey;
    }

    public String tagValue() {
        return this.tagValue;
    }

    public String complianceResourceId() {
        return this.complianceResourceId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.complianceResourceTypes());
        hashCode = 31 * hashCode + Objects.hashCode(this.tagKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.tagValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.complianceResourceId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Scope)) {
            return false;
        }
        Scope other = (Scope)obj;
        return Objects.equals(this.complianceResourceTypes(), other.complianceResourceTypes()) && Objects.equals(this.tagKey(), other.tagKey()) && Objects.equals(this.tagValue(), other.tagValue()) && Objects.equals(this.complianceResourceId(), other.complianceResourceId());
    }

    public String toString() {
        return ToString.builder((String)"Scope").add("ComplianceResourceTypes", this.complianceResourceTypes()).add("TagKey", (Object)this.tagKey()).add("TagValue", (Object)this.tagValue()).add("ComplianceResourceId", (Object)this.complianceResourceId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ComplianceResourceTypes": {
                return Optional.ofNullable(clazz.cast(this.complianceResourceTypes()));
            }
            case "TagKey": {
                return Optional.ofNullable(clazz.cast(this.tagKey()));
            }
            case "TagValue": {
                return Optional.ofNullable(clazz.cast(this.tagValue()));
            }
            case "ComplianceResourceId": {
                return Optional.ofNullable(clazz.cast(this.complianceResourceId()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Scope, T> g) {
        return obj -> g.apply((Scope)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> complianceResourceTypes = DefaultSdkAutoConstructList.getInstance();
        private String tagKey;
        private String tagValue;
        private String complianceResourceId;

        private BuilderImpl() {
        }

        private BuilderImpl(Scope model) {
            this.complianceResourceTypes(model.complianceResourceTypes);
            this.tagKey(model.tagKey);
            this.tagValue(model.tagValue);
            this.complianceResourceId(model.complianceResourceId);
        }

        public final Collection<String> getComplianceResourceTypes() {
            return this.complianceResourceTypes;
        }

        @Override
        public final Builder complianceResourceTypes(Collection<String> complianceResourceTypes) {
            this.complianceResourceTypes = ComplianceResourceTypesCopier.copy(complianceResourceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder complianceResourceTypes(String ... complianceResourceTypes) {
            this.complianceResourceTypes(Arrays.asList(complianceResourceTypes));
            return this;
        }

        public final void setComplianceResourceTypes(Collection<String> complianceResourceTypes) {
            this.complianceResourceTypes = ComplianceResourceTypesCopier.copy(complianceResourceTypes);
        }

        public final String getTagKey() {
            return this.tagKey;
        }

        @Override
        public final Builder tagKey(String tagKey) {
            this.tagKey = tagKey;
            return this;
        }

        public final void setTagKey(String tagKey) {
            this.tagKey = tagKey;
        }

        public final String getTagValue() {
            return this.tagValue;
        }

        @Override
        public final Builder tagValue(String tagValue) {
            this.tagValue = tagValue;
            return this;
        }

        public final void setTagValue(String tagValue) {
            this.tagValue = tagValue;
        }

        public final String getComplianceResourceId() {
            return this.complianceResourceId;
        }

        @Override
        public final Builder complianceResourceId(String complianceResourceId) {
            this.complianceResourceId = complianceResourceId;
            return this;
        }

        public final void setComplianceResourceId(String complianceResourceId) {
            this.complianceResourceId = complianceResourceId;
        }

        public Scope build() {
            return new Scope(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Scope> {
        public Builder complianceResourceTypes(Collection<String> var1);

        public Builder complianceResourceTypes(String ... var1);

        public Builder tagKey(String var1);

        public Builder tagValue(String var1);

        public Builder complianceResourceId(String var1);
    }
}

