/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.config.model.ConfigResponse;
import software.amazon.awssdk.services.config.model.FailedRemediationExceptionBatch;
import software.amazon.awssdk.services.config.model.FailedRemediationExceptionBatchesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutRemediationExceptionsResponse
extends ConfigResponse
implements ToCopyableBuilder<Builder, PutRemediationExceptionsResponse> {
    private static final SdkField<List<FailedRemediationExceptionBatch>> FAILED_BATCHES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FailedBatches").getter(PutRemediationExceptionsResponse.getter(PutRemediationExceptionsResponse::failedBatches)).setter(PutRemediationExceptionsResponse.setter(Builder::failedBatches)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailedBatches").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FailedRemediationExceptionBatch::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FAILED_BATCHES_FIELD));
    private final List<FailedRemediationExceptionBatch> failedBatches;

    private PutRemediationExceptionsResponse(BuilderImpl builder) {
        super(builder);
        this.failedBatches = builder.failedBatches;
    }

    public boolean hasFailedBatches() {
        return this.failedBatches != null && !(this.failedBatches instanceof SdkAutoConstructList);
    }

    public List<FailedRemediationExceptionBatch> failedBatches() {
        return this.failedBatches;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.failedBatches());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutRemediationExceptionsResponse)) {
            return false;
        }
        PutRemediationExceptionsResponse other = (PutRemediationExceptionsResponse)((Object)obj);
        return Objects.equals(this.failedBatches(), other.failedBatches());
    }

    public String toString() {
        return ToString.builder((String)"PutRemediationExceptionsResponse").add("FailedBatches", this.failedBatches()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FailedBatches": {
                return Optional.ofNullable(clazz.cast(this.failedBatches()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutRemediationExceptionsResponse, T> g) {
        return obj -> g.apply((PutRemediationExceptionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConfigResponse.BuilderImpl
    implements Builder {
        private List<FailedRemediationExceptionBatch> failedBatches = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PutRemediationExceptionsResponse model) {
            super(model);
            this.failedBatches(model.failedBatches);
        }

        public final Collection<FailedRemediationExceptionBatch.Builder> getFailedBatches() {
            return this.failedBatches != null ? (Collection)this.failedBatches.stream().map(FailedRemediationExceptionBatch::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder failedBatches(Collection<FailedRemediationExceptionBatch> failedBatches) {
            this.failedBatches = FailedRemediationExceptionBatchesCopier.copy(failedBatches);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failedBatches(FailedRemediationExceptionBatch ... failedBatches) {
            this.failedBatches(Arrays.asList(failedBatches));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failedBatches(Consumer<FailedRemediationExceptionBatch.Builder> ... failedBatches) {
            this.failedBatches(Stream.of(failedBatches).map(c -> (FailedRemediationExceptionBatch)((FailedRemediationExceptionBatch.Builder)FailedRemediationExceptionBatch.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFailedBatches(Collection<FailedRemediationExceptionBatch.BuilderImpl> failedBatches) {
            this.failedBatches = FailedRemediationExceptionBatchesCopier.copyFromBuilder(failedBatches);
        }

        @Override
        public PutRemediationExceptionsResponse build() {
            return new PutRemediationExceptionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ConfigResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutRemediationExceptionsResponse> {
        public Builder failedBatches(Collection<FailedRemediationExceptionBatch> var1);

        public Builder failedBatches(FailedRemediationExceptionBatch ... var1);

        public Builder failedBatches(Consumer<FailedRemediationExceptionBatch.Builder> ... var1);
    }
}

