/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListDiscoveredResourcesRequest extends ConfigRequest implements
        ToCopyableBuilder<ListDiscoveredResourcesRequest.Builder, ListDiscoveredResourcesRequest> {
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceType").getter(getter(ListDiscoveredResourcesRequest::resourceTypeAsString))
            .setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceType").build()).build();

    private static final SdkField<List<String>> RESOURCE_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("resourceIds")
            .getter(getter(ListDiscoveredResourcesRequest::resourceIds))
            .setter(setter(Builder::resourceIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> RESOURCE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceName").getter(getter(ListDiscoveredResourcesRequest::resourceName))
            .setter(setter(Builder::resourceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceName").build()).build();

    private static final SdkField<Integer> LIMIT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("limit")
            .getter(getter(ListDiscoveredResourcesRequest::limit)).setter(setter(Builder::limit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("limit").build()).build();

    private static final SdkField<Boolean> INCLUDE_DELETED_RESOURCES_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("includeDeletedResources").getter(getter(ListDiscoveredResourcesRequest::includeDeletedResources))
            .setter(setter(Builder::includeDeletedResources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("includeDeletedResources").build())
            .build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListDiscoveredResourcesRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_TYPE_FIELD,
            RESOURCE_IDS_FIELD, RESOURCE_NAME_FIELD, LIMIT_FIELD, INCLUDE_DELETED_RESOURCES_FIELD, NEXT_TOKEN_FIELD));

    private final String resourceType;

    private final List<String> resourceIds;

    private final String resourceName;

    private final Integer limit;

    private final Boolean includeDeletedResources;

    private final String nextToken;

    private ListDiscoveredResourcesRequest(BuilderImpl builder) {
        super(builder);
        this.resourceType = builder.resourceType;
        this.resourceIds = builder.resourceIds;
        this.resourceName = builder.resourceName;
        this.limit = builder.limit;
        this.includeDeletedResources = builder.includeDeletedResources;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The type of resources that you want AWS Config to list in the response.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link ResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return The type of resources that you want AWS Config to list in the response.
     * @see ResourceType
     */
    public ResourceType resourceType() {
        return ResourceType.fromValue(resourceType);
    }

    /**
     * <p>
     * The type of resources that you want AWS Config to list in the response.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link ResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return The type of resources that you want AWS Config to list in the response.
     * @see ResourceType
     */
    public String resourceTypeAsString() {
        return resourceType;
    }

    /**
     * Returns true if the ResourceIds property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasResourceIds() {
        return resourceIds != null && !(resourceIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IDs of only those resources that you want AWS Config to list in the response. If you do not specify this
     * parameter, AWS Config lists all resources of the specified type that it has discovered.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasResourceIds()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The IDs of only those resources that you want AWS Config to list in the response. If you do not specify
     *         this parameter, AWS Config lists all resources of the specified type that it has discovered.
     */
    public List<String> resourceIds() {
        return resourceIds;
    }

    /**
     * <p>
     * The custom name of only those resources that you want AWS Config to list in the response. If you do not specify
     * this parameter, AWS Config lists all resources of the specified type that it has discovered.
     * </p>
     * 
     * @return The custom name of only those resources that you want AWS Config to list in the response. If you do not
     *         specify this parameter, AWS Config lists all resources of the specified type that it has discovered.
     */
    public String resourceName() {
        return resourceName;
    }

    /**
     * <p>
     * The maximum number of resource identifiers returned on each page. The default is 100. You cannot specify a number
     * greater than 100. If you specify 0, AWS Config uses the default.
     * </p>
     * 
     * @return The maximum number of resource identifiers returned on each page. The default is 100. You cannot specify
     *         a number greater than 100. If you specify 0, AWS Config uses the default.
     */
    public Integer limit() {
        return limit;
    }

    /**
     * <p>
     * Specifies whether AWS Config includes deleted resources in the results. By default, deleted resources are not
     * included.
     * </p>
     * 
     * @return Specifies whether AWS Config includes deleted resources in the results. By default, deleted resources are
     *         not included.
     */
    public Boolean includeDeletedResources() {
        return includeDeletedResources;
    }

    /**
     * <p>
     * The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a
     * paginated response.
     * </p>
     * 
     * @return The <code>nextToken</code> string returned on a previous page that you use to get the next page of
     *         results in a paginated response.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(resourceIds());
        hashCode = 31 * hashCode + Objects.hashCode(resourceName());
        hashCode = 31 * hashCode + Objects.hashCode(limit());
        hashCode = 31 * hashCode + Objects.hashCode(includeDeletedResources());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDiscoveredResourcesRequest)) {
            return false;
        }
        ListDiscoveredResourcesRequest other = (ListDiscoveredResourcesRequest) obj;
        return Objects.equals(resourceTypeAsString(), other.resourceTypeAsString())
                && Objects.equals(resourceIds(), other.resourceIds()) && Objects.equals(resourceName(), other.resourceName())
                && Objects.equals(limit(), other.limit())
                && Objects.equals(includeDeletedResources(), other.includeDeletedResources())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListDiscoveredResourcesRequest").add("ResourceType", resourceTypeAsString())
                .add("ResourceIds", resourceIds()).add("ResourceName", resourceName()).add("Limit", limit())
                .add("IncludeDeletedResources", includeDeletedResources()).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "resourceType":
            return Optional.ofNullable(clazz.cast(resourceTypeAsString()));
        case "resourceIds":
            return Optional.ofNullable(clazz.cast(resourceIds()));
        case "resourceName":
            return Optional.ofNullable(clazz.cast(resourceName()));
        case "limit":
            return Optional.ofNullable(clazz.cast(limit()));
        case "includeDeletedResources":
            return Optional.ofNullable(clazz.cast(includeDeletedResources()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListDiscoveredResourcesRequest, T> g) {
        return obj -> g.apply((ListDiscoveredResourcesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConfigRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListDiscoveredResourcesRequest> {
        /**
         * <p>
         * The type of resources that you want AWS Config to list in the response.
         * </p>
         * 
         * @param resourceType
         *        The type of resources that you want AWS Config to list in the response.
         * @see ResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceType
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * The type of resources that you want AWS Config to list in the response.
         * </p>
         * 
         * @param resourceType
         *        The type of resources that you want AWS Config to list in the response.
         * @see ResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceType
         */
        Builder resourceType(ResourceType resourceType);

        /**
         * <p>
         * The IDs of only those resources that you want AWS Config to list in the response. If you do not specify this
         * parameter, AWS Config lists all resources of the specified type that it has discovered.
         * </p>
         * 
         * @param resourceIds
         *        The IDs of only those resources that you want AWS Config to list in the response. If you do not
         *        specify this parameter, AWS Config lists all resources of the specified type that it has discovered.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceIds(Collection<String> resourceIds);

        /**
         * <p>
         * The IDs of only those resources that you want AWS Config to list in the response. If you do not specify this
         * parameter, AWS Config lists all resources of the specified type that it has discovered.
         * </p>
         * 
         * @param resourceIds
         *        The IDs of only those resources that you want AWS Config to list in the response. If you do not
         *        specify this parameter, AWS Config lists all resources of the specified type that it has discovered.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceIds(String... resourceIds);

        /**
         * <p>
         * The custom name of only those resources that you want AWS Config to list in the response. If you do not
         * specify this parameter, AWS Config lists all resources of the specified type that it has discovered.
         * </p>
         * 
         * @param resourceName
         *        The custom name of only those resources that you want AWS Config to list in the response. If you do
         *        not specify this parameter, AWS Config lists all resources of the specified type that it has
         *        discovered.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceName(String resourceName);

        /**
         * <p>
         * The maximum number of resource identifiers returned on each page. The default is 100. You cannot specify a
         * number greater than 100. If you specify 0, AWS Config uses the default.
         * </p>
         * 
         * @param limit
         *        The maximum number of resource identifiers returned on each page. The default is 100. You cannot
         *        specify a number greater than 100. If you specify 0, AWS Config uses the default.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder limit(Integer limit);

        /**
         * <p>
         * Specifies whether AWS Config includes deleted resources in the results. By default, deleted resources are not
         * included.
         * </p>
         * 
         * @param includeDeletedResources
         *        Specifies whether AWS Config includes deleted resources in the results. By default, deleted resources
         *        are not included.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeDeletedResources(Boolean includeDeletedResources);

        /**
         * <p>
         * The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in
         * a paginated response.
         * </p>
         * 
         * @param nextToken
         *        The <code>nextToken</code> string returned on a previous page that you use to get the next page of
         *        results in a paginated response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ConfigRequest.BuilderImpl implements Builder {
        private String resourceType;

        private List<String> resourceIds = DefaultSdkAutoConstructList.getInstance();

        private String resourceName;

        private Integer limit;

        private Boolean includeDeletedResources;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDiscoveredResourcesRequest model) {
            super(model);
            resourceType(model.resourceType);
            resourceIds(model.resourceIds);
            resourceName(model.resourceName);
            limit(model.limit);
            includeDeletedResources(model.includeDeletedResources);
            nextToken(model.nextToken);
        }

        public final String getResourceType() {
            return resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(ResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public final Collection<String> getResourceIds() {
            return resourceIds;
        }

        @Override
        public final Builder resourceIds(Collection<String> resourceIds) {
            this.resourceIds = ResourceIdListCopier.copy(resourceIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceIds(String... resourceIds) {
            resourceIds(Arrays.asList(resourceIds));
            return this;
        }

        public final void setResourceIds(Collection<String> resourceIds) {
            this.resourceIds = ResourceIdListCopier.copy(resourceIds);
        }

        public final String getResourceName() {
            return resourceName;
        }

        @Override
        public final Builder resourceName(String resourceName) {
            this.resourceName = resourceName;
            return this;
        }

        public final void setResourceName(String resourceName) {
            this.resourceName = resourceName;
        }

        public final Integer getLimit() {
            return limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        public final Boolean getIncludeDeletedResources() {
            return includeDeletedResources;
        }

        @Override
        public final Builder includeDeletedResources(Boolean includeDeletedResources) {
            this.includeDeletedResources = includeDeletedResources;
            return this;
        }

        public final void setIncludeDeletedResources(Boolean includeDeletedResources) {
            this.includeDeletedResources = includeDeletedResources;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListDiscoveredResourcesRequest build() {
            return new ListDiscoveredResourcesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
