/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * List of each of the failed remediation exceptions with specific reasons.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FailedRemediationExceptionBatch implements SdkPojo, Serializable,
        ToCopyableBuilder<FailedRemediationExceptionBatch.Builder, FailedRemediationExceptionBatch> {
    private static final SdkField<String> FAILURE_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FailureMessage").getter(getter(FailedRemediationExceptionBatch::failureMessage))
            .setter(setter(Builder::failureMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureMessage").build()).build();

    private static final SdkField<List<RemediationException>> FAILED_ITEMS_FIELD = SdkField
            .<List<RemediationException>> builder(MarshallingType.LIST)
            .memberName("FailedItems")
            .getter(getter(FailedRemediationExceptionBatch::failedItems))
            .setter(setter(Builder::failedItems))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailedItems").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RemediationException> builder(MarshallingType.SDK_POJO)
                                            .constructor(RemediationException::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FAILURE_MESSAGE_FIELD,
            FAILED_ITEMS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String failureMessage;

    private final List<RemediationException> failedItems;

    private FailedRemediationExceptionBatch(BuilderImpl builder) {
        this.failureMessage = builder.failureMessage;
        this.failedItems = builder.failedItems;
    }

    /**
     * <p>
     * Returns a failure message. For example, the auto-remediation has failed.
     * </p>
     * 
     * @return Returns a failure message. For example, the auto-remediation has failed.
     */
    public String failureMessage() {
        return failureMessage;
    }

    /**
     * Returns true if the FailedItems property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasFailedItems() {
        return failedItems != null && !(failedItems instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Returns remediation exception resource key object of the failed items.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasFailedItems()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Returns remediation exception resource key object of the failed items.
     */
    public List<RemediationException> failedItems() {
        return failedItems;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(failureMessage());
        hashCode = 31 * hashCode + Objects.hashCode(failedItems());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FailedRemediationExceptionBatch)) {
            return false;
        }
        FailedRemediationExceptionBatch other = (FailedRemediationExceptionBatch) obj;
        return Objects.equals(failureMessage(), other.failureMessage()) && Objects.equals(failedItems(), other.failedItems());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("FailedRemediationExceptionBatch").add("FailureMessage", failureMessage())
                .add("FailedItems", failedItems()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FailureMessage":
            return Optional.ofNullable(clazz.cast(failureMessage()));
        case "FailedItems":
            return Optional.ofNullable(clazz.cast(failedItems()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FailedRemediationExceptionBatch, T> g) {
        return obj -> g.apply((FailedRemediationExceptionBatch) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FailedRemediationExceptionBatch> {
        /**
         * <p>
         * Returns a failure message. For example, the auto-remediation has failed.
         * </p>
         * 
         * @param failureMessage
         *        Returns a failure message. For example, the auto-remediation has failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureMessage(String failureMessage);

        /**
         * <p>
         * Returns remediation exception resource key object of the failed items.
         * </p>
         * 
         * @param failedItems
         *        Returns remediation exception resource key object of the failed items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failedItems(Collection<RemediationException> failedItems);

        /**
         * <p>
         * Returns remediation exception resource key object of the failed items.
         * </p>
         * 
         * @param failedItems
         *        Returns remediation exception resource key object of the failed items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failedItems(RemediationException... failedItems);

        /**
         * <p>
         * Returns remediation exception resource key object of the failed items.
         * </p>
         * This is a convenience that creates an instance of the {@link List<RemediationException>.Builder} avoiding the
         * need to create one manually via {@link List<RemediationException>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<RemediationException>.Builder#build()} is called immediately
         * and its result is passed to {@link #failedItems(List<RemediationException>)}.
         * 
         * @param failedItems
         *        a consumer that will call methods on {@link List<RemediationException>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #failedItems(List<RemediationException>)
         */
        Builder failedItems(Consumer<RemediationException.Builder>... failedItems);
    }

    static final class BuilderImpl implements Builder {
        private String failureMessage;

        private List<RemediationException> failedItems = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(FailedRemediationExceptionBatch model) {
            failureMessage(model.failureMessage);
            failedItems(model.failedItems);
        }

        public final String getFailureMessage() {
            return failureMessage;
        }

        @Override
        public final Builder failureMessage(String failureMessage) {
            this.failureMessage = failureMessage;
            return this;
        }

        public final void setFailureMessage(String failureMessage) {
            this.failureMessage = failureMessage;
        }

        public final Collection<RemediationException.Builder> getFailedItems() {
            return failedItems != null ? failedItems.stream().map(RemediationException::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder failedItems(Collection<RemediationException> failedItems) {
            this.failedItems = RemediationExceptionsCopier.copy(failedItems);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failedItems(RemediationException... failedItems) {
            failedItems(Arrays.asList(failedItems));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failedItems(Consumer<RemediationException.Builder>... failedItems) {
            failedItems(Stream.of(failedItems).map(c -> RemediationException.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setFailedItems(Collection<RemediationException.BuilderImpl> failedItems) {
            this.failedItems = RemediationExceptionsCopier.copyFromBuilder(failedItems);
        }

        @Override
        public FailedRemediationExceptionBatch build() {
            return new FailedRemediationExceptionBatch(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
