/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeConfigurationAggregatorsRequest extends ConfigRequest implements
        ToCopyableBuilder<DescribeConfigurationAggregatorsRequest.Builder, DescribeConfigurationAggregatorsRequest> {
    private static final SdkField<List<String>> CONFIGURATION_AGGREGATOR_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ConfigurationAggregatorNames")
            .getter(getter(DescribeConfigurationAggregatorsRequest::configurationAggregatorNames))
            .setter(setter(Builder::configurationAggregatorNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationAggregatorNames")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeConfigurationAggregatorsRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Integer> LIMIT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Limit")
            .getter(getter(DescribeConfigurationAggregatorsRequest::limit)).setter(setter(Builder::limit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Limit").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CONFIGURATION_AGGREGATOR_NAMES_FIELD, NEXT_TOKEN_FIELD, LIMIT_FIELD));

    private final List<String> configurationAggregatorNames;

    private final String nextToken;

    private final Integer limit;

    private DescribeConfigurationAggregatorsRequest(BuilderImpl builder) {
        super(builder);
        this.configurationAggregatorNames = builder.configurationAggregatorNames;
        this.nextToken = builder.nextToken;
        this.limit = builder.limit;
    }

    /**
     * Returns true if the ConfigurationAggregatorNames property was specified by the sender (it may be empty), or false
     * if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the
     * AWS service.
     */
    public boolean hasConfigurationAggregatorNames() {
        return configurationAggregatorNames != null && !(configurationAggregatorNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The name of the configuration aggregators.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasConfigurationAggregatorNames()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The name of the configuration aggregators.
     */
    public List<String> configurationAggregatorNames() {
        return configurationAggregatorNames;
    }

    /**
     * <p>
     * The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a
     * paginated response.
     * </p>
     * 
     * @return The <code>nextToken</code> string returned on a previous page that you use to get the next page of
     *         results in a paginated response.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of configuration aggregators returned on each page. The default is maximum. If you specify 0,
     * AWS Config uses the default.
     * </p>
     * 
     * @return The maximum number of configuration aggregators returned on each page. The default is maximum. If you
     *         specify 0, AWS Config uses the default.
     */
    public Integer limit() {
        return limit;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(configurationAggregatorNames());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(limit());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeConfigurationAggregatorsRequest)) {
            return false;
        }
        DescribeConfigurationAggregatorsRequest other = (DescribeConfigurationAggregatorsRequest) obj;
        return Objects.equals(configurationAggregatorNames(), other.configurationAggregatorNames())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(limit(), other.limit());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeConfigurationAggregatorsRequest")
                .add("ConfigurationAggregatorNames", configurationAggregatorNames()).add("NextToken", nextToken())
                .add("Limit", limit()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConfigurationAggregatorNames":
            return Optional.ofNullable(clazz.cast(configurationAggregatorNames()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "Limit":
            return Optional.ofNullable(clazz.cast(limit()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeConfigurationAggregatorsRequest, T> g) {
        return obj -> g.apply((DescribeConfigurationAggregatorsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConfigRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeConfigurationAggregatorsRequest> {
        /**
         * <p>
         * The name of the configuration aggregators.
         * </p>
         * 
         * @param configurationAggregatorNames
         *        The name of the configuration aggregators.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationAggregatorNames(Collection<String> configurationAggregatorNames);

        /**
         * <p>
         * The name of the configuration aggregators.
         * </p>
         * 
         * @param configurationAggregatorNames
         *        The name of the configuration aggregators.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationAggregatorNames(String... configurationAggregatorNames);

        /**
         * <p>
         * The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in
         * a paginated response.
         * </p>
         * 
         * @param nextToken
         *        The <code>nextToken</code> string returned on a previous page that you use to get the next page of
         *        results in a paginated response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of configuration aggregators returned on each page. The default is maximum. If you specify
         * 0, AWS Config uses the default.
         * </p>
         * 
         * @param limit
         *        The maximum number of configuration aggregators returned on each page. The default is maximum. If you
         *        specify 0, AWS Config uses the default.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder limit(Integer limit);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ConfigRequest.BuilderImpl implements Builder {
        private List<String> configurationAggregatorNames = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private Integer limit;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeConfigurationAggregatorsRequest model) {
            super(model);
            configurationAggregatorNames(model.configurationAggregatorNames);
            nextToken(model.nextToken);
            limit(model.limit);
        }

        public final Collection<String> getConfigurationAggregatorNames() {
            return configurationAggregatorNames;
        }

        @Override
        public final Builder configurationAggregatorNames(Collection<String> configurationAggregatorNames) {
            this.configurationAggregatorNames = ConfigurationAggregatorNameListCopier.copy(configurationAggregatorNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configurationAggregatorNames(String... configurationAggregatorNames) {
            configurationAggregatorNames(Arrays.asList(configurationAggregatorNames));
            return this;
        }

        public final void setConfigurationAggregatorNames(Collection<String> configurationAggregatorNames) {
            this.configurationAggregatorNames = ConfigurationAggregatorNameListCopier.copy(configurationAggregatorNames);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getLimit() {
            return limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeConfigurationAggregatorsRequest build() {
            return new DescribeConfigurationAggregatorsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
