/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.config.model.ConfigResponse;
import software.amazon.awssdk.services.config.model.OrganizationConformancePack;
import software.amazon.awssdk.services.config.model.OrganizationConformancePacksCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeOrganizationConformancePacksResponse
extends ConfigResponse
implements ToCopyableBuilder<Builder, DescribeOrganizationConformancePacksResponse> {
    private static final SdkField<List<OrganizationConformancePack>> ORGANIZATION_CONFORMANCE_PACKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("OrganizationConformancePacks").getter(DescribeOrganizationConformancePacksResponse.getter(DescribeOrganizationConformancePacksResponse::organizationConformancePacks)).setter(DescribeOrganizationConformancePacksResponse.setter(Builder::organizationConformancePacks)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationConformancePacks").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(OrganizationConformancePack::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeOrganizationConformancePacksResponse.getter(DescribeOrganizationConformancePacksResponse::nextToken)).setter(DescribeOrganizationConformancePacksResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ORGANIZATION_CONFORMANCE_PACKS_FIELD, NEXT_TOKEN_FIELD));
    private final List<OrganizationConformancePack> organizationConformancePacks;
    private final String nextToken;

    private DescribeOrganizationConformancePacksResponse(BuilderImpl builder) {
        super(builder);
        this.organizationConformancePacks = builder.organizationConformancePacks;
        this.nextToken = builder.nextToken;
    }

    public boolean hasOrganizationConformancePacks() {
        return this.organizationConformancePacks != null && !(this.organizationConformancePacks instanceof SdkAutoConstructList);
    }

    public List<OrganizationConformancePack> organizationConformancePacks() {
        return this.organizationConformancePacks;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOrganizationConformancePacks() ? this.organizationConformancePacks() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeOrganizationConformancePacksResponse)) {
            return false;
        }
        DescribeOrganizationConformancePacksResponse other = (DescribeOrganizationConformancePacksResponse)((Object)obj);
        return this.hasOrganizationConformancePacks() == other.hasOrganizationConformancePacks() && Objects.equals(this.organizationConformancePacks(), other.organizationConformancePacks()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeOrganizationConformancePacksResponse").add("OrganizationConformancePacks", this.hasOrganizationConformancePacks() ? this.organizationConformancePacks() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OrganizationConformancePacks": {
                return Optional.ofNullable(clazz.cast(this.organizationConformancePacks()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeOrganizationConformancePacksResponse, T> g) {
        return obj -> g.apply((DescribeOrganizationConformancePacksResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConfigResponse.BuilderImpl
    implements Builder {
        private List<OrganizationConformancePack> organizationConformancePacks = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeOrganizationConformancePacksResponse model) {
            super(model);
            this.organizationConformancePacks(model.organizationConformancePacks);
            this.nextToken(model.nextToken);
        }

        public final Collection<OrganizationConformancePack.Builder> getOrganizationConformancePacks() {
            if (this.organizationConformancePacks instanceof SdkAutoConstructList) {
                return null;
            }
            return this.organizationConformancePacks != null ? (Collection)this.organizationConformancePacks.stream().map(OrganizationConformancePack::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder organizationConformancePacks(Collection<OrganizationConformancePack> organizationConformancePacks) {
            this.organizationConformancePacks = OrganizationConformancePacksCopier.copy(organizationConformancePacks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder organizationConformancePacks(OrganizationConformancePack ... organizationConformancePacks) {
            this.organizationConformancePacks(Arrays.asList(organizationConformancePacks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder organizationConformancePacks(Consumer<OrganizationConformancePack.Builder> ... organizationConformancePacks) {
            this.organizationConformancePacks(Stream.of(organizationConformancePacks).map(c -> (OrganizationConformancePack)((OrganizationConformancePack.Builder)OrganizationConformancePack.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setOrganizationConformancePacks(Collection<OrganizationConformancePack.BuilderImpl> organizationConformancePacks) {
            this.organizationConformancePacks = OrganizationConformancePacksCopier.copyFromBuilder(organizationConformancePacks);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeOrganizationConformancePacksResponse build() {
            return new DescribeOrganizationConformancePacksResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ConfigResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeOrganizationConformancePacksResponse> {
        public Builder organizationConformancePacks(Collection<OrganizationConformancePack> var1);

        public Builder organizationConformancePacks(OrganizationConformancePack ... var1);

        public Builder organizationConformancePacks(Consumer<OrganizationConformancePack.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

