/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The input for the <a>DescribeConfigurationRecorders</a> action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeConfigurationRecordersRequest extends ConfigRequest implements
        ToCopyableBuilder<DescribeConfigurationRecordersRequest.Builder, DescribeConfigurationRecordersRequest> {
    private static final SdkField<List<String>> CONFIGURATION_RECORDER_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ConfigurationRecorderNames")
            .getter(getter(DescribeConfigurationRecordersRequest::configurationRecorderNames))
            .setter(setter(Builder::configurationRecorderNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationRecorderNames").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(CONFIGURATION_RECORDER_NAMES_FIELD));

    private final List<String> configurationRecorderNames;

    private DescribeConfigurationRecordersRequest(BuilderImpl builder) {
        super(builder);
        this.configurationRecorderNames = builder.configurationRecorderNames;
    }

    /**
     * Returns true if the ConfigurationRecorderNames property was specified by the sender (it may be empty), or false
     * if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the
     * AWS service.
     */
    public boolean hasConfigurationRecorderNames() {
        return configurationRecorderNames != null && !(configurationRecorderNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of configuration recorder names.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasConfigurationRecorderNames()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of configuration recorder names.
     */
    public List<String> configurationRecorderNames() {
        return configurationRecorderNames;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasConfigurationRecorderNames() ? configurationRecorderNames() : null);
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeConfigurationRecordersRequest)) {
            return false;
        }
        DescribeConfigurationRecordersRequest other = (DescribeConfigurationRecordersRequest) obj;
        return hasConfigurationRecorderNames() == other.hasConfigurationRecorderNames()
                && Objects.equals(configurationRecorderNames(), other.configurationRecorderNames());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeConfigurationRecordersRequest")
                .add("ConfigurationRecorderNames", hasConfigurationRecorderNames() ? configurationRecorderNames() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConfigurationRecorderNames":
            return Optional.ofNullable(clazz.cast(configurationRecorderNames()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeConfigurationRecordersRequest, T> g) {
        return obj -> g.apply((DescribeConfigurationRecordersRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConfigRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeConfigurationRecordersRequest> {
        /**
         * <p>
         * A list of configuration recorder names.
         * </p>
         * 
         * @param configurationRecorderNames
         *        A list of configuration recorder names.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationRecorderNames(Collection<String> configurationRecorderNames);

        /**
         * <p>
         * A list of configuration recorder names.
         * </p>
         * 
         * @param configurationRecorderNames
         *        A list of configuration recorder names.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationRecorderNames(String... configurationRecorderNames);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ConfigRequest.BuilderImpl implements Builder {
        private List<String> configurationRecorderNames = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeConfigurationRecordersRequest model) {
            super(model);
            configurationRecorderNames(model.configurationRecorderNames);
        }

        public final Collection<String> getConfigurationRecorderNames() {
            if (configurationRecorderNames instanceof SdkAutoConstructList) {
                return null;
            }
            return configurationRecorderNames;
        }

        @Override
        public final Builder configurationRecorderNames(Collection<String> configurationRecorderNames) {
            this.configurationRecorderNames = ConfigurationRecorderNameListCopier.copy(configurationRecorderNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configurationRecorderNames(String... configurationRecorderNames) {
            configurationRecorderNames(Arrays.asList(configurationRecorderNames));
            return this;
        }

        public final void setConfigurationRecorderNames(Collection<String> configurationRecorderNames) {
            this.configurationRecorderNames = ConfigurationRecorderNameListCopier.copy(configurationRecorderNames);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeConfigurationRecordersRequest build() {
            return new DescribeConfigurationRecordersRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
