/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that represents the authorizations granted to aggregator accounts and regions.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AggregationAuthorization implements SdkPojo, Serializable,
        ToCopyableBuilder<AggregationAuthorization.Builder, AggregationAuthorization> {
    private static final SdkField<String> AGGREGATION_AUTHORIZATION_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AggregationAuthorizationArn")
            .getter(getter(AggregationAuthorization::aggregationAuthorizationArn))
            .setter(setter(Builder::aggregationAuthorizationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AggregationAuthorizationArn")
                    .build()).build();

    private static final SdkField<String> AUTHORIZED_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AuthorizedAccountId").getter(getter(AggregationAuthorization::authorizedAccountId))
            .setter(setter(Builder::authorizedAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthorizedAccountId").build())
            .build();

    private static final SdkField<String> AUTHORIZED_AWS_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AuthorizedAwsRegion").getter(getter(AggregationAuthorization::authorizedAwsRegion))
            .setter(setter(Builder::authorizedAwsRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthorizedAwsRegion").build())
            .build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(AggregationAuthorization::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            AGGREGATION_AUTHORIZATION_ARN_FIELD, AUTHORIZED_ACCOUNT_ID_FIELD, AUTHORIZED_AWS_REGION_FIELD, CREATION_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String aggregationAuthorizationArn;

    private final String authorizedAccountId;

    private final String authorizedAwsRegion;

    private final Instant creationTime;

    private AggregationAuthorization(BuilderImpl builder) {
        this.aggregationAuthorizationArn = builder.aggregationAuthorizationArn;
        this.authorizedAccountId = builder.authorizedAccountId;
        this.authorizedAwsRegion = builder.authorizedAwsRegion;
        this.creationTime = builder.creationTime;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the aggregation object.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the aggregation object.
     */
    public String aggregationAuthorizationArn() {
        return aggregationAuthorizationArn;
    }

    /**
     * <p>
     * The 12-digit account ID of the account authorized to aggregate data.
     * </p>
     * 
     * @return The 12-digit account ID of the account authorized to aggregate data.
     */
    public String authorizedAccountId() {
        return authorizedAccountId;
    }

    /**
     * <p>
     * The region authorized to collect aggregated data.
     * </p>
     * 
     * @return The region authorized to collect aggregated data.
     */
    public String authorizedAwsRegion() {
        return authorizedAwsRegion;
    }

    /**
     * <p>
     * The time stamp when the aggregation authorization was created.
     * </p>
     * 
     * @return The time stamp when the aggregation authorization was created.
     */
    public Instant creationTime() {
        return creationTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(aggregationAuthorizationArn());
        hashCode = 31 * hashCode + Objects.hashCode(authorizedAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(authorizedAwsRegion());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AggregationAuthorization)) {
            return false;
        }
        AggregationAuthorization other = (AggregationAuthorization) obj;
        return Objects.equals(aggregationAuthorizationArn(), other.aggregationAuthorizationArn())
                && Objects.equals(authorizedAccountId(), other.authorizedAccountId())
                && Objects.equals(authorizedAwsRegion(), other.authorizedAwsRegion())
                && Objects.equals(creationTime(), other.creationTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("AggregationAuthorization").add("AggregationAuthorizationArn", aggregationAuthorizationArn())
                .add("AuthorizedAccountId", authorizedAccountId()).add("AuthorizedAwsRegion", authorizedAwsRegion())
                .add("CreationTime", creationTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AggregationAuthorizationArn":
            return Optional.ofNullable(clazz.cast(aggregationAuthorizationArn()));
        case "AuthorizedAccountId":
            return Optional.ofNullable(clazz.cast(authorizedAccountId()));
        case "AuthorizedAwsRegion":
            return Optional.ofNullable(clazz.cast(authorizedAwsRegion()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AggregationAuthorization, T> g) {
        return obj -> g.apply((AggregationAuthorization) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AggregationAuthorization> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the aggregation object.
         * </p>
         * 
         * @param aggregationAuthorizationArn
         *        The Amazon Resource Name (ARN) of the aggregation object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aggregationAuthorizationArn(String aggregationAuthorizationArn);

        /**
         * <p>
         * The 12-digit account ID of the account authorized to aggregate data.
         * </p>
         * 
         * @param authorizedAccountId
         *        The 12-digit account ID of the account authorized to aggregate data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authorizedAccountId(String authorizedAccountId);

        /**
         * <p>
         * The region authorized to collect aggregated data.
         * </p>
         * 
         * @param authorizedAwsRegion
         *        The region authorized to collect aggregated data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authorizedAwsRegion(String authorizedAwsRegion);

        /**
         * <p>
         * The time stamp when the aggregation authorization was created.
         * </p>
         * 
         * @param creationTime
         *        The time stamp when the aggregation authorization was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);
    }

    static final class BuilderImpl implements Builder {
        private String aggregationAuthorizationArn;

        private String authorizedAccountId;

        private String authorizedAwsRegion;

        private Instant creationTime;

        private BuilderImpl() {
        }

        private BuilderImpl(AggregationAuthorization model) {
            aggregationAuthorizationArn(model.aggregationAuthorizationArn);
            authorizedAccountId(model.authorizedAccountId);
            authorizedAwsRegion(model.authorizedAwsRegion);
            creationTime(model.creationTime);
        }

        public final String getAggregationAuthorizationArn() {
            return aggregationAuthorizationArn;
        }

        @Override
        public final Builder aggregationAuthorizationArn(String aggregationAuthorizationArn) {
            this.aggregationAuthorizationArn = aggregationAuthorizationArn;
            return this;
        }

        public final void setAggregationAuthorizationArn(String aggregationAuthorizationArn) {
            this.aggregationAuthorizationArn = aggregationAuthorizationArn;
        }

        public final String getAuthorizedAccountId() {
            return authorizedAccountId;
        }

        @Override
        public final Builder authorizedAccountId(String authorizedAccountId) {
            this.authorizedAccountId = authorizedAccountId;
            return this;
        }

        public final void setAuthorizedAccountId(String authorizedAccountId) {
            this.authorizedAccountId = authorizedAccountId;
        }

        public final String getAuthorizedAwsRegion() {
            return authorizedAwsRegion;
        }

        @Override
        public final Builder authorizedAwsRegion(String authorizedAwsRegion) {
            this.authorizedAwsRegion = authorizedAwsRegion;
            return this;
        }

        public final void setAuthorizedAwsRegion(String authorizedAwsRegion) {
            this.authorizedAwsRegion = authorizedAwsRegion;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public AggregationAuthorization build() {
            return new AggregationAuthorization(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
