/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.config.model.ConfigResponse;
import software.amazon.awssdk.services.config.model.QueryInfo;
import software.amazon.awssdk.services.config.model.ResultsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SelectResourceConfigResponse
extends ConfigResponse
implements ToCopyableBuilder<Builder, SelectResourceConfigResponse> {
    private static final SdkField<List<String>> RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Results").getter(SelectResourceConfigResponse.getter(SelectResourceConfigResponse::results)).setter(SelectResourceConfigResponse.setter(Builder::results)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Results").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<QueryInfo> QUERY_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("QueryInfo").getter(SelectResourceConfigResponse.getter(SelectResourceConfigResponse::queryInfo)).setter(SelectResourceConfigResponse.setter(Builder::queryInfo)).constructor(QueryInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryInfo").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(SelectResourceConfigResponse.getter(SelectResourceConfigResponse::nextToken)).setter(SelectResourceConfigResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESULTS_FIELD, QUERY_INFO_FIELD, NEXT_TOKEN_FIELD));
    private final List<String> results;
    private final QueryInfo queryInfo;
    private final String nextToken;

    private SelectResourceConfigResponse(BuilderImpl builder) {
        super(builder);
        this.results = builder.results;
        this.queryInfo = builder.queryInfo;
        this.nextToken = builder.nextToken;
    }

    public boolean hasResults() {
        return this.results != null && !(this.results instanceof SdkAutoConstructList);
    }

    public List<String> results() {
        return this.results;
    }

    public QueryInfo queryInfo() {
        return this.queryInfo;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResults() ? this.results() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.queryInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SelectResourceConfigResponse)) {
            return false;
        }
        SelectResourceConfigResponse other = (SelectResourceConfigResponse)((Object)obj);
        return this.hasResults() == other.hasResults() && Objects.equals(this.results(), other.results()) && Objects.equals(this.queryInfo(), other.queryInfo()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"SelectResourceConfigResponse").add("Results", this.hasResults() ? this.results() : null).add("QueryInfo", (Object)this.queryInfo()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Results": {
                return Optional.ofNullable(clazz.cast(this.results()));
            }
            case "QueryInfo": {
                return Optional.ofNullable(clazz.cast(this.queryInfo()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SelectResourceConfigResponse, T> g) {
        return obj -> g.apply((SelectResourceConfigResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConfigResponse.BuilderImpl
    implements Builder {
        private List<String> results = DefaultSdkAutoConstructList.getInstance();
        private QueryInfo queryInfo;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(SelectResourceConfigResponse model) {
            super(model);
            this.results(model.results);
            this.queryInfo(model.queryInfo);
            this.nextToken(model.nextToken);
        }

        public final Collection<String> getResults() {
            if (this.results instanceof SdkAutoConstructList) {
                return null;
            }
            return this.results;
        }

        @Override
        public final Builder results(Collection<String> results) {
            this.results = ResultsCopier.copy(results);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder results(String ... results) {
            this.results(Arrays.asList(results));
            return this;
        }

        public final void setResults(Collection<String> results) {
            this.results = ResultsCopier.copy(results);
        }

        public final QueryInfo.Builder getQueryInfo() {
            return this.queryInfo != null ? this.queryInfo.toBuilder() : null;
        }

        @Override
        public final Builder queryInfo(QueryInfo queryInfo) {
            this.queryInfo = queryInfo;
            return this;
        }

        public final void setQueryInfo(QueryInfo.BuilderImpl queryInfo) {
            this.queryInfo = queryInfo != null ? queryInfo.build() : null;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public SelectResourceConfigResponse build() {
            return new SelectResourceConfigResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ConfigResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SelectResourceConfigResponse> {
        public Builder results(Collection<String> var1);

        public Builder results(String ... var1);

        public Builder queryInfo(QueryInfo var1);

        default public Builder queryInfo(Consumer<QueryInfo.Builder> queryInfo) {
            return this.queryInfo((QueryInfo)((QueryInfo.Builder)QueryInfo.builder().applyMutation(queryInfo)).build());
        }

        public Builder nextToken(String var1);
    }
}

