/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.config.model.ConfigResponse;
import software.amazon.awssdk.services.config.model.Evaluation;
import software.amazon.awssdk.services.config.model.EvaluationsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutEvaluationsResponse
extends ConfigResponse
implements ToCopyableBuilder<Builder, PutEvaluationsResponse> {
    private static final SdkField<List<Evaluation>> FAILED_EVALUATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FailedEvaluations").getter(PutEvaluationsResponse.getter(PutEvaluationsResponse::failedEvaluations)).setter(PutEvaluationsResponse.setter(Builder::failedEvaluations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailedEvaluations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Evaluation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FAILED_EVALUATIONS_FIELD));
    private final List<Evaluation> failedEvaluations;

    private PutEvaluationsResponse(BuilderImpl builder) {
        super(builder);
        this.failedEvaluations = builder.failedEvaluations;
    }

    public boolean hasFailedEvaluations() {
        return this.failedEvaluations != null && !(this.failedEvaluations instanceof SdkAutoConstructList);
    }

    public List<Evaluation> failedEvaluations() {
        return this.failedEvaluations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFailedEvaluations() ? this.failedEvaluations() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutEvaluationsResponse)) {
            return false;
        }
        PutEvaluationsResponse other = (PutEvaluationsResponse)((Object)obj);
        return this.hasFailedEvaluations() == other.hasFailedEvaluations() && Objects.equals(this.failedEvaluations(), other.failedEvaluations());
    }

    public String toString() {
        return ToString.builder((String)"PutEvaluationsResponse").add("FailedEvaluations", this.hasFailedEvaluations() ? this.failedEvaluations() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FailedEvaluations": {
                return Optional.ofNullable(clazz.cast(this.failedEvaluations()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutEvaluationsResponse, T> g) {
        return obj -> g.apply((PutEvaluationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConfigResponse.BuilderImpl
    implements Builder {
        private List<Evaluation> failedEvaluations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PutEvaluationsResponse model) {
            super(model);
            this.failedEvaluations(model.failedEvaluations);
        }

        public final Collection<Evaluation.Builder> getFailedEvaluations() {
            if (this.failedEvaluations instanceof SdkAutoConstructList) {
                return null;
            }
            return this.failedEvaluations != null ? (Collection)this.failedEvaluations.stream().map(Evaluation::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder failedEvaluations(Collection<Evaluation> failedEvaluations) {
            this.failedEvaluations = EvaluationsCopier.copy(failedEvaluations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failedEvaluations(Evaluation ... failedEvaluations) {
            this.failedEvaluations(Arrays.asList(failedEvaluations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failedEvaluations(Consumer<Evaluation.Builder> ... failedEvaluations) {
            this.failedEvaluations(Stream.of(failedEvaluations).map(c -> (Evaluation)((Evaluation.Builder)Evaluation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFailedEvaluations(Collection<Evaluation.BuilderImpl> failedEvaluations) {
            this.failedEvaluations = EvaluationsCopier.copyFromBuilder(failedEvaluations);
        }

        @Override
        public PutEvaluationsResponse build() {
            return new PutEvaluationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ConfigResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutEvaluationsResponse> {
        public Builder failedEvaluations(Collection<Evaluation> var1);

        public Builder failedEvaluations(Evaluation ... var1);

        public Builder failedEvaluations(Consumer<Evaluation.Builder> ... var1);
    }
}

