/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.config.model.ConfigResponse;
import software.amazon.awssdk.services.config.model.ConfigRule;
import software.amazon.awssdk.services.config.model.ConfigRulesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeConfigRulesResponse
extends ConfigResponse
implements ToCopyableBuilder<Builder, DescribeConfigRulesResponse> {
    private static final SdkField<List<ConfigRule>> CONFIG_RULES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ConfigRules").getter(DescribeConfigRulesResponse.getter(DescribeConfigRulesResponse::configRules)).setter(DescribeConfigRulesResponse.setter(Builder::configRules)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigRules").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ConfigRule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeConfigRulesResponse.getter(DescribeConfigRulesResponse::nextToken)).setter(DescribeConfigRulesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIG_RULES_FIELD, NEXT_TOKEN_FIELD));
    private final List<ConfigRule> configRules;
    private final String nextToken;

    private DescribeConfigRulesResponse(BuilderImpl builder) {
        super(builder);
        this.configRules = builder.configRules;
        this.nextToken = builder.nextToken;
    }

    public boolean hasConfigRules() {
        return this.configRules != null && !(this.configRules instanceof SdkAutoConstructList);
    }

    public List<ConfigRule> configRules() {
        return this.configRules;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.configRules());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeConfigRulesResponse)) {
            return false;
        }
        DescribeConfigRulesResponse other = (DescribeConfigRulesResponse)((Object)obj);
        return Objects.equals(this.configRules(), other.configRules()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeConfigRulesResponse").add("ConfigRules", this.configRules()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConfigRules": {
                return Optional.ofNullable(clazz.cast(this.configRules()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeConfigRulesResponse, T> g) {
        return obj -> g.apply((DescribeConfigRulesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConfigResponse.BuilderImpl
    implements Builder {
        private List<ConfigRule> configRules = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeConfigRulesResponse model) {
            super(model);
            this.configRules(model.configRules);
            this.nextToken(model.nextToken);
        }

        public final Collection<ConfigRule.Builder> getConfigRules() {
            return this.configRules != null ? (Collection)this.configRules.stream().map(ConfigRule::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder configRules(Collection<ConfigRule> configRules) {
            this.configRules = ConfigRulesCopier.copy(configRules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configRules(ConfigRule ... configRules) {
            this.configRules(Arrays.asList(configRules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configRules(Consumer<ConfigRule.Builder> ... configRules) {
            this.configRules(Stream.of(configRules).map(c -> (ConfigRule)((ConfigRule.Builder)ConfigRule.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setConfigRules(Collection<ConfigRule.BuilderImpl> configRules) {
            this.configRules = ConfigRulesCopier.copyFromBuilder(configRules);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeConfigRulesResponse build() {
            return new DescribeConfigRulesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ConfigResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeConfigRulesResponse> {
        public Builder configRules(Collection<ConfigRule> var1);

        public Builder configRules(ConfigRule ... var1);

        public Builder configRules(Consumer<ConfigRule.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

