/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeOrganizationConformancePacksResponse extends ConfigResponse implements
        ToCopyableBuilder<DescribeOrganizationConformancePacksResponse.Builder, DescribeOrganizationConformancePacksResponse> {
    private static final SdkField<List<OrganizationConformancePack>> ORGANIZATION_CONFORMANCE_PACKS_FIELD = SdkField
            .<List<OrganizationConformancePack>> builder(MarshallingType.LIST)
            .memberName("OrganizationConformancePacks")
            .getter(getter(DescribeOrganizationConformancePacksResponse::organizationConformancePacks))
            .setter(setter(Builder::organizationConformancePacks))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationConformancePacks")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<OrganizationConformancePack> builder(MarshallingType.SDK_POJO)
                                            .constructor(OrganizationConformancePack::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeOrganizationConformancePacksResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ORGANIZATION_CONFORMANCE_PACKS_FIELD, NEXT_TOKEN_FIELD));

    private final List<OrganizationConformancePack> organizationConformancePacks;

    private final String nextToken;

    private DescribeOrganizationConformancePacksResponse(BuilderImpl builder) {
        super(builder);
        this.organizationConformancePacks = builder.organizationConformancePacks;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the OrganizationConformancePacks property was specified by the sender (it may be empty), or false
     * if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the
     * AWS service.
     */
    public boolean hasOrganizationConformancePacks() {
        return organizationConformancePacks != null && !(organizationConformancePacks instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Returns a list of OrganizationConformancePacks objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasOrganizationConformancePacks()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Returns a list of OrganizationConformancePacks objects.
     */
    public List<OrganizationConformancePack> organizationConformancePacks() {
        return organizationConformancePacks;
    }

    /**
     * <p>
     * The nextToken string returned on a previous page that you use to get the next page of results in a paginated
     * response.
     * </p>
     * 
     * @return The nextToken string returned on a previous page that you use to get the next page of results in a
     *         paginated response.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasOrganizationConformancePacks() ? organizationConformancePacks() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeOrganizationConformancePacksResponse)) {
            return false;
        }
        DescribeOrganizationConformancePacksResponse other = (DescribeOrganizationConformancePacksResponse) obj;
        return hasOrganizationConformancePacks() == other.hasOrganizationConformancePacks()
                && Objects.equals(organizationConformancePacks(), other.organizationConformancePacks())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeOrganizationConformancePacksResponse")
                .add("OrganizationConformancePacks", hasOrganizationConformancePacks() ? organizationConformancePacks() : null)
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OrganizationConformancePacks":
            return Optional.ofNullable(clazz.cast(organizationConformancePacks()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeOrganizationConformancePacksResponse, T> g) {
        return obj -> g.apply((DescribeOrganizationConformancePacksResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConfigResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeOrganizationConformancePacksResponse> {
        /**
         * <p>
         * Returns a list of OrganizationConformancePacks objects.
         * </p>
         * 
         * @param organizationConformancePacks
         *        Returns a list of OrganizationConformancePacks objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder organizationConformancePacks(Collection<OrganizationConformancePack> organizationConformancePacks);

        /**
         * <p>
         * Returns a list of OrganizationConformancePacks objects.
         * </p>
         * 
         * @param organizationConformancePacks
         *        Returns a list of OrganizationConformancePacks objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder organizationConformancePacks(OrganizationConformancePack... organizationConformancePacks);

        /**
         * <p>
         * Returns a list of OrganizationConformancePacks objects.
         * </p>
         * This is a convenience that creates an instance of the {@link List<OrganizationConformancePack>.Builder}
         * avoiding the need to create one manually via {@link List<OrganizationConformancePack>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<OrganizationConformancePack>.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #organizationConformancePacks(List<OrganizationConformancePack>)}.
         * 
         * @param organizationConformancePacks
         *        a consumer that will call methods on {@link List<OrganizationConformancePack>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #organizationConformancePacks(List<OrganizationConformancePack>)
         */
        Builder organizationConformancePacks(Consumer<OrganizationConformancePack.Builder>... organizationConformancePacks);

        /**
         * <p>
         * The nextToken string returned on a previous page that you use to get the next page of results in a paginated
         * response.
         * </p>
         * 
         * @param nextToken
         *        The nextToken string returned on a previous page that you use to get the next page of results in a
         *        paginated response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ConfigResponse.BuilderImpl implements Builder {
        private List<OrganizationConformancePack> organizationConformancePacks = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeOrganizationConformancePacksResponse model) {
            super(model);
            organizationConformancePacks(model.organizationConformancePacks);
            nextToken(model.nextToken);
        }

        public final Collection<OrganizationConformancePack.Builder> getOrganizationConformancePacks() {
            if (organizationConformancePacks instanceof SdkAutoConstructList) {
                return null;
            }
            return organizationConformancePacks != null ? organizationConformancePacks.stream()
                    .map(OrganizationConformancePack::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder organizationConformancePacks(Collection<OrganizationConformancePack> organizationConformancePacks) {
            this.organizationConformancePacks = OrganizationConformancePacksCopier.copy(organizationConformancePacks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder organizationConformancePacks(OrganizationConformancePack... organizationConformancePacks) {
            organizationConformancePacks(Arrays.asList(organizationConformancePacks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder organizationConformancePacks(
                Consumer<OrganizationConformancePack.Builder>... organizationConformancePacks) {
            organizationConformancePacks(Stream.of(organizationConformancePacks)
                    .map(c -> OrganizationConformancePack.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setOrganizationConformancePacks(
                Collection<OrganizationConformancePack.BuilderImpl> organizationConformancePacks) {
            this.organizationConformancePacks = OrganizationConformancePacksCopier.copyFromBuilder(organizationConformancePacks);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeOrganizationConformancePacksResponse build() {
            return new DescribeOrganizationConformancePacksResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
