/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Status details of a conformance pack.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConformancePackStatusDetail implements SdkPojo, Serializable,
        ToCopyableBuilder<ConformancePackStatusDetail.Builder, ConformancePackStatusDetail> {
    private static final SdkField<String> CONFORMANCE_PACK_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConformancePackName").getter(getter(ConformancePackStatusDetail::conformancePackName))
            .setter(setter(Builder::conformancePackName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConformancePackName").build())
            .build();

    private static final SdkField<String> CONFORMANCE_PACK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConformancePackId").getter(getter(ConformancePackStatusDetail::conformancePackId))
            .setter(setter(Builder::conformancePackId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConformancePackId").build()).build();

    private static final SdkField<String> CONFORMANCE_PACK_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConformancePackArn").getter(getter(ConformancePackStatusDetail::conformancePackArn))
            .setter(setter(Builder::conformancePackArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConformancePackArn").build())
            .build();

    private static final SdkField<String> CONFORMANCE_PACK_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConformancePackState").getter(getter(ConformancePackStatusDetail::conformancePackStateAsString))
            .setter(setter(Builder::conformancePackState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConformancePackState").build())
            .build();

    private static final SdkField<String> STACK_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StackArn").getter(getter(ConformancePackStatusDetail::stackArn)).setter(setter(Builder::stackArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackArn").build()).build();

    private static final SdkField<String> CONFORMANCE_PACK_STATUS_REASON_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ConformancePackStatusReason")
            .getter(getter(ConformancePackStatusDetail::conformancePackStatusReason))
            .setter(setter(Builder::conformancePackStatusReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConformancePackStatusReason")
                    .build()).build();

    private static final SdkField<Instant> LAST_UPDATE_REQUESTED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastUpdateRequestedTime").getter(getter(ConformancePackStatusDetail::lastUpdateRequestedTime))
            .setter(setter(Builder::lastUpdateRequestedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdateRequestedTime").build())
            .build();

    private static final SdkField<Instant> LAST_UPDATE_COMPLETED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastUpdateCompletedTime").getter(getter(ConformancePackStatusDetail::lastUpdateCompletedTime))
            .setter(setter(Builder::lastUpdateCompletedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdateCompletedTime").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFORMANCE_PACK_NAME_FIELD,
            CONFORMANCE_PACK_ID_FIELD, CONFORMANCE_PACK_ARN_FIELD, CONFORMANCE_PACK_STATE_FIELD, STACK_ARN_FIELD,
            CONFORMANCE_PACK_STATUS_REASON_FIELD, LAST_UPDATE_REQUESTED_TIME_FIELD, LAST_UPDATE_COMPLETED_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String conformancePackName;

    private final String conformancePackId;

    private final String conformancePackArn;

    private final String conformancePackState;

    private final String stackArn;

    private final String conformancePackStatusReason;

    private final Instant lastUpdateRequestedTime;

    private final Instant lastUpdateCompletedTime;

    private ConformancePackStatusDetail(BuilderImpl builder) {
        this.conformancePackName = builder.conformancePackName;
        this.conformancePackId = builder.conformancePackId;
        this.conformancePackArn = builder.conformancePackArn;
        this.conformancePackState = builder.conformancePackState;
        this.stackArn = builder.stackArn;
        this.conformancePackStatusReason = builder.conformancePackStatusReason;
        this.lastUpdateRequestedTime = builder.lastUpdateRequestedTime;
        this.lastUpdateCompletedTime = builder.lastUpdateCompletedTime;
    }

    /**
     * <p>
     * Name of the conformance pack.
     * </p>
     * 
     * @return Name of the conformance pack.
     */
    public String conformancePackName() {
        return conformancePackName;
    }

    /**
     * <p>
     * ID of the conformance pack.
     * </p>
     * 
     * @return ID of the conformance pack.
     */
    public String conformancePackId() {
        return conformancePackId;
    }

    /**
     * <p>
     * Amazon Resource Name (ARN) of comformance pack.
     * </p>
     * 
     * @return Amazon Resource Name (ARN) of comformance pack.
     */
    public String conformancePackArn() {
        return conformancePackArn;
    }

    /**
     * <p>
     * Indicates deployment status of conformance pack.
     * </p>
     * <p>
     * AWS Config sets the state of the conformance pack to:
     * </p>
     * <ul>
     * <li>
     * <p>
     * CREATE_IN_PROGRESS when a conformance pack creation is in progress for an account.
     * </p>
     * </li>
     * <li>
     * <p>
     * CREATE_COMPLETE when a conformance pack has been successfully created in your account.
     * </p>
     * </li>
     * <li>
     * <p>
     * CREATE_FAILED when a conformance pack creation failed in your account.
     * </p>
     * </li>
     * <li>
     * <p>
     * DELETE_IN_PROGRESS when a conformance pack deletion is in progress.
     * </p>
     * </li>
     * <li>
     * <p>
     * DELETE_FAILED when a conformance pack deletion failed in your account.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #conformancePackState} will return {@link ConformancePackState#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #conformancePackStateAsString}.
     * </p>
     * 
     * @return Indicates deployment status of conformance pack.</p>
     *         <p>
     *         AWS Config sets the state of the conformance pack to:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         CREATE_IN_PROGRESS when a conformance pack creation is in progress for an account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CREATE_COMPLETE when a conformance pack has been successfully created in your account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CREATE_FAILED when a conformance pack creation failed in your account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DELETE_IN_PROGRESS when a conformance pack deletion is in progress.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DELETE_FAILED when a conformance pack deletion failed in your account.
     *         </p>
     *         </li>
     * @see ConformancePackState
     */
    public ConformancePackState conformancePackState() {
        return ConformancePackState.fromValue(conformancePackState);
    }

    /**
     * <p>
     * Indicates deployment status of conformance pack.
     * </p>
     * <p>
     * AWS Config sets the state of the conformance pack to:
     * </p>
     * <ul>
     * <li>
     * <p>
     * CREATE_IN_PROGRESS when a conformance pack creation is in progress for an account.
     * </p>
     * </li>
     * <li>
     * <p>
     * CREATE_COMPLETE when a conformance pack has been successfully created in your account.
     * </p>
     * </li>
     * <li>
     * <p>
     * CREATE_FAILED when a conformance pack creation failed in your account.
     * </p>
     * </li>
     * <li>
     * <p>
     * DELETE_IN_PROGRESS when a conformance pack deletion is in progress.
     * </p>
     * </li>
     * <li>
     * <p>
     * DELETE_FAILED when a conformance pack deletion failed in your account.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #conformancePackState} will return {@link ConformancePackState#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #conformancePackStateAsString}.
     * </p>
     * 
     * @return Indicates deployment status of conformance pack.</p>
     *         <p>
     *         AWS Config sets the state of the conformance pack to:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         CREATE_IN_PROGRESS when a conformance pack creation is in progress for an account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CREATE_COMPLETE when a conformance pack has been successfully created in your account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CREATE_FAILED when a conformance pack creation failed in your account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DELETE_IN_PROGRESS when a conformance pack deletion is in progress.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DELETE_FAILED when a conformance pack deletion failed in your account.
     *         </p>
     *         </li>
     * @see ConformancePackState
     */
    public String conformancePackStateAsString() {
        return conformancePackState;
    }

    /**
     * <p>
     * Amazon Resource Name (ARN) of AWS CloudFormation stack.
     * </p>
     * 
     * @return Amazon Resource Name (ARN) of AWS CloudFormation stack.
     */
    public String stackArn() {
        return stackArn;
    }

    /**
     * <p>
     * The reason of conformance pack creation failure.
     * </p>
     * 
     * @return The reason of conformance pack creation failure.
     */
    public String conformancePackStatusReason() {
        return conformancePackStatusReason;
    }

    /**
     * <p>
     * Last time when conformation pack creation and update was requested.
     * </p>
     * 
     * @return Last time when conformation pack creation and update was requested.
     */
    public Instant lastUpdateRequestedTime() {
        return lastUpdateRequestedTime;
    }

    /**
     * <p>
     * Last time when conformation pack creation and update was successful.
     * </p>
     * 
     * @return Last time when conformation pack creation and update was successful.
     */
    public Instant lastUpdateCompletedTime() {
        return lastUpdateCompletedTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(conformancePackName());
        hashCode = 31 * hashCode + Objects.hashCode(conformancePackId());
        hashCode = 31 * hashCode + Objects.hashCode(conformancePackArn());
        hashCode = 31 * hashCode + Objects.hashCode(conformancePackStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(stackArn());
        hashCode = 31 * hashCode + Objects.hashCode(conformancePackStatusReason());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdateRequestedTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdateCompletedTime());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConformancePackStatusDetail)) {
            return false;
        }
        ConformancePackStatusDetail other = (ConformancePackStatusDetail) obj;
        return Objects.equals(conformancePackName(), other.conformancePackName())
                && Objects.equals(conformancePackId(), other.conformancePackId())
                && Objects.equals(conformancePackArn(), other.conformancePackArn())
                && Objects.equals(conformancePackStateAsString(), other.conformancePackStateAsString())
                && Objects.equals(stackArn(), other.stackArn())
                && Objects.equals(conformancePackStatusReason(), other.conformancePackStatusReason())
                && Objects.equals(lastUpdateRequestedTime(), other.lastUpdateRequestedTime())
                && Objects.equals(lastUpdateCompletedTime(), other.lastUpdateCompletedTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ConformancePackStatusDetail").add("ConformancePackName", conformancePackName())
                .add("ConformancePackId", conformancePackId()).add("ConformancePackArn", conformancePackArn())
                .add("ConformancePackState", conformancePackStateAsString()).add("StackArn", stackArn())
                .add("ConformancePackStatusReason", conformancePackStatusReason())
                .add("LastUpdateRequestedTime", lastUpdateRequestedTime())
                .add("LastUpdateCompletedTime", lastUpdateCompletedTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConformancePackName":
            return Optional.ofNullable(clazz.cast(conformancePackName()));
        case "ConformancePackId":
            return Optional.ofNullable(clazz.cast(conformancePackId()));
        case "ConformancePackArn":
            return Optional.ofNullable(clazz.cast(conformancePackArn()));
        case "ConformancePackState":
            return Optional.ofNullable(clazz.cast(conformancePackStateAsString()));
        case "StackArn":
            return Optional.ofNullable(clazz.cast(stackArn()));
        case "ConformancePackStatusReason":
            return Optional.ofNullable(clazz.cast(conformancePackStatusReason()));
        case "LastUpdateRequestedTime":
            return Optional.ofNullable(clazz.cast(lastUpdateRequestedTime()));
        case "LastUpdateCompletedTime":
            return Optional.ofNullable(clazz.cast(lastUpdateCompletedTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConformancePackStatusDetail, T> g) {
        return obj -> g.apply((ConformancePackStatusDetail) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConformancePackStatusDetail> {
        /**
         * <p>
         * Name of the conformance pack.
         * </p>
         * 
         * @param conformancePackName
         *        Name of the conformance pack.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conformancePackName(String conformancePackName);

        /**
         * <p>
         * ID of the conformance pack.
         * </p>
         * 
         * @param conformancePackId
         *        ID of the conformance pack.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conformancePackId(String conformancePackId);

        /**
         * <p>
         * Amazon Resource Name (ARN) of comformance pack.
         * </p>
         * 
         * @param conformancePackArn
         *        Amazon Resource Name (ARN) of comformance pack.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conformancePackArn(String conformancePackArn);

        /**
         * <p>
         * Indicates deployment status of conformance pack.
         * </p>
         * <p>
         * AWS Config sets the state of the conformance pack to:
         * </p>
         * <ul>
         * <li>
         * <p>
         * CREATE_IN_PROGRESS when a conformance pack creation is in progress for an account.
         * </p>
         * </li>
         * <li>
         * <p>
         * CREATE_COMPLETE when a conformance pack has been successfully created in your account.
         * </p>
         * </li>
         * <li>
         * <p>
         * CREATE_FAILED when a conformance pack creation failed in your account.
         * </p>
         * </li>
         * <li>
         * <p>
         * DELETE_IN_PROGRESS when a conformance pack deletion is in progress.
         * </p>
         * </li>
         * <li>
         * <p>
         * DELETE_FAILED when a conformance pack deletion failed in your account.
         * </p>
         * </li>
         * </ul>
         * 
         * @param conformancePackState
         *        Indicates deployment status of conformance pack.</p>
         *        <p>
         *        AWS Config sets the state of the conformance pack to:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        CREATE_IN_PROGRESS when a conformance pack creation is in progress for an account.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        CREATE_COMPLETE when a conformance pack has been successfully created in your account.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        CREATE_FAILED when a conformance pack creation failed in your account.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        DELETE_IN_PROGRESS when a conformance pack deletion is in progress.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        DELETE_FAILED when a conformance pack deletion failed in your account.
         *        </p>
         *        </li>
         * @see ConformancePackState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConformancePackState
         */
        Builder conformancePackState(String conformancePackState);

        /**
         * <p>
         * Indicates deployment status of conformance pack.
         * </p>
         * <p>
         * AWS Config sets the state of the conformance pack to:
         * </p>
         * <ul>
         * <li>
         * <p>
         * CREATE_IN_PROGRESS when a conformance pack creation is in progress for an account.
         * </p>
         * </li>
         * <li>
         * <p>
         * CREATE_COMPLETE when a conformance pack has been successfully created in your account.
         * </p>
         * </li>
         * <li>
         * <p>
         * CREATE_FAILED when a conformance pack creation failed in your account.
         * </p>
         * </li>
         * <li>
         * <p>
         * DELETE_IN_PROGRESS when a conformance pack deletion is in progress.
         * </p>
         * </li>
         * <li>
         * <p>
         * DELETE_FAILED when a conformance pack deletion failed in your account.
         * </p>
         * </li>
         * </ul>
         * 
         * @param conformancePackState
         *        Indicates deployment status of conformance pack.</p>
         *        <p>
         *        AWS Config sets the state of the conformance pack to:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        CREATE_IN_PROGRESS when a conformance pack creation is in progress for an account.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        CREATE_COMPLETE when a conformance pack has been successfully created in your account.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        CREATE_FAILED when a conformance pack creation failed in your account.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        DELETE_IN_PROGRESS when a conformance pack deletion is in progress.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        DELETE_FAILED when a conformance pack deletion failed in your account.
         *        </p>
         *        </li>
         * @see ConformancePackState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConformancePackState
         */
        Builder conformancePackState(ConformancePackState conformancePackState);

        /**
         * <p>
         * Amazon Resource Name (ARN) of AWS CloudFormation stack.
         * </p>
         * 
         * @param stackArn
         *        Amazon Resource Name (ARN) of AWS CloudFormation stack.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackArn(String stackArn);

        /**
         * <p>
         * The reason of conformance pack creation failure.
         * </p>
         * 
         * @param conformancePackStatusReason
         *        The reason of conformance pack creation failure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conformancePackStatusReason(String conformancePackStatusReason);

        /**
         * <p>
         * Last time when conformation pack creation and update was requested.
         * </p>
         * 
         * @param lastUpdateRequestedTime
         *        Last time when conformation pack creation and update was requested.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdateRequestedTime(Instant lastUpdateRequestedTime);

        /**
         * <p>
         * Last time when conformation pack creation and update was successful.
         * </p>
         * 
         * @param lastUpdateCompletedTime
         *        Last time when conformation pack creation and update was successful.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdateCompletedTime(Instant lastUpdateCompletedTime);
    }

    static final class BuilderImpl implements Builder {
        private String conformancePackName;

        private String conformancePackId;

        private String conformancePackArn;

        private String conformancePackState;

        private String stackArn;

        private String conformancePackStatusReason;

        private Instant lastUpdateRequestedTime;

        private Instant lastUpdateCompletedTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ConformancePackStatusDetail model) {
            conformancePackName(model.conformancePackName);
            conformancePackId(model.conformancePackId);
            conformancePackArn(model.conformancePackArn);
            conformancePackState(model.conformancePackState);
            stackArn(model.stackArn);
            conformancePackStatusReason(model.conformancePackStatusReason);
            lastUpdateRequestedTime(model.lastUpdateRequestedTime);
            lastUpdateCompletedTime(model.lastUpdateCompletedTime);
        }

        public final String getConformancePackName() {
            return conformancePackName;
        }

        @Override
        public final Builder conformancePackName(String conformancePackName) {
            this.conformancePackName = conformancePackName;
            return this;
        }

        public final void setConformancePackName(String conformancePackName) {
            this.conformancePackName = conformancePackName;
        }

        public final String getConformancePackId() {
            return conformancePackId;
        }

        @Override
        public final Builder conformancePackId(String conformancePackId) {
            this.conformancePackId = conformancePackId;
            return this;
        }

        public final void setConformancePackId(String conformancePackId) {
            this.conformancePackId = conformancePackId;
        }

        public final String getConformancePackArn() {
            return conformancePackArn;
        }

        @Override
        public final Builder conformancePackArn(String conformancePackArn) {
            this.conformancePackArn = conformancePackArn;
            return this;
        }

        public final void setConformancePackArn(String conformancePackArn) {
            this.conformancePackArn = conformancePackArn;
        }

        public final String getConformancePackState() {
            return conformancePackState;
        }

        @Override
        public final Builder conformancePackState(String conformancePackState) {
            this.conformancePackState = conformancePackState;
            return this;
        }

        @Override
        public final Builder conformancePackState(ConformancePackState conformancePackState) {
            this.conformancePackState(conformancePackState == null ? null : conformancePackState.toString());
            return this;
        }

        public final void setConformancePackState(String conformancePackState) {
            this.conformancePackState = conformancePackState;
        }

        public final String getStackArn() {
            return stackArn;
        }

        @Override
        public final Builder stackArn(String stackArn) {
            this.stackArn = stackArn;
            return this;
        }

        public final void setStackArn(String stackArn) {
            this.stackArn = stackArn;
        }

        public final String getConformancePackStatusReason() {
            return conformancePackStatusReason;
        }

        @Override
        public final Builder conformancePackStatusReason(String conformancePackStatusReason) {
            this.conformancePackStatusReason = conformancePackStatusReason;
            return this;
        }

        public final void setConformancePackStatusReason(String conformancePackStatusReason) {
            this.conformancePackStatusReason = conformancePackStatusReason;
        }

        public final Instant getLastUpdateRequestedTime() {
            return lastUpdateRequestedTime;
        }

        @Override
        public final Builder lastUpdateRequestedTime(Instant lastUpdateRequestedTime) {
            this.lastUpdateRequestedTime = lastUpdateRequestedTime;
            return this;
        }

        public final void setLastUpdateRequestedTime(Instant lastUpdateRequestedTime) {
            this.lastUpdateRequestedTime = lastUpdateRequestedTime;
        }

        public final Instant getLastUpdateCompletedTime() {
            return lastUpdateCompletedTime;
        }

        @Override
        public final Builder lastUpdateCompletedTime(Instant lastUpdateCompletedTime) {
            this.lastUpdateCompletedTime = lastUpdateCompletedTime;
            return this;
        }

        public final void setLastUpdateCompletedTime(Instant lastUpdateCompletedTime) {
            this.lastUpdateCompletedTime = lastUpdateCompletedTime;
        }

        @Override
        public ConformancePackStatusDetail build() {
            return new ConformancePackStatusDetail(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
