/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetConformancePackComplianceSummaryResponse extends ConfigResponse implements
        ToCopyableBuilder<GetConformancePackComplianceSummaryResponse.Builder, GetConformancePackComplianceSummaryResponse> {
    private static final SdkField<List<ConformancePackComplianceSummary>> CONFORMANCE_PACK_COMPLIANCE_SUMMARY_LIST_FIELD = SdkField
            .<List<ConformancePackComplianceSummary>> builder(MarshallingType.LIST)
            .memberName("ConformancePackComplianceSummaryList")
            .getter(getter(GetConformancePackComplianceSummaryResponse::conformancePackComplianceSummaryList))
            .setter(setter(Builder::conformancePackComplianceSummaryList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("ConformancePackComplianceSummaryList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ConformancePackComplianceSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(ConformancePackComplianceSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(GetConformancePackComplianceSummaryResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CONFORMANCE_PACK_COMPLIANCE_SUMMARY_LIST_FIELD, NEXT_TOKEN_FIELD));

    private final List<ConformancePackComplianceSummary> conformancePackComplianceSummaryList;

    private final String nextToken;

    private GetConformancePackComplianceSummaryResponse(BuilderImpl builder) {
        super(builder);
        this.conformancePackComplianceSummaryList = builder.conformancePackComplianceSummaryList;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the ConformancePackComplianceSummaryList property was specified by the sender (it may be empty),
     * or false if the sender did not specify the value (it will be empty). For responses returned by the SDK, the
     * sender is the AWS service.
     */
    public boolean hasConformancePackComplianceSummaryList() {
        return conformancePackComplianceSummaryList != null
                && !(conformancePackComplianceSummaryList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <code>ConformancePackComplianceSummary</code> objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasConformancePackComplianceSummaryList()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of <code>ConformancePackComplianceSummary</code> objects.
     */
    public List<ConformancePackComplianceSummary> conformancePackComplianceSummaryList() {
        return conformancePackComplianceSummaryList;
    }

    /**
     * <p>
     * The nextToken string returned on a previous page that you use to get the next page of results in a paginated
     * response.
     * </p>
     * 
     * @return The nextToken string returned on a previous page that you use to get the next page of results in a
     *         paginated response.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode
                + Objects.hashCode(hasConformancePackComplianceSummaryList() ? conformancePackComplianceSummaryList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetConformancePackComplianceSummaryResponse)) {
            return false;
        }
        GetConformancePackComplianceSummaryResponse other = (GetConformancePackComplianceSummaryResponse) obj;
        return hasConformancePackComplianceSummaryList() == other.hasConformancePackComplianceSummaryList()
                && Objects.equals(conformancePackComplianceSummaryList(), other.conformancePackComplianceSummaryList())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString
                .builder("GetConformancePackComplianceSummaryResponse")
                .add("ConformancePackComplianceSummaryList",
                        hasConformancePackComplianceSummaryList() ? conformancePackComplianceSummaryList() : null)
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConformancePackComplianceSummaryList":
            return Optional.ofNullable(clazz.cast(conformancePackComplianceSummaryList()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetConformancePackComplianceSummaryResponse, T> g) {
        return obj -> g.apply((GetConformancePackComplianceSummaryResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConfigResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetConformancePackComplianceSummaryResponse> {
        /**
         * <p>
         * A list of <code>ConformancePackComplianceSummary</code> objects.
         * </p>
         * 
         * @param conformancePackComplianceSummaryList
         *        A list of <code>ConformancePackComplianceSummary</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conformancePackComplianceSummaryList(
                Collection<ConformancePackComplianceSummary> conformancePackComplianceSummaryList);

        /**
         * <p>
         * A list of <code>ConformancePackComplianceSummary</code> objects.
         * </p>
         * 
         * @param conformancePackComplianceSummaryList
         *        A list of <code>ConformancePackComplianceSummary</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conformancePackComplianceSummaryList(ConformancePackComplianceSummary... conformancePackComplianceSummaryList);

        /**
         * <p>
         * A list of <code>ConformancePackComplianceSummary</code> objects.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ConformancePackComplianceSummary>.Builder}
         * avoiding the need to create one manually via {@link List<ConformancePackComplianceSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ConformancePackComplianceSummary>.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #conformancePackComplianceSummaryList(List<ConformancePackComplianceSummary>)}.
         * 
         * @param conformancePackComplianceSummaryList
         *        a consumer that will call methods on {@link List<ConformancePackComplianceSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #conformancePackComplianceSummaryList(List<ConformancePackComplianceSummary>)
         */
        Builder conformancePackComplianceSummaryList(
                Consumer<ConformancePackComplianceSummary.Builder>... conformancePackComplianceSummaryList);

        /**
         * <p>
         * The nextToken string returned on a previous page that you use to get the next page of results in a paginated
         * response.
         * </p>
         * 
         * @param nextToken
         *        The nextToken string returned on a previous page that you use to get the next page of results in a
         *        paginated response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ConfigResponse.BuilderImpl implements Builder {
        private List<ConformancePackComplianceSummary> conformancePackComplianceSummaryList = DefaultSdkAutoConstructList
                .getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetConformancePackComplianceSummaryResponse model) {
            super(model);
            conformancePackComplianceSummaryList(model.conformancePackComplianceSummaryList);
            nextToken(model.nextToken);
        }

        public final Collection<ConformancePackComplianceSummary.Builder> getConformancePackComplianceSummaryList() {
            if (conformancePackComplianceSummaryList instanceof SdkAutoConstructList) {
                return null;
            }
            return conformancePackComplianceSummaryList != null ? conformancePackComplianceSummaryList.stream()
                    .map(ConformancePackComplianceSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder conformancePackComplianceSummaryList(
                Collection<ConformancePackComplianceSummary> conformancePackComplianceSummaryList) {
            this.conformancePackComplianceSummaryList = ConformancePackComplianceSummaryListCopier
                    .copy(conformancePackComplianceSummaryList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder conformancePackComplianceSummaryList(
                ConformancePackComplianceSummary... conformancePackComplianceSummaryList) {
            conformancePackComplianceSummaryList(Arrays.asList(conformancePackComplianceSummaryList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder conformancePackComplianceSummaryList(
                Consumer<ConformancePackComplianceSummary.Builder>... conformancePackComplianceSummaryList) {
            conformancePackComplianceSummaryList(Stream.of(conformancePackComplianceSummaryList)
                    .map(c -> ConformancePackComplianceSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setConformancePackComplianceSummaryList(
                Collection<ConformancePackComplianceSummary.BuilderImpl> conformancePackComplianceSummaryList) {
            this.conformancePackComplianceSummaryList = ConformancePackComplianceSummaryListCopier
                    .copyFromBuilder(conformancePackComplianceSummaryList);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public GetConformancePackComplianceSummaryResponse build() {
            return new GetConformancePackComplianceSummaryResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
